/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.component.embed;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.component.annotation.ComponentAnnotationLoader;
import org.xwiki.component.descriptor.ComponentDependency;
import org.xwiki.component.descriptor.ComponentDescriptor;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.component.descriptor.DefaultComponentDescriptor;
import org.xwiki.component.embed.GenericProvider;
import org.xwiki.component.embed.LifecycleHandler;
import org.xwiki.component.internal.RoleHint;
import org.xwiki.component.manager.ComponentEventManager;
import org.xwiki.component.manager.ComponentLifecycleException;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.manager.ComponentManagerInitializer;
import org.xwiki.component.manager.ComponentRepositoryException;
import org.xwiki.component.phase.Disposable;
import org.xwiki.component.util.ReflectionUtils;

public class EmbeddableComponentManager
implements ComponentManager {
    private ComponentEventManager eventManager;
    private ComponentManager parent;
    private Map<RoleHint<?>, ComponentEntry<?>> componentEntries = new ConcurrentHashMap();
    private Map<RoleHint<?>, ComponentEntry<Provider>> providerEntries = new ConcurrentHashMap();
    private Logger logger = LoggerFactory.getLogger(EmbeddableComponentManager.class);
    private ServiceLoader<LifecycleHandler> lifecycleHandlers = ServiceLoader.load(LifecycleHandler.class);

    public void initialize(ClassLoader classLoader) {
        ComponentAnnotationLoader loader = new ComponentAnnotationLoader();
        loader.initialize(this, classLoader);
        try {
            List<ComponentManagerInitializer> initializers = this.lookupList(ComponentManagerInitializer.class);
            for (ComponentManagerInitializer initializer : initializers) {
                initializer.initialize((ComponentManager)this);
            }
        }
        catch (ComponentLookupException e) {
            this.logger.error("Failed to lookup ComponentManagerInitializer components", (Throwable)e);
        }
    }

    public <T> boolean hasComponent(Class<T> role, String hint) {
        return this.componentEntries.containsKey(new RoleHint<T>(role, hint));
    }

    public <T> boolean hasComponent(Class<T> role) {
        return this.componentEntries.containsKey(new RoleHint<T>(role));
    }

    public <T> T lookup(Class<T> role) throws ComponentLookupException {
        return this.getComponentInstance(new RoleHint<T>(role));
    }

    public <T> T lookup(Class<T> role, String hint) throws ComponentLookupException {
        return this.getComponentInstance(new RoleHint<T>(role, hint));
    }

    public <T> List<T> lookupList(Class<T> role) throws ComponentLookupException {
        Map<String, T> objects = this.lookupMap(role);
        return objects.isEmpty() ? Collections.emptyList() : new ArrayList<T>(objects.values());
    }

    public <T> Map<String, T> lookupMap(Class<T> role) throws ComponentLookupException {
        HashMap<Object, Object> objects = new HashMap<Object, Object>();
        for (Map.Entry<RoleHint<?>, ComponentEntry<?>> entry : this.componentEntries.entrySet()) {
            RoleHint<?> roleHint = entry.getKey();
            if (roleHint.getRole() != role) continue;
            try {
                objects.put(roleHint.getHint(), this.getComponentInstance(entry.getValue()));
            }
            catch (Exception e) {
                throw new ComponentLookupException("Failed to lookup component [" + roleHint + "]", (Throwable)e);
            }
        }
        if (this.getParent() != null) {
            for (Map.Entry<RoleHint<Object>, ComponentEntry<Object>> entry : this.getParent().lookupMap(role).entrySet()) {
                if (objects.containsKey(entry.getKey())) continue;
                objects.put(entry.getKey(), entry.getValue());
            }
        }
        return objects;
    }

    public <T> ComponentDescriptor<T> getComponentDescriptor(Class<T> role, String hint) {
        ComponentEntry<?> componentEntry = this.componentEntries.get(new RoleHint<T>(role, hint));
        return componentEntry != null ? componentEntry.descriptor : null;
    }

    public <T> List<ComponentDescriptor<T>> getComponentDescriptorList(Class<T> role) {
        ArrayList<ComponentDescriptor<T>> results = new ArrayList<ComponentDescriptor<T>>();
        for (Map.Entry<RoleHint<?>, ComponentEntry<?>> entry : this.componentEntries.entrySet()) {
            if (entry.getKey().getRole() != role) continue;
            results.add(entry.getValue().descriptor);
        }
        return results;
    }

    public ComponentEventManager getComponentEventManager() {
        return this.eventManager;
    }

    public void setComponentEventManager(ComponentEventManager eventManager) {
        this.eventManager = eventManager;
    }

    public ComponentManager getParent() {
        return this.parent;
    }

    public void setParent(ComponentManager parentComponentManager) {
        this.parent = parentComponentManager;
    }

    private <T> T createInstance(ComponentDescriptor<T> descriptor) throws Exception {
        Object instance = descriptor.getImplementation().newInstance();
        for (ComponentDependency dependency : descriptor.getComponentDependencies()) {
            Field field;
            Class fieldRole;
            RoleHint roleHint;
            Provider provider;
            Object fieldValue = dependency.getMappingType() != null ? (Provider.class.isAssignableFrom(dependency.getMappingType()) ? ((provider = this.getProvider(roleHint = new RoleHint(fieldRole = ReflectionUtils.getLastGenericFieldType((Field)(field = instance.getClass().getDeclaredField(dependency.getName()))), dependency.getRoleHint()))) != null ? provider : new GenericProvider(this, new RoleHint(fieldRole))) : (Logger.class.isAssignableFrom(dependency.getMappingType()) ? LoggerFactory.getLogger(instance.getClass()) : (List.class.isAssignableFrom(dependency.getMappingType()) ? this.lookupList(dependency.getRole()) : (Map.class.isAssignableFrom(dependency.getMappingType()) ? this.lookupMap(dependency.getRole()) : this.lookup(dependency.getRole(), dependency.getRoleHint()))))) : this.lookup(dependency.getRole(), dependency.getRoleHint());
            if (fieldValue == null) continue;
            ReflectionUtils.setFieldValue(instance, (String)dependency.getName(), fieldValue);
        }
        for (LifecycleHandler lifecycleHandler : this.lifecycleHandlers) {
            lifecycleHandler.handle(instance, descriptor, this);
        }
        return instance;
    }

    private Provider getProvider(RoleHint roleHint) throws Exception {
        ComponentEntry<Provider> providerEntry = this.providerEntries.get(roleHint);
        Provider provider = providerEntry != null ? this.getComponentInstance(providerEntry) : null;
        return provider;
    }

    private <T> T getComponentInstance(RoleHint<T> roleHint) throws ComponentLookupException {
        Object instance;
        ComponentEntry<?> componentEntry = this.componentEntries.get(roleHint);
        if (componentEntry != null) {
            try {
                instance = this.getComponentInstance(componentEntry);
            }
            catch (Throwable e) {
                throw new ComponentLookupException(String.format("Failed to lookup component [%s] for role [%s] and hint [%s]", componentEntry.descriptor.getImplementation().getName(), roleHint.getRole().getName(), roleHint.getHint()), e);
            }
        } else if (this.getParent() != null) {
            instance = this.getParent().lookup(roleHint.getRole(), roleHint.getHint());
        } else {
            throw new ComponentLookupException("Can't find descriptor for the component [" + roleHint + "]");
        }
        return (T)instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T getComponentInstance(ComponentEntry<T> componentEntry) throws Exception {
        Object instance;
        ComponentDescriptor descriptor = componentEntry.descriptor;
        if (descriptor.getInstantiationStrategy() == ComponentInstantiationStrategy.SINGLETON) {
            if (componentEntry.instance != null) {
                instance = componentEntry.instance;
            } else {
                ComponentEntry<T> componentEntry2 = componentEntry;
                synchronized (componentEntry2) {
                    if (componentEntry.instance != null) {
                        instance = componentEntry.instance;
                    } else {
                        componentEntry.instance = this.createInstance(descriptor);
                        instance = componentEntry.instance;
                    }
                }
            }
        } else {
            instance = this.createInstance(descriptor);
        }
        return (T)instance;
    }

    public <T> void registerComponent(ComponentDescriptor<T> componentDescriptor) throws ComponentRepositoryException {
        this.registerComponent(componentDescriptor, null);
    }

    public <T> void registerComponent(ComponentDescriptor<T> componentDescriptor, T componentInstance) {
        RoleHint roleHint = new RoleHint(componentDescriptor.getRole(), componentDescriptor.getRoleHint());
        this.removeComponentWithoutException(roleHint);
        this.addComponent(roleHint, (ComponentDescriptor<T>)new DefaultComponentDescriptor(componentDescriptor), componentInstance);
    }

    private <T> void addComponent(RoleHint<T> roleHint, ComponentDescriptor<T> descriptor, T instance) {
        ComponentEntry<T> componentEntry = new ComponentEntry<T>(descriptor, instance);
        this.componentEntries.put(roleHint, componentEntry);
        if (Provider.class.isAssignableFrom(descriptor.getRole())) {
            Provider provider = (Provider)instance;
            Class roleClass = ReflectionUtils.getLastGenericClassType((Class)descriptor.getImplementation(), Provider.class);
            this.providerEntries.put(new RoleHint(roleClass, descriptor.getRoleHint()), componentEntry);
        }
        if (this.eventManager != null) {
            this.eventManager.notifyComponentRegistered(descriptor, (ComponentManager)this);
        }
    }

    public <T> void unregisterComponent(Class<T> role, String hint) {
        RoleHint<T> roleHint = new RoleHint<T>(role, hint);
        this.removeComponentWithoutException(roleHint);
    }

    public <T> void release(T component) throws ComponentLifecycleException {
        RoleHint<?> key = null;
        ComponentDescriptor oldDescriptor = null;
        for (Map.Entry<RoleHint<?>, ComponentEntry<?>> entry : this.componentEntries.entrySet()) {
            if (entry.getValue().instance != component) continue;
            key = entry.getKey();
            oldDescriptor = entry.getValue().descriptor;
            break;
        }
        if (key != null) {
            this.removeComponent(key);
            this.addComponent(key, oldDescriptor, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseInstance(ComponentEntry<?> componentEntry) throws ComponentLifecycleException {
        ComponentEntry<?> componentEntry2 = componentEntry;
        synchronized (componentEntry2) {
            Object instance = componentEntry.instance;
            if (instance instanceof Disposable) {
                ((Disposable)instance).dispose();
            }
            componentEntry.instance = null;
        }
    }

    private void releaseComponentDescriptor(ComponentEntry<?> componentEntry) throws ComponentLifecycleException {
        ComponentDescriptor descriptor = componentEntry.descriptor;
        if (Provider.class.isAssignableFrom(descriptor.getRole())) {
            Class roleClass = ReflectionUtils.getLastGenericClassType((Class)descriptor.getImplementation(), Provider.class);
            this.providerEntries.remove(new RoleHint(roleClass, descriptor.getRoleHint()));
        }
    }

    private void releaseComponentEntry(ComponentEntry<?> componentEntry) throws ComponentLifecycleException {
        this.releaseInstance(componentEntry);
        this.releaseComponentDescriptor(componentEntry);
    }

    private void removeComponent(RoleHint<?> roleHint) throws ComponentLifecycleException {
        ComponentEntry<?> componentEntry = this.componentEntries.remove(roleHint);
        if (componentEntry != null) {
            ComponentDescriptor oldDescriptor = componentEntry.descriptor;
            this.releaseComponentEntry(componentEntry);
            if (this.eventManager != null && oldDescriptor != null) {
                this.eventManager.notifyComponentUnregistered(oldDescriptor, (ComponentManager)this);
            }
        }
    }

    private <T> void removeComponentWithoutException(RoleHint<T> roleHint) {
        try {
            this.removeComponent(roleHint);
        }
        catch (Exception e) {
            this.logger.warn("Instance released but disposal failed. Some resources may not have been released.", (Throwable)e);
        }
    }

    private static class ComponentEntry<R> {
        public final ComponentDescriptor<R> descriptor;
        public volatile R instance;

        public ComponentEntry(ComponentDescriptor<R> descriptor, R instance) {
            this.descriptor = descriptor;
            this.instance = instance;
        }
    }
}

