/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.component.embed;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.inject.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.collection.internal.PriorityEntries;
import org.xwiki.component.annotation.ComponentAnnotationLoader;
import org.xwiki.component.annotation.DisposePriority;
import org.xwiki.component.descriptor.ComponentDependency;
import org.xwiki.component.descriptor.ComponentDescriptor;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.component.descriptor.DefaultComponentDescriptor;
import org.xwiki.component.embed.GenericProvider;
import org.xwiki.component.embed.LifecycleHandler;
import org.xwiki.component.internal.RoleHint;
import org.xwiki.component.manager.ComponentEventManager;
import org.xwiki.component.manager.ComponentLifecycleException;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.manager.ComponentManagerInitializer;
import org.xwiki.component.manager.ComponentRepositoryException;
import org.xwiki.component.manager.NamespacedComponentManager;
import org.xwiki.component.phase.Disposable;
import org.xwiki.component.util.ReflectionUtils;

public class EmbeddableComponentManager
implements NamespacedComponentManager,
Disposable {
    private static final Logger SHUTDOWN_LOGGER = LoggerFactory.getLogger((String)"org.xwiki.shutdown");
    private String namespace;
    private ComponentEventManager eventManager;
    private ComponentManager parent;
    private ConcurrentMap<Type, ComponentEntries> componentEntries = new ConcurrentHashMap<Type, ComponentEntries>();
    private Logger logger = LoggerFactory.getLogger(EmbeddableComponentManager.class);
    private ServiceLoader<LifecycleHandler> lifecycleHandlers = ServiceLoader.load(LifecycleHandler.class);

    public EmbeddableComponentManager() {
        this.registerThis();
    }

    public EmbeddableComponentManager(String namespace) {
        this.registerThis();
        this.namespace = namespace;
    }

    public String getNamespace() {
        return this.namespace;
    }

    private void registerThis() {
        DefaultComponentDescriptor cd = new DefaultComponentDescriptor();
        cd.setRoleType(ComponentManager.class);
        this.registerComponent((ComponentDescriptor)cd, (Object)this);
    }

    public void initialize(ClassLoader classLoader) {
        ComponentAnnotationLoader loader = new ComponentAnnotationLoader();
        loader.initialize((ComponentManager)this, classLoader);
        try {
            List initializers = this.getInstanceList((Type)((Object)ComponentManagerInitializer.class));
            for (ComponentManagerInitializer initializer : initializers) {
                initializer.initialize((ComponentManager)this);
            }
        }
        catch (ComponentLookupException e) {
            this.logger.error("Failed to lookup ComponentManagerInitializer components", (Throwable)e);
        }
    }

    public boolean hasComponent(Type role) {
        return this.hasComponent(role, null);
    }

    public boolean hasComponent(Type roleType, String roleHint) {
        if (this.getComponentEntry(roleType, roleHint) != null) {
            return true;
        }
        return this.getParent() != null ? this.getParent().hasComponent(roleType, roleHint) : false;
    }

    public <T> T getInstance(Type roleType) throws ComponentLookupException {
        return this.getInstance(roleType, null);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <T> T getInstance(Type roleType, String roleHint) throws ComponentLookupException {
        void var3_9;
        ComponentEntry<?> componentEntry = this.getComponentEntry(roleType, roleHint);
        if (componentEntry == null) {
            if (this.getParent() == null) throw new ComponentLookupException("Can't find descriptor for the component with type [" + roleType + "] and hint [" + roleHint + "]");
            Object object = this.getParent().getInstance(roleType, roleHint);
            return var3_9;
        } else if (this.getParent() != null) {
            ComponentDescriptor parentDescriptor = this.getParent().getComponentDescriptor(roleType, roleHint);
            if (parentDescriptor != null && parentDescriptor.getRoleHintPriority() < componentEntry.descriptor.getRoleHintPriority()) {
                Object object = this.getParent().getInstance(roleType, roleHint);
                return var3_9;
            } else {
                Object obj = this.getInstance(componentEntry);
            }
            return var3_9;
        } else {
            Object obj = this.getInstance(componentEntry);
        }
        return var3_9;
    }

    private <T> T getInstance(ComponentEntry<T> componentEntry) throws ComponentLookupException {
        try {
            return this.getComponentInstance(componentEntry);
        }
        catch (Throwable e) {
            throw new ComponentLookupException(String.format("Failed to lookup component [%s] identified by type [%s] and hint [%s]", componentEntry.descriptor.getImplementation().getName(), componentEntry.descriptor.getRoleType(), componentEntry.descriptor.getRoleHint()), e);
        }
    }

    public <T> List<T> getInstanceList(Type role) throws ComponentLookupException {
        Map<String, T> objects = this.getInstanceMap(role);
        return objects.isEmpty() ? Collections.emptyList() : new ArrayList<T>(objects.values());
    }

    private <T> List<ComponentDescriptor<T>> getParentDescriptors(Type roleType) {
        return this.getParent() != null ? this.getParent().getComponentDescriptorList(roleType) : Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> Map<String, T> getInstanceMap(Type roleType) throws ComponentLookupException {
        Map<String, Object> entries;
        ComponentEntries localEntries = (ComponentEntries)((Object)this.componentEntries.get(roleType));
        if (localEntries == null || localEntries.isEmpty()) {
            entries = this.getParent() != null ? this.getParent().getInstanceMap(roleType) : Collections.emptyMap();
        } else {
            localEntries.getLock().readLock().lock();
            try {
                List<ComponentDescriptor<T>> parentDescriptors = this.getParentDescriptors(roleType);
                if (!parentDescriptors.isEmpty()) {
                    ComponentEntries<Object> mergedEntries = new ComponentEntries<Object>(localEntries.size() + parentDescriptors.size());
                    mergedEntries.putAll(localEntries);
                    for (ComponentDescriptor<T> parentDescriptor : parentDescriptors) {
                        mergedEntries.put(parentDescriptor, this.getParent().getInstance(roleType, parentDescriptor.getRoleHint()));
                    }
                    entries = this.toInstanceMap(mergedEntries);
                } else {
                    entries = this.toInstanceMap(localEntries);
                }
            }
            finally {
                localEntries.getLock().readLock().unlock();
            }
        }
        return entries;
    }

    private <T> Map<String, T> toInstanceMap(ComponentEntries<T> componentEntries) throws ComponentLookupException {
        LinkedHashMap<String, T> map = new LinkedHashMap<String, T>();
        for (ComponentEntry roleEntry : componentEntries.getSorted()) {
            T instance = this.getMapInstance(roleEntry);
            if (instance == null) continue;
            map.put(roleEntry.descriptor.getRoleHint(), instance);
        }
        return map;
    }

    private <T> T getMapInstance(ComponentEntry<T> roleEntry) throws ComponentLookupException {
        try {
            return this.getComponentInstance(roleEntry);
        }
        catch (Error | Exception e) {
            if (roleEntry.descriptor.isMandatory()) {
                throw new ComponentLookupException("Failed to lookup component with type [" + roleEntry.descriptor.getRoleType() + "] and hint [" + roleEntry.descriptor.getRoleHint() + "]", e);
            }
            this.logger.error("Failed to lookup component with type [{}] and hint [{}]", new Object[]{roleEntry.descriptor.getRoleType(), roleEntry.descriptor.getRoleHint(), e});
            return null;
        }
    }

    private ComponentEntry<?> getComponentEntry(Type role, String hint) {
        ComponentEntries entries = (ComponentEntries)((Object)this.componentEntries.get(role));
        if (entries != null) {
            return (ComponentEntry)entries.get(hint != null ? hint : "default");
        }
        return null;
    }

    public <T> ComponentDescriptor<T> getComponentDescriptor(Type role, String hint) {
        ComponentDescriptor result = null;
        ComponentEntry<?> componentEntry = this.getComponentEntry(role, hint);
        if (componentEntry == null) {
            if (this.getParent() != null) {
                result = this.getParent().getComponentDescriptor(role, hint);
            }
        } else {
            result = componentEntry.descriptor;
        }
        return result;
    }

    public <T> List<ComponentDescriptor<T>> getComponentDescriptorList(Type roleType) {
        List<Object> descriptors;
        ComponentEntries localEntries = (ComponentEntries)((Object)this.componentEntries.get(roleType));
        List<ComponentDescriptor<T>> parentDescriptors = this.getParentDescriptors(roleType);
        if (localEntries == null || localEntries.isEmpty()) {
            descriptors = !parentDescriptors.isEmpty() ? parentDescriptors : Collections.emptyList();
        } else if (!parentDescriptors.isEmpty()) {
            ComponentEntries<T> mergedEntries = new ComponentEntries<T>(localEntries.size() + parentDescriptors.size());
            mergedEntries.putAll(localEntries);
            for (ComponentDescriptor<T> parentDescriptor : parentDescriptors) {
                mergedEntries.put(parentDescriptor);
            }
            descriptors = mergedEntries.toComponentDescriptorList();
        } else {
            descriptors = localEntries.toComponentDescriptorList();
        }
        return descriptors;
    }

    public ComponentEventManager getComponentEventManager() {
        return this.eventManager;
    }

    public void setComponentEventManager(ComponentEventManager eventManager) {
        this.eventManager = eventManager;
    }

    public ComponentManager getParent() {
        return this.parent;
    }

    public void setParent(ComponentManager parentComponentManager) {
        this.parent = parentComponentManager;
    }

    private <T> T createInstance(ComponentDescriptor<T> descriptor) throws Exception {
        Object instance = descriptor.getImplementation().newInstance();
        for (ComponentDependency dependency : descriptor.getComponentDependencies()) {
            Object fieldValue = this.getDependencyInstance(descriptor, instance, dependency);
            if (fieldValue == null) continue;
            ReflectionUtils.setFieldValue(instance, (String)dependency.getName(), (Object)fieldValue);
        }
        for (LifecycleHandler lifecycleHandler : this.lifecycleHandlers) {
            lifecycleHandler.handle(instance, descriptor, (ComponentManager)this);
        }
        return instance;
    }

    protected Object getDependencyInstance(ComponentDescriptor<?> descriptor, Object parentInstance, ComponentDependency<?> dependency) throws ComponentLookupException {
        Class dependencyRoleClass = ReflectionUtils.getTypeClass((Type)dependency.getRoleType());
        Object fieldValue = dependencyRoleClass.isAssignableFrom(Logger.class) ? this.createLogger(parentInstance.getClass()) : (dependencyRoleClass.isAssignableFrom(List.class) ? this.getInstanceList(ReflectionUtils.getLastTypeGenericArgument((Type)dependency.getRoleType())) : (dependencyRoleClass.isAssignableFrom(Map.class) ? this.getInstanceMap(ReflectionUtils.getLastTypeGenericArgument((Type)dependency.getRoleType())) : (dependencyRoleClass.isAssignableFrom(Provider.class) ? (this.hasComponent(dependency.getRoleType(), dependency.getRoleHint()) ? this.getInstance(dependency.getRoleType(), dependency.getRoleHint()) : this.createGenericProvider(descriptor, dependency)) : (dependencyRoleClass.isAssignableFrom(ComponentDescriptor.class) ? new DefaultComponentDescriptor(descriptor) : this.getInstance(dependency.getRoleType(), dependency.getRoleHint())))));
        return fieldValue;
    }

    protected Provider<?> createGenericProvider(ComponentDescriptor<?> descriptor, ComponentDependency<?> dependency) {
        return new GenericProvider((ComponentManager)this, new RoleHint(ReflectionUtils.getLastTypeGenericArgument((Type)dependency.getRoleType()), dependency.getRoleHint()));
    }

    protected Object createLogger(Class<?> instanceClass) {
        return LoggerFactory.getLogger(instanceClass);
    }

    @Deprecated
    protected <T> T getComponentInstance(RoleHint<T> roleHint) throws ComponentLookupException {
        return this.getInstance(roleHint.getRoleType(), roleHint.getHint());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private <T> T getComponentInstance(ComponentEntry<T> componentEntry) throws Exception {
        Object instance;
        ComponentDescriptor descriptor = componentEntry.descriptor;
        if (descriptor.getInstantiationStrategy() == ComponentInstantiationStrategy.SINGLETON) {
            if (componentEntry.instance != null) {
                instance = componentEntry.instance;
                return (T)instance;
            }
            ComponentEntry<T> componentEntry2 = componentEntry;
            synchronized (componentEntry2) {
                if (componentEntry.instance != null) {
                    instance = componentEntry.instance;
                } else {
                    if (componentEntry.constructing) {
                        throw new ComponentLookupException("Detected component construction cycle for component [%s] of hint [%s].".formatted(descriptor.getRoleType(), descriptor.getRoleHint()));
                    }
                    componentEntry.constructing = true;
                    try {
                        componentEntry.instance = this.createInstance(descriptor);
                    }
                    finally {
                        componentEntry.constructing = false;
                    }
                    instance = componentEntry.instance;
                }
                return (T)instance;
            }
        }
        instance = this.createInstance(descriptor);
        return (T)instance;
    }

    public <T> void registerComponent(ComponentDescriptor<T> componentDescriptor) throws ComponentRepositoryException {
        this.registerComponent(componentDescriptor, null);
    }

    public <T> void registerComponent(ComponentDescriptor<T> componentDescriptor, T componentInstance) {
        ComponentEntry<?> componentEntry = this.getComponentEntry(componentDescriptor.getRoleType(), componentDescriptor.getRoleHint());
        if (componentEntry == null || componentEntry.descriptor.getRoleHintPriority() >= componentDescriptor.getRoleHintPriority()) {
            this.removeComponentWithoutException(componentDescriptor.getRoleType(), componentDescriptor.getRoleHint());
            this.addComponent((ComponentDescriptor<T>)new DefaultComponentDescriptor(componentDescriptor), componentInstance);
        }
    }

    private <T> void addComponent(ComponentDescriptor<T> descriptor, T instance) {
        ComponentEntries entries = this.componentEntries.computeIfAbsent(descriptor.getRoleType(), k -> new ComponentEntries());
        entries.put(descriptor, instance);
        if (this.eventManager != null) {
            this.eventManager.notifyComponentRegistered(descriptor, (ComponentManager)this);
        }
    }

    public void unregisterComponent(Type role, String hint) {
        this.removeComponentWithoutException(role, hint);
    }

    public void unregisterComponent(ComponentDescriptor<?> componentDescriptor) {
        if (Objects.equals(this.getComponentDescriptor(componentDescriptor.getRoleType(), componentDescriptor.getRoleHint()), componentDescriptor)) {
            this.unregisterComponent(componentDescriptor.getRoleType(), componentDescriptor.getRoleHint());
        }
    }

    public void release(Object component) throws ComponentLifecycleException {
        ComponentEntries entries;
        ComponentEntry<Object> componentEntry = null;
        Iterator iterator = this.componentEntries.values().iterator();
        while (iterator.hasNext() && (componentEntry = (entries = (ComponentEntries)((Object)iterator.next())).get(component)) == null) {
        }
        if (componentEntry != null) {
            this.releaseInstance(componentEntry);
            if (this.eventManager != null) {
                this.eventManager.notifyComponentUnregistered(componentEntry.descriptor, (ComponentManager)this);
                this.eventManager.notifyComponentRegistered(componentEntry.descriptor, (ComponentManager)this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseInstance(ComponentEntry<?> componentEntry) throws ComponentLifecycleException {
        ComponentEntry<?> componentEntry2 = componentEntry;
        synchronized (componentEntry2) {
            Object instance = componentEntry.instance;
            if (instance instanceof Disposable) {
                ((Disposable)instance).dispose();
            }
            componentEntry.instance = null;
        }
    }

    private void releaseComponentEntry(ComponentEntry<?> componentEntry) throws ComponentLifecycleException {
        this.releaseInstance(componentEntry);
    }

    private void removeComponent(Type role, String hint) throws ComponentLifecycleException {
        ComponentEntry componentEntry;
        ComponentEntries entries = (ComponentEntries)((Object)this.componentEntries.get(role));
        if (entries != null && (componentEntry = (ComponentEntry)entries.remove(hint != null ? hint : "default")) != null) {
            ComponentDescriptor oldDescriptor = componentEntry.descriptor;
            if (componentEntry.instance != this) {
                this.releaseComponentEntry(componentEntry);
            }
            if (this.eventManager != null && oldDescriptor != null) {
                this.eventManager.notifyComponentUnregistered(oldDescriptor, (ComponentManager)this);
            }
        }
    }

    private void removeComponentWithoutException(Type role, String hint) {
        try {
            this.removeComponent(role, hint);
        }
        catch (Exception e) {
            this.logger.warn("Instance released but disposal failed. Some resources may not have been released.", (Throwable)e);
        }
    }

    private void addForDisposalReversedOrder(ComponentEntry<?> componentEntry, List<RoleHint<?>> keys) {
        if (!componentEntry.disposing) {
            componentEntry.disposing = true;
            ComponentDescriptor descriptor = componentEntry.descriptor;
            for (ComponentDependency dependency : descriptor.getComponentDependencies()) {
                ComponentEntry<?> dependencyEntry = this.getComponentEntry(dependency.getRoleType(), dependency.getRoleHint());
                if (dependencyEntry == null) continue;
                this.addForDisposalReversedOrder(dependencyEntry, keys);
            }
            keys.add(new RoleHint(descriptor.getRoleType(), descriptor.getRoleHint()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addForDisposalReversedOrder(List<RoleHint<?>> keys) {
        for (ComponentEntries entries : this.componentEntries.values()) {
            entries.getLock().readLock().lock();
            try {
                entries.forEachEntry(e -> this.addForDisposalReversedOrder((ComponentEntry<?>)e, keys));
            }
            finally {
                entries.getLock().readLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        ArrayList keys = new ArrayList(this.componentEntries.size() * 2);
        this.addForDisposalReversedOrder(keys);
        Collections.reverse(keys);
        RoleHint cmRoleHint = new RoleHint((Type)((Object)ComponentManager.class));
        ComponentEntry<?> cmEntry = this.getComponentEntry(cmRoleHint.getRoleType(), cmRoleHint.getHint());
        if (cmEntry != null && cmEntry.instance == this) {
            cmEntry.disposing = false;
            keys.remove(cmRoleHint);
        }
        Collections.sort(keys, new Comparator<RoleHint<?>>(){

            @Override
            public int compare(RoleHint<?> rh1, RoleHint<?> rh2) {
                return this.getPriority(rh1) - this.getPriority(rh2);
            }

            private int getPriority(RoleHint<?> rh) {
                Object instance = EmbeddableComponentManager.this.getComponentEntry((Type)rh.getRoleType(), (String)rh.getHint()).instance;
                if (instance == null) {
                    return 1000;
                }
                DisposePriority priorityAnnotation = instance.getClass().getAnnotation(DisposePriority.class);
                return priorityAnnotation == null ? 1000 : priorityAnnotation.value();
            }
        });
        for (RoleHint roleHint : keys) {
            ComponentEntry<?> componentEntry;
            ComponentEntry<?> componentEntry2 = componentEntry = this.getComponentEntry(roleHint.getRoleType(), roleHint.getHint());
            synchronized (componentEntry2) {
                Object instance = componentEntry.instance;
                if (instance instanceof Disposable && componentEntry.instance != this) {
                    try {
                        SHUTDOWN_LOGGER.debug("Disposing component [{}]...", (Object)instance.getClass().getName());
                        ((Disposable)instance).dispose();
                        SHUTDOWN_LOGGER.debug("Component [{}] has been disposed", (Object)instance.getClass().getName());
                    }
                    catch (ComponentLifecycleException e) {
                        this.logger.error("Failed to dispose component with role type [{}] and role hint [{}]", new Object[]{componentEntry.descriptor.getRoleType(), componentEntry.descriptor.getRoleHint(), e});
                    }
                }
            }
        }
        for (RoleHint roleHint : keys) {
            ((ComponentEntries)((Object)this.componentEntries.get(roleHint.getRoleType()))).remove(roleHint.getHint());
        }
    }

    private static class ComponentEntry<R>
    implements Comparable<ComponentEntry<R>> {
        final ComponentDescriptor<R> descriptor;
        volatile R instance;
        boolean disposing = false;
        boolean constructing = false;

        ComponentEntry(ComponentDescriptor<R> descriptor, R instance) {
            this.descriptor = descriptor;
            this.instance = instance;
        }

        @Override
        public int compareTo(ComponentEntry<R> other) {
            return this.descriptor.getRoleTypePriority() - other.descriptor.getRoleTypePriority();
        }

        public String toString() {
            return this.descriptor.toString();
        }
    }

    private static class ComponentEntries<R>
    extends PriorityEntries<ComponentEntry<R>> {
        ComponentEntries() {
        }

        ComponentEntries(int initialCapacity) {
            super(initialCapacity);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ComponentEntry<R> get(R instance) {
            this.lock.readLock().lock();
            try {
                for (ComponentEntry entry : this.map.values()) {
                    if (entry.instance != instance) continue;
                    ComponentEntry componentEntry = entry;
                    return componentEntry;
                }
            }
            finally {
                this.lock.readLock().unlock();
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        List<ComponentDescriptor<R>> toComponentDescriptorList() {
            this.lock.readLock().lock();
            try {
                ArrayList list = new ArrayList(this.size());
                for (ComponentEntry entry : this.getSorted()) {
                    list.add(entry.descriptor);
                }
                ArrayList arrayList = list;
                return arrayList;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        void put(ComponentDescriptor<R> descriptor) {
            this.put(descriptor, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void put(ComponentDescriptor<R> descriptor, R instance) {
            this.lock.writeLock().lock();
            try {
                ComponentEntry currentEntry = (ComponentEntry)this.map.get(descriptor.getRoleHint());
                if (currentEntry == null || currentEntry.descriptor.getRoleHintPriority() > descriptor.getRoleHintPriority()) {
                    this.put(descriptor.getRoleHint(), new ComponentEntry<R>(descriptor, instance));
                }
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void putAll(ComponentEntries<R> newEntries) {
            this.lock.writeLock().lock();
            try {
                for (ComponentEntry newEntry : newEntries.map.values()) {
                    ComponentEntry currentEntry = (ComponentEntry)this.map.get(newEntry.descriptor.getRoleHint());
                    if (currentEntry != null && currentEntry.descriptor.getRoleHintPriority() <= newEntry.descriptor.getRoleHintPriority()) continue;
                    this.put(newEntry.descriptor.getRoleHint(), newEntry);
                }
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
    }
}

