/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.component.embed;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.component.annotation.ComponentAnnotationLoader;
import org.xwiki.component.annotation.DisposePriority;
import org.xwiki.component.descriptor.ComponentDependency;
import org.xwiki.component.descriptor.ComponentDescriptor;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.component.descriptor.DefaultComponentDescriptor;
import org.xwiki.component.embed.GenericProvider;
import org.xwiki.component.embed.LifecycleHandler;
import org.xwiki.component.internal.RoleHint;
import org.xwiki.component.manager.ComponentEventManager;
import org.xwiki.component.manager.ComponentLifecycleException;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.manager.ComponentManagerInitializer;
import org.xwiki.component.manager.ComponentRepositoryException;
import org.xwiki.component.manager.NamespacedComponentManager;
import org.xwiki.component.phase.Disposable;
import org.xwiki.component.util.ReflectionUtils;

public class EmbeddableComponentManager
implements NamespacedComponentManager,
Disposable {
    private static final Logger SHUTDOWN_LOGGER = LoggerFactory.getLogger((String)"org.xwiki.shutdown");
    private String namespace;
    private ComponentEventManager eventManager;
    private ComponentManager parent;
    private Map<Type, Map<String, ComponentEntry<?>>> componentEntries = new ConcurrentHashMap();
    private Logger logger = LoggerFactory.getLogger(EmbeddableComponentManager.class);
    private ServiceLoader<LifecycleHandler> lifecycleHandlers = ServiceLoader.load(LifecycleHandler.class);

    public EmbeddableComponentManager() {
        this.registerThis();
    }

    public EmbeddableComponentManager(String namespace) {
        this.registerThis();
        this.namespace = namespace;
    }

    public String getNamespace() {
        return this.namespace;
    }

    private void registerThis() {
        DefaultComponentDescriptor cd = new DefaultComponentDescriptor();
        cd.setRoleType(ComponentManager.class);
        this.registerComponent((ComponentDescriptor)cd, (Object)this);
    }

    public void initialize(ClassLoader classLoader) {
        ComponentAnnotationLoader loader = new ComponentAnnotationLoader();
        loader.initialize((ComponentManager)this, classLoader);
        try {
            List initializers = this.getInstanceList((Type)((Object)ComponentManagerInitializer.class));
            for (ComponentManagerInitializer initializer : initializers) {
                initializer.initialize((ComponentManager)this);
            }
        }
        catch (ComponentLookupException e) {
            this.logger.error("Failed to lookup ComponentManagerInitializer components", (Throwable)e);
        }
    }

    public boolean hasComponent(Type role) {
        return this.hasComponent(role, null);
    }

    public boolean hasComponent(Type roleType, String roleHint) {
        if (this.getComponentEntry(roleType, roleHint) != null) {
            return true;
        }
        return this.getParent() != null ? this.getParent().hasComponent(roleType, roleHint) : false;
    }

    public <T> T getInstance(Type roleType) throws ComponentLookupException {
        return this.getInstance(roleType, null);
    }

    public <T> T getInstance(Type roleType, String roleHint) throws ComponentLookupException {
        Object instance;
        ComponentEntry<?> componentEntry = this.getComponentEntry(roleType, roleHint);
        if (componentEntry != null) {
            try {
                instance = this.getComponentInstance(componentEntry);
            }
            catch (Throwable e) {
                throw new ComponentLookupException(String.format("Failed to lookup component [%s] identified by type [%s] and hint [%s]", componentEntry.descriptor.getImplementation().getName(), roleType, roleHint), e);
            }
        } else if (this.getParent() != null) {
            instance = this.getParent().getInstance(roleType, roleHint);
        } else {
            throw new ComponentLookupException("Can't find descriptor for the component with type [" + roleType + "] and hint [" + roleHint + "]");
        }
        return (T)instance;
    }

    public <T> List<T> getInstanceList(Type role) throws ComponentLookupException {
        Map<String, T> objects = this.getInstanceMap(role);
        return objects.isEmpty() ? Collections.emptyList() : new ArrayList<T>(objects.values());
    }

    public <T> Map<String, T> getInstanceMap(Type roleType) throws ComponentLookupException {
        HashMap<String, Object> components = new HashMap<String, Object>();
        Map<String, ComponentEntry<?>> entries = this.componentEntries.get(roleType);
        if (entries != null) {
            for (Map.Entry<String, ComponentEntry<?>> entry : entries.entrySet()) {
                try {
                    components.put(entry.getKey(), this.getComponentInstance(entry.getValue()));
                }
                catch (Exception e) {
                    throw new ComponentLookupException("Failed to lookup component with type [" + roleType + "] and hint [" + entry.getKey() + "]", (Throwable)e);
                }
            }
        }
        if (this.getParent() != null) {
            for (Map.Entry<String, ComponentEntry<Object>> entry : this.getParent().getInstanceMap(roleType).entrySet()) {
                if (components.containsKey(entry.getKey())) continue;
                components.put(entry.getKey(), entry.getValue());
            }
        }
        return components;
    }

    private ComponentEntry<?> getComponentEntry(Type role, String hint) {
        Map<String, ComponentEntry<?>> entries = this.componentEntries.get(role);
        if (entries != null) {
            return entries.get(hint != null ? hint : "default");
        }
        return null;
    }

    public <T> ComponentDescriptor<T> getComponentDescriptor(Type role, String hint) {
        ComponentDescriptor result = null;
        ComponentEntry<?> componentEntry = this.getComponentEntry(role, hint);
        if (componentEntry == null) {
            if (this.getParent() != null) {
                result = this.getParent().getComponentDescriptor(role, hint);
            }
        } else {
            result = componentEntry.descriptor;
        }
        return result;
    }

    public <T> List<ComponentDescriptor<T>> getComponentDescriptorList(Type role) {
        HashMap<String, Object> descriptors = new HashMap<String, Object>();
        Map<String, ComponentEntry<?>> enries = this.componentEntries.get(role);
        if (enries != null) {
            for (Map.Entry<String, ComponentEntry<?>> entry : enries.entrySet()) {
                descriptors.put(entry.getKey(), entry.getValue().descriptor);
            }
        }
        if (this.getParent() != null) {
            List parentDescriptors = this.getParent().getComponentDescriptorList(role);
            for (ComponentDescriptor parentDescriptor : parentDescriptors) {
                if (descriptors.containsKey(parentDescriptor.getRoleHint())) continue;
                descriptors.put(parentDescriptor.getRoleHint(), parentDescriptor);
            }
        }
        return new ArrayList<ComponentDescriptor<T>>(descriptors.values());
    }

    public ComponentEventManager getComponentEventManager() {
        return this.eventManager;
    }

    public void setComponentEventManager(ComponentEventManager eventManager) {
        this.eventManager = eventManager;
    }

    public ComponentManager getParent() {
        return this.parent;
    }

    public void setParent(ComponentManager parentComponentManager) {
        this.parent = parentComponentManager;
    }

    private <T> T createInstance(ComponentDescriptor<T> descriptor) throws Exception {
        Object instance = descriptor.getImplementation().newInstance();
        for (ComponentDependency dependency : descriptor.getComponentDependencies()) {
            Object fieldValue = this.getDependencyInstance(descriptor, instance, dependency);
            if (fieldValue == null) continue;
            ReflectionUtils.setFieldValue(instance, (String)dependency.getName(), (Object)fieldValue);
        }
        for (LifecycleHandler lifecycleHandler : this.lifecycleHandlers) {
            lifecycleHandler.handle(instance, descriptor, (ComponentManager)this);
        }
        return instance;
    }

    protected Object getDependencyInstance(ComponentDescriptor<?> descriptor, Object parentInstance, ComponentDependency<?> dependency) throws ComponentLookupException {
        Class dependencyRoleClass = ReflectionUtils.getTypeClass((Type)dependency.getRoleType());
        Object fieldValue = dependencyRoleClass.isAssignableFrom(Logger.class) ? this.createLogger(parentInstance.getClass()) : (dependencyRoleClass.isAssignableFrom(List.class) ? this.getInstanceList(ReflectionUtils.getLastTypeGenericArgument((Type)dependency.getRoleType())) : (dependencyRoleClass.isAssignableFrom(Map.class) ? this.getInstanceMap(ReflectionUtils.getLastTypeGenericArgument((Type)dependency.getRoleType())) : (dependencyRoleClass.isAssignableFrom(Provider.class) ? (this.hasComponent(dependency.getRoleType(), dependency.getRoleHint()) ? this.getInstance(dependency.getRoleType(), dependency.getRoleHint()) : this.createGenericProvider(descriptor, dependency)) : (dependencyRoleClass.isAssignableFrom(ComponentDescriptor.class) ? new DefaultComponentDescriptor(descriptor) : this.getInstance(dependency.getRoleType(), dependency.getRoleHint())))));
        return fieldValue;
    }

    protected Provider<?> createGenericProvider(ComponentDescriptor<?> descriptor, ComponentDependency<?> dependency) {
        return new GenericProvider((ComponentManager)this, new RoleHint(ReflectionUtils.getLastTypeGenericArgument((Type)dependency.getRoleType()), dependency.getRoleHint()));
    }

    protected Object createLogger(Class<?> instanceClass) {
        return LoggerFactory.getLogger(instanceClass);
    }

    @Deprecated
    protected <T> T getComponentInstance(RoleHint<T> roleHint) throws ComponentLookupException {
        return this.getInstance(roleHint.getRoleType(), roleHint.getHint());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T getComponentInstance(ComponentEntry<T> componentEntry) throws Exception {
        Object instance;
        ComponentDescriptor descriptor = componentEntry.descriptor;
        if (descriptor.getInstantiationStrategy() == ComponentInstantiationStrategy.SINGLETON) {
            if (componentEntry.instance != null) {
                instance = componentEntry.instance;
            } else {
                ComponentEntry<T> componentEntry2 = componentEntry;
                synchronized (componentEntry2) {
                    if (componentEntry.instance != null) {
                        instance = componentEntry.instance;
                    } else {
                        componentEntry.instance = this.createInstance(descriptor);
                        instance = componentEntry.instance;
                    }
                }
            }
        } else {
            instance = this.createInstance(descriptor);
        }
        return (T)instance;
    }

    public <T> void registerComponent(ComponentDescriptor<T> componentDescriptor) throws ComponentRepositoryException {
        this.registerComponent(componentDescriptor, null);
    }

    public <T> void registerComponent(ComponentDescriptor<T> componentDescriptor, T componentInstance) {
        this.removeComponentWithoutException(componentDescriptor.getRoleType(), componentDescriptor.getRoleHint());
        this.addComponent((ComponentDescriptor<T>)new DefaultComponentDescriptor(componentDescriptor), componentInstance);
    }

    private <T> void addComponent(ComponentDescriptor<T> descriptor, T instance) {
        ComponentEntry<T> componentEntry = new ComponentEntry<T>(descriptor, instance);
        Map<String, ComponentEntry<?>> entries = this.componentEntries.get(descriptor.getRoleType());
        if (entries == null) {
            entries = new ConcurrentHashMap();
            this.componentEntries.put(descriptor.getRoleType(), entries);
        }
        entries.put(descriptor.getRoleHint(), componentEntry);
        if (this.eventManager != null) {
            this.eventManager.notifyComponentRegistered(descriptor, (ComponentManager)this);
        }
    }

    public void unregisterComponent(Type role, String hint) {
        this.removeComponentWithoutException(role, hint);
    }

    public void unregisterComponent(ComponentDescriptor<?> componentDescriptor) {
        if (Objects.equals(this.getComponentDescriptor(componentDescriptor.getRoleType(), componentDescriptor.getRoleHint()), componentDescriptor)) {
            this.unregisterComponent(componentDescriptor.getRoleType(), componentDescriptor.getRoleHint());
        }
    }

    public void release(Object component) throws ComponentLifecycleException {
        ComponentEntry<?> componentEntry = null;
        block0: for (Map<String, ComponentEntry<?>> entries : this.componentEntries.values()) {
            for (ComponentEntry<?> entry : entries.values()) {
                if (entry.instance != component) continue;
                componentEntry = entry;
                continue block0;
            }
        }
        if (componentEntry != null) {
            this.releaseInstance(componentEntry);
            if (this.eventManager != null) {
                this.eventManager.notifyComponentUnregistered(componentEntry.descriptor, (ComponentManager)this);
                this.eventManager.notifyComponentRegistered(componentEntry.descriptor, (ComponentManager)this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseInstance(ComponentEntry<?> componentEntry) throws ComponentLifecycleException {
        ComponentEntry<?> componentEntry2 = componentEntry;
        synchronized (componentEntry2) {
            Object instance = componentEntry.instance;
            if (instance instanceof Disposable) {
                ((Disposable)instance).dispose();
            }
            componentEntry.instance = null;
        }
    }

    private void releaseComponentEntry(ComponentEntry<?> componentEntry) throws ComponentLifecycleException {
        this.releaseInstance(componentEntry);
    }

    private void removeComponent(Type role, String hint) throws ComponentLifecycleException {
        ComponentEntry<?> componentEntry;
        Map<String, ComponentEntry<?>> entries = this.componentEntries.get(role);
        if (entries != null && (componentEntry = entries.remove(hint != null ? hint : "default")) != null) {
            ComponentDescriptor oldDescriptor = componentEntry.descriptor;
            if (componentEntry.instance != this) {
                this.releaseComponentEntry(componentEntry);
            }
            if (this.eventManager != null && oldDescriptor != null) {
                this.eventManager.notifyComponentUnregistered(oldDescriptor, (ComponentManager)this);
            }
        }
    }

    private void removeComponentWithoutException(Type role, String hint) {
        try {
            this.removeComponent(role, hint);
        }
        catch (Exception e) {
            this.logger.warn("Instance released but disposal failed. Some resources may not have been released.", (Throwable)e);
        }
    }

    private int sortEntry(List<RoleHint<?>> keys, int index) {
        int oldIndex = index;
        int newIndex = index;
        RoleHint<?> key = keys.get(index);
        ComponentEntry<?> componentEntry = this.getComponentEntry(key.getRoleType(), key.getHint());
        for (ComponentDependency dependency : componentEntry.descriptor.getComponentDependencies()) {
            RoleHint dependencyRole = new RoleHint(dependency.getRoleType(), dependency.getRoleHint());
            int dependencyIndex = keys.indexOf(dependencyRole);
            if (dependencyIndex == -1 || dependencyIndex >= newIndex) continue;
            newIndex = dependencyIndex = this.sortEntry(keys, dependencyIndex);
        }
        if (newIndex != oldIndex) {
            key = keys.remove(oldIndex);
            keys.add(newIndex, key);
        }
        return newIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        ArrayList keys = new ArrayList(this.componentEntries.size() * 2);
        for (Map<String, ComponentEntry<?>> entries : this.componentEntries.values()) {
            for (ComponentEntry<?> componentEntry : entries.values()) {
                keys.add(new RoleHint(componentEntry.descriptor.getRoleType(), componentEntry.descriptor.getRoleHint()));
            }
        }
        RoleHint cmRoleHint = new RoleHint((Type)((Object)ComponentManager.class));
        ComponentEntry<?> cmEntry = this.getComponentEntry(cmRoleHint.getRoleType(), cmRoleHint.getHint());
        if (cmEntry != null && cmEntry.instance == this) {
            keys.remove(cmRoleHint);
        }
        for (int i = 0; i < keys.size(); ++i) {
            i = this.sortEntry(keys, i);
        }
        Collections.sort(keys, new Comparator<RoleHint<?>>(){

            @Override
            public int compare(RoleHint<?> rh1, RoleHint<?> rh2) {
                return this.getPriority(rh1) - this.getPriority(rh2);
            }

            private int getPriority(RoleHint<?> rh) {
                Object instance = ((EmbeddableComponentManager)EmbeddableComponentManager.this).getComponentEntry((Type)rh.getRoleType(), (String)rh.getHint()).instance;
                if (instance == null) {
                    return 1000;
                }
                DisposePriority priorityAnnotation = instance.getClass().getAnnotation(DisposePriority.class);
                return priorityAnnotation == null ? 1000 : priorityAnnotation.value();
            }
        });
        for (RoleHint roleHint : keys) {
            ComponentEntry<?> componentEntry;
            ComponentEntry<?> componentEntry2 = componentEntry = this.getComponentEntry(roleHint.getRoleType(), roleHint.getHint());
            synchronized (componentEntry2) {
                Object instance = componentEntry.instance;
                if (instance instanceof Disposable && componentEntry.instance != this) {
                    try {
                        SHUTDOWN_LOGGER.debug("Disposing component [{}]...", (Object)instance.getClass().getName());
                        ((Disposable)instance).dispose();
                        SHUTDOWN_LOGGER.debug("Component [{}] has been disposed", (Object)instance.getClass().getName());
                    }
                    catch (ComponentLifecycleException e) {
                        this.logger.error("Failed to dispose component with role type [{}] and role hint [{}]", new Object[]{componentEntry.descriptor.getRoleType(), componentEntry.descriptor.getRoleHint(), e});
                    }
                }
            }
        }
        for (RoleHint roleHint : keys) {
            this.componentEntries.get(roleHint.getRoleType()).remove(roleHint.getHint());
        }
    }

    @Deprecated
    public <T> List<ComponentDescriptor<T>> getComponentDescriptorList(Class<T> role) {
        return this.getComponentDescriptorList((Type)role);
    }

    private static class ComponentEntry<R> {
        public final ComponentDescriptor<R> descriptor;
        public volatile R instance;

        public ComponentEntry(ComponentDescriptor<R> descriptor, R instance) {
            this.descriptor = descriptor;
            this.instance = instance;
        }
    }
}

