/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.component.namespace;

import org.xwiki.component.namespace.Namespace;

public final class NamespaceUtils {
    private NamespaceUtils() {
    }

    public static String getPrefix(String namespaceString) {
        Namespace namespace = NamespaceUtils.toNamespace(namespaceString);
        return namespace != null ? namespace.getType() : null;
    }

    public static Namespace toNamespace(String namespace) {
        if (namespace == null) {
            return null;
        }
        boolean escaped = false;
        StringBuilder typeBuilder = null;
        for (int i = 0; i < namespace.length(); ++i) {
            char c = namespace.charAt(i);
            if (escaped) {
                typeBuilder.append(c);
                escaped = false;
                continue;
            }
            if (c == '\\') {
                if (typeBuilder == null) {
                    typeBuilder = new StringBuilder();
                    if (i > 0) {
                        typeBuilder.append(namespace.substring(0, i));
                    }
                }
                escaped = true;
                continue;
            }
            if (c == ':') {
                String type = typeBuilder != null ? typeBuilder.toString() : namespace.substring(0, i);
                return new Namespace(type, namespace.substring(i + 1, namespace.length()));
            }
            if (typeBuilder == null) continue;
            typeBuilder.append(c);
        }
        return new Namespace(null, namespace);
    }
}

