/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.component.internal.namespace;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.namespace.NamespaceNotAllowedException;
import org.xwiki.component.namespace.NamespaceValidator;

@Component
@Singleton
public class DefaultNamespaceValidator
implements NamespaceValidator {
    private static final Pattern REGEXP_PATTERN = Pattern.compile("\\[(.*)\\]");
    private static final Set<String> ROOT_NAMESPACES = new HashSet<String>();
    @Inject
    @Named(value="context")
    private Provider<ComponentManager> componentManager;

    @Override
    public boolean isAllowed(Collection<String> allowedNamespaces, String namespace) {
        if (allowedNamespaces == null) {
            return true;
        }
        for (String allowedNamespace : allowedNamespaces) {
            if (!this.isAllowed(allowedNamespace, namespace)) continue;
            return true;
        }
        return false;
    }

    private boolean isAllowed(String allowedNamespace, String namespace) {
        if (StringUtils.equals((CharSequence)allowedNamespace, (CharSequence)namespace)) {
            return true;
        }
        if (namespace == null) {
            return ROOT_NAMESPACES.contains(allowedNamespace);
        }
        Matcher matcher = REGEXP_PATTERN.matcher(allowedNamespace);
        if (matcher.matches()) {
            String pattern = matcher.group(1);
            return namespace.matches(pattern);
        }
        return false;
    }

    @Override
    public void checkAllowed(Collection<String> allowedNamespaces, String namespace) throws NamespaceNotAllowedException {
        if (!this.isAllowed(allowedNamespaces, namespace)) {
            throw new NamespaceNotAllowedException("Allowed namespace list [" + allowedNamespaces + "] does not matches namespace [" + namespace + "]");
        }
    }

    static {
        ROOT_NAMESPACES.add("{root}");
        ROOT_NAMESPACES.add("{}");
    }
}

