/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.component.namespace;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class Namespace {
    public static final Namespace ROOT = new Namespace(null, null);
    private String type;
    private String value;
    private transient String serialized;

    public Namespace(String type, String value) {
        this.type = type;
        this.value = value;
    }

    public String getType() {
        return this.type;
    }

    public String getValue() {
        return this.value;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof Namespace) {
            return StringUtils.equals((CharSequence)this.type, (CharSequence)((Namespace)other).getType()) && StringUtils.equals((CharSequence)this.value, (CharSequence)((Namespace)other).getValue());
        }
        return false;
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append((Object)this.type);
        builder.append((Object)this.value);
        return builder.toHashCode();
    }

    public String serialize() {
        if (this.value == null) {
            return null;
        }
        if (this.serialized == null) {
            StringBuilder builder = new StringBuilder();
            if (this.type != null) {
                builder.append(this.type.replace("\\", "\\\\").replace(":", "\\:"));
                builder.append(':');
            }
            builder.append(this.value);
            this.serialized = builder.toString();
        }
        return this.serialized;
    }

    public String toString() {
        return this.serialize();
    }
}

