/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.classloader.internal;

import java.net.URI;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Singleton;
import org.xwiki.classloader.ClassLoaderManager;
import org.xwiki.classloader.NamespaceURLClassLoader;
import org.xwiki.component.annotation.Component;

@Component
@Singleton
public class DefaultClassLoaderManager
implements ClassLoaderManager {
    private NamespaceURLClassLoader rootClassLoader;
    private Map<String, NamespaceURLClassLoader> wikiClassLoaderMap = new ConcurrentHashMap<String, NamespaceURLClassLoader>();

    protected ClassLoader getSystemClassLoader() {
        return this.getClass().getClassLoader();
    }

    @Override
    public NamespaceURLClassLoader getURLClassLoader(String namespace, boolean create) {
        if (this.rootClassLoader == null) {
            this.rootClassLoader = new NamespaceURLClassLoader(new URI[0], this.getSystemClassLoader(), null);
        }
        NamespaceURLClassLoader wikiClassLoader = this.rootClassLoader;
        if (namespace != null && (wikiClassLoader = this.wikiClassLoaderMap.get(namespace)) == null) {
            if (create) {
                wikiClassLoader = new NamespaceURLClassLoader(new URI[0], (ClassLoader)this.rootClassLoader, namespace);
                this.wikiClassLoaderMap.put(namespace, wikiClassLoader);
            } else {
                wikiClassLoader = this.rootClassLoader;
            }
        }
        return wikiClassLoader;
    }

    @Override
    public void dropURLClassLoaders() {
        if (this.rootClassLoader != null) {
            for (String namespace : this.wikiClassLoaderMap.keySet()) {
                this.dropURLClassLoader(namespace);
            }
            this.rootClassLoader = null;
        }
    }

    @Override
    public void dropURLClassLoader(String namespace) {
        if (this.rootClassLoader != null && namespace != null) {
            this.wikiClassLoaderMap.remove(namespace);
        }
    }
}

