/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.cache.test;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.xwiki.cache.Cache;
import org.xwiki.cache.CacheFactory;
import org.xwiki.cache.config.CacheConfiguration;
import org.xwiki.cache.config.LRUCacheConfiguration;
import org.xwiki.cache.event.CacheEntryListener;
import org.xwiki.cache.eviction.EntryEvictionConfiguration;
import org.xwiki.cache.eviction.LRUEvictionConfiguration;
import org.xwiki.cache.test.AbstractGenericTestCache;
import org.xwiki.cache.test.TestCacheEntryListener;

public abstract class AbstractEvictionGenericTestCache
extends AbstractGenericTestCache {
    private boolean supportEvictionEvent;

    protected AbstractEvictionGenericTestCache(String roleHint, boolean supportEvictionEvent) {
        super(roleHint);
        this.supportEvictionEvent = supportEvictionEvent;
    }

    protected void customizeEviction(EntryEvictionConfiguration eviction) {
    }

    @Test
    void createAndDestroyCacheLRUMaxEntries() throws Exception {
        TestCacheEntryListener eventListener;
        CacheFactory factory = this.getCacheFactory();
        CacheConfiguration conf = new CacheConfiguration();
        LRUEvictionConfiguration lec = new LRUEvictionConfiguration();
        lec.setMaxEntries(1);
        this.customizeEviction((EntryEvictionConfiguration)lec);
        conf.put((Object)"eviction", (Object)lec);
        Cache cache = factory.newCache(conf);
        Assertions.assertNotNull((Object)cache);
        if (this.supportEvictionEvent) {
            eventListener = new TestCacheEntryListener();
            cache.addCacheEntryListener((CacheEntryListener)eventListener);
        } else {
            eventListener = null;
        }
        cache.set("key", (Object)"value");
        Assertions.assertEquals((Object)"value", (Object)cache.get("key"));
        cache.set("key2", (Object)2);
        if (eventListener != null) {
            Assertions.assertTrue((boolean)eventListener.waitForEntryEvent(TestCacheEntryListener.EventType.REMOVE), (String)"No value has been evicted from the cache");
            Assertions.assertSame((Object)"value", (Object)eventListener.getRemovedEvent().getEntry().getValue());
        }
        Assertions.assertNull((Object)cache.get("key"));
        Assertions.assertEquals((Object)2, (Object)cache.get("key2"));
        cache.dispose();
    }

    @Test
    void createAndDestroyCacheLRUMAxIdle() throws Exception {
        TestCacheEntryListener eventListener;
        CacheFactory factory = this.getCacheFactory();
        CacheConfiguration conf = new CacheConfiguration();
        LRUEvictionConfiguration lec = new LRUEvictionConfiguration();
        lec.setMaxIdle(1);
        this.customizeEviction((EntryEvictionConfiguration)lec);
        conf.put((Object)"eviction", (Object)lec);
        Cache cache = factory.newCache(conf);
        Assertions.assertNotNull((Object)cache);
        if (this.supportEvictionEvent) {
            eventListener = new TestCacheEntryListener();
            cache.addCacheEntryListener((CacheEntryListener)eventListener);
        } else {
            eventListener = null;
        }
        cache.set("key", (Object)"value");
        Assertions.assertEquals((Object)"value", (Object)cache.get("key"));
        if (eventListener != null) {
            Assertions.assertTrue((boolean)eventListener.waitForEntryEvent(TestCacheEntryListener.EventType.REMOVE), (String)"No value has expired from the cache after provided max idle time");
            Assertions.assertSame((Object)"value", (Object)eventListener.getRemovedEvent().getEntry().getValue());
        }
        Assertions.assertNull((Object)cache.get("key"));
        cache.dispose();
    }

    @Test
    void createAndDestroyCacheLRULifespan() throws Exception {
        TestCacheEntryListener eventListener;
        CacheFactory factory = this.getCacheFactory();
        CacheConfiguration conf = new CacheConfiguration();
        LRUEvictionConfiguration lec = new LRUEvictionConfiguration();
        lec.setLifespan(1);
        this.customizeEviction((EntryEvictionConfiguration)lec);
        conf.put((Object)"eviction", (Object)lec);
        Cache cache = factory.newCache(conf);
        Assertions.assertNotNull((Object)cache);
        if (this.supportEvictionEvent) {
            eventListener = new TestCacheEntryListener();
            cache.addCacheEntryListener((CacheEntryListener)eventListener);
        } else {
            eventListener = null;
        }
        cache.set("key", (Object)"value");
        Assertions.assertEquals((Object)"value", (Object)cache.get("key"));
        if (eventListener != null) {
            Assertions.assertTrue((boolean)eventListener.waitForEntryEvent(TestCacheEntryListener.EventType.REMOVE), (String)"No value has expired from the cache after provide lifespan");
            Assertions.assertSame((Object)"value", (Object)eventListener.getRemovedEvent().getEntry().getValue());
        }
        Assertions.assertNull((Object)cache.get("key"));
        cache.dispose();
    }

    @Test
    void createAndDestroyCacheLRUAll() throws Exception {
        CacheFactory factory = this.getCacheFactory();
        LRUCacheConfiguration conf = new LRUCacheConfiguration();
        LRUEvictionConfiguration lec = conf.getLRUEvictionConfiguration();
        lec.setMaxEntries(1);
        lec.setMaxIdle(1);
        lec.setLifespan(1);
        this.customizeEviction((EntryEvictionConfiguration)lec);
        Cache cache = factory.newCache((CacheConfiguration)conf);
        Assertions.assertNotNull((Object)cache);
        if (this.supportEvictionEvent) {
            TestCacheEntryListener eventListener = new TestCacheEntryListener();
            cache.addCacheEntryListener((CacheEntryListener)eventListener);
        }
        cache.set("key", (Object)"value");
        Assertions.assertEquals((Object)"value", (Object)cache.get("key"));
        cache.set("key2", (Object)2);
        Assertions.assertNull((Object)cache.get("key"));
        Assertions.assertEquals((Object)2, (Object)cache.get("key2"));
        Thread.sleep(1200L);
        Assertions.assertNull((Object)cache.get("key"));
        Assertions.assertNull((Object)cache.get("key2"));
        cache.dispose();
    }
}

