/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.cache.test;

import org.xwiki.cache.event.CacheEntryEvent;
import org.xwiki.cache.event.CacheEntryListener;

public class TestCacheEntryListener
implements CacheEntryListener<Object> {
    private CacheEntryEvent<Object> addedEvent;
    private CacheEntryEvent<Object> modifiedEvent;
    private CacheEntryEvent<Object> removedEvent;

    public CacheEntryEvent<Object> getAddedEvent() {
        return this.addedEvent;
    }

    public void reinitAddEvent() {
        this.addedEvent = null;
    }

    public CacheEntryEvent<Object> getModifiedEvent() {
        return this.modifiedEvent;
    }

    public void reinitModifiedEvent() {
        this.modifiedEvent = null;
    }

    public CacheEntryEvent<Object> getRemovedEvent() {
        return this.removedEvent;
    }

    public void reinitRemovedEvent() {
        this.removedEvent = null;
    }

    public void cacheEntryAdded(CacheEntryEvent<Object> event) {
        this.addedEvent = event;
    }

    public void cacheEntryModified(CacheEntryEvent<Object> event) {
        this.modifiedEvent = event;
    }

    public void cacheEntryRemoved(CacheEntryEvent<Object> event) {
        this.removedEvent = event;
    }

    public boolean waitForEntryEvent(EventType eventType) throws InterruptedException {
        EventWaiter eventWaiter = new EventWaiter(eventType);
        Thread thread = new Thread(eventWaiter);
        thread.start();
        thread.join(100000L);
        if (thread.isAlive()) {
            eventWaiter.stop();
            return false;
        }
        return true;
    }

    class EventWaiter
    implements Runnable {
        private boolean run = true;
        private EventType eventType;

        EventWaiter(EventType eventType) {
            this.eventType = eventType;
        }

        void stop() {
            this.run = false;
        }

        @Override
        public void run() {
            try {
                CacheEntryEvent event;
                while (this.run && (event = this.eventType == EventType.ADD ? TestCacheEntryListener.this.addedEvent : (this.eventType == EventType.MODIFY ? TestCacheEntryListener.this.modifiedEvent : TestCacheEntryListener.this.removedEvent)) == null) {
                    Thread.sleep(500L);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public static enum EventType {
        ADD,
        MODIFY,
        REMOVE;

    }
}

