/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.cache.test;

import org.junit.Assert;
import org.junit.Test;
import org.xwiki.cache.Cache;
import org.xwiki.cache.CacheFactory;
import org.xwiki.cache.config.CacheConfiguration;
import org.xwiki.cache.event.CacheEntryListener;
import org.xwiki.cache.test.AbstractTestCache;
import org.xwiki.cache.test.CacheEntryListenerTest;

public abstract class AbstractGenericTestCache
extends AbstractTestCache {
    protected AbstractGenericTestCache(String roleHint) {
        super(roleHint);
    }

    @Test
    public void getFactory() throws Exception {
        CacheFactory factory = this.getCacheFactory();
        CacheFactory factory2 = this.getCacheFactory();
        Assert.assertSame((Object)factory, (Object)factory2);
    }

    @Test
    public void createAndDestroyCacheSimple() throws Exception {
        CacheFactory factory = this.getCacheFactory();
        Cache cache = factory.newCache(new CacheConfiguration());
        Assert.assertNotNull((Object)cache);
        cache.set("key", (Object)"value");
        cache.set("key2", (Object)2);
        Assert.assertEquals((Object)"value", (Object)cache.get("key"));
        Assert.assertEquals((Object)2, (Object)cache.get("key2"));
        cache.dispose();
    }

    @Test
    public void remove() throws Exception {
        CacheFactory factory = this.getCacheFactory();
        Cache cache = factory.newCache(new CacheConfiguration());
        cache.set("key", (Object)"value");
        cache.set("key2", (Object)2);
        cache.remove("key");
        Assert.assertNull((Object)cache.get("key"));
        Assert.assertEquals((Object)2, (Object)cache.get("key2"));
    }

    @Test
    public void removeAll() throws Exception {
        CacheFactory factory = this.getCacheFactory();
        Cache cache = factory.newCache(new CacheConfiguration());
        cache.set("key", (Object)"value");
        cache.set("key2", (Object)2);
        cache.removeAll();
        Assert.assertNull((Object)cache.get("key"));
        Assert.assertNull((Object)cache.get("key2"));
    }

    @Test
    public void events() throws Exception {
        CacheFactory factory = this.getCacheFactory();
        Cache cache = factory.newCache(new CacheConfiguration());
        CacheEntryListenerTest eventListener = new CacheEntryListenerTest();
        cache.addCacheEntryListener((CacheEntryListener)eventListener);
        cache.set("key", (Object)"value");
        Assert.assertNotNull(eventListener.getAddedEvent());
        Assert.assertSame((Object)cache, (Object)eventListener.getAddedEvent().getCache());
        Assert.assertEquals((Object)"key", (Object)eventListener.getAddedEvent().getEntry().getKey());
        Assert.assertEquals((Object)"value", (Object)eventListener.getAddedEvent().getEntry().getValue());
        cache.set("key", (Object)2);
        Assert.assertNotNull(eventListener.getModifiedEvent());
        Assert.assertSame((Object)cache, (Object)eventListener.getModifiedEvent().getCache());
        Assert.assertEquals((Object)"key", (Object)eventListener.getModifiedEvent().getEntry().getKey());
        Assert.assertEquals((Object)2, (Object)eventListener.getModifiedEvent().getEntry().getValue());
        cache.remove("key");
        cache.get("key");
        Assert.assertNotNull(eventListener.getRemovedEvent());
        Assert.assertSame((Object)cache, (Object)eventListener.getRemovedEvent().getCache());
        Assert.assertEquals((Object)"key", (Object)eventListener.getRemovedEvent().getEntry().getKey());
        Assert.assertEquals((Object)2, (Object)eventListener.getRemovedEvent().getEntry().getValue());
        eventListener.reinitRemovedEvent();
        cache.remove("key");
        Assert.assertNull(eventListener.getRemovedEvent());
    }

    @Test
    public void severalCaches() throws Exception {
        CacheFactory factory = this.getCacheFactory();
        Cache cache = factory.newCache(new CacheConfiguration());
        Cache cache2 = factory.newCache(new CacheConfiguration());
        cache.set("key", (Object)"value");
        Assert.assertNull((Object)cache2.get("key"));
    }

    @Test
    public void recreateCache() throws Exception {
        CacheFactory factory = this.getCacheFactory();
        CacheConfiguration configuration = new CacheConfiguration();
        configuration.setConfigurationId("test");
        Cache cache = factory.newCache(configuration);
        cache.set("key", (Object)"value");
        Assert.assertEquals((Object)"value", (Object)cache.get("key"));
        cache.dispose();
        cache = factory.newCache(configuration);
        Assert.assertNull((Object)cache.get("key"));
        cache.set("key", (Object)"value");
        Assert.assertEquals((Object)"value", (Object)cache.get("key"));
    }
}

