/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.cache.internal;

import com.google.common.util.concurrent.Uninterruptibles;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import org.apache.commons.lang3.function.FailableBiConsumer;
import org.apache.commons.lang3.function.FailableFunction;

public class CacheLoader<V, E extends Exception> {
    private final ConcurrentHashMap<String, LoaderEntry> currentLoads = new ConcurrentHashMap();
    private final ReadWriteLock invalidationLock = new ReentrantReadWriteLock();
    private final ThreadLocal<LoaderEntry> currentLoad = new ThreadLocal();

    public V loadAndStoreInCache(String key, FailableFunction<String, V, E> loader, FailableBiConsumer<String, V, E> setter) throws ExecutionException {
        LoaderEntry newEntry = new LoaderEntry(key, loader, setter);
        LoaderEntry loaderEntry = this.currentLoads.compute(key, (k, value) -> {
            if (value != null) {
                if (value.creatingThread != Thread.currentThread()) {
                    return value;
                }
                value.invalidated = true;
            }
            return newEntry;
        });
        if (loaderEntry != newEntry && this.currentLoad.get() != null) {
            loaderEntry = newEntry;
            loaderEntry.invalidated = true;
        }
        if (loaderEntry == newEntry) {
            loaderEntry.future.run();
        }
        return (V)Uninterruptibles.getUninterruptibly(loaderEntry.future);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidate(String key, Consumer<String> invalidate) {
        Lock lock = this.invalidationLock.writeLock();
        lock.lock();
        try {
            LoaderEntry entry = this.currentLoads.remove(key);
            if (entry != null) {
                entry.invalidated = true;
            }
            invalidate.accept(key);
        }
        finally {
            lock.unlock();
        }
    }

    public void invalidateAll(Runnable invalidateAll) {
        Lock lock = this.invalidationLock.writeLock();
        lock.lock();
        try {
            this.currentLoads.forEach((k, v) -> {
                this.currentLoads.remove(k);
                v.invalidated = true;
            });
            invalidateAll.run();
        }
        finally {
            lock.unlock();
        }
    }

    private class LoaderEntry {
        private final Thread creatingThread = Thread.currentThread();
        private final FutureTask<V> future = new FutureTask<Object>(() -> {
            LoaderEntry oldEntry = CacheLoader.this.currentLoad.get();
            try {
                CacheLoader.this.currentLoad.set(this);
                Object value = loader.apply((Object)key);
                if (!this.invalidated) {
                    Lock lock = CacheLoader.this.invalidationLock.readLock();
                    lock.lock();
                    try {
                        if (!this.invalidated) {
                            setter.accept((Object)key, value);
                        }
                    }
                    finally {
                        lock.unlock();
                    }
                }
                Object object = value;
                return object;
            }
            finally {
                if (oldEntry == null) {
                    CacheLoader.this.currentLoad.remove();
                } else {
                    CacheLoader.this.currentLoad.set(oldEntry);
                }
                CacheLoader.this.currentLoads.computeIfPresent(key, (k, v) -> v == this ? null : v);
            }
        });
        private volatile boolean invalidated;

        LoaderEntry(String key, FailableFunction<String, V, E> loader, FailableBiConsumer<String, V, E> setter) {
        }
    }
}

