/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.cache.internal;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.chrono.ChronoLocalDateTime;
import java.util.Date;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.lang3.ObjectUtils;
import org.xwiki.cache.CacheControl;
import org.xwiki.component.annotation.Component;
import org.xwiki.context.Execution;
import org.xwiki.context.ExecutionContext;

@Component
@Singleton
public class DefaultCacheControl
implements CacheControl {
    private static final String MAX_AGE = "cache.maxage";
    @Inject
    private Execution execution;

    private void setProperty(String key, Object value) {
        ExecutionContext context = this.execution.getContext();
        if (context != null) {
            if (context.hasProperty(key)) {
                context.setProperty(key, value);
            } else {
                context.newProperty(key).inherited().initial(value).declare();
            }
        }
    }

    private <T> T getProperty(String key, T def) {
        ExecutionContext context = this.execution.getContext();
        return (T)(context != null ? ObjectUtils.defaultIfNull((Object)context.getProperty(key), def) : def);
    }

    @Override
    public void setCacheReadAllowed(boolean enabled) {
        if (enabled) {
            this.setProperty(MAX_AGE, null);
        } else {
            this.setProperty(MAX_AGE, LocalDateTime.now());
        }
    }

    @Override
    public boolean isCacheReadAllowed(Date dateTime) {
        return this.isCacheReadAllowed(dateTime.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime());
    }

    @Override
    public boolean isCacheReadAllowed(ChronoLocalDateTime<?> dateTime) {
        LocalDateTime maxAge = this.getProperty(MAX_AGE, null);
        if (maxAge != null) {
            return maxAge.isBefore(dateTime);
        }
        return true;
    }

    @Override
    public boolean isCacheReadAllowed() {
        return this.getProperty(MAX_AGE, null) == null;
    }
}

