/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.blame.internal;

import com.github.difflib.DiffUtils;
import com.github.difflib.patch.AbstractDelta;
import com.github.difflib.patch.Chunk;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.xwiki.blame.AnnotatedContent;
import org.xwiki.blame.AnnotatedElement;
import org.xwiki.blame.internal.DefaultAnnotatedElement;

public class DefaultAnnotatedContent<R, E>
implements AnnotatedContent<R, E> {
    private final List<R> sourceRevisions;
    private final List<E> initialContent;
    private final List<E> currentRevisionContent;
    private R currentRevision;
    private final List<Integer> elementList;
    private final int size;

    DefaultAnnotatedContent(R revision, List<E> initialContent) {
        this.size = initialContent.size();
        this.sourceRevisions = new ArrayList<R>(this.size);
        this.initialContent = initialContent;
        this.currentRevisionContent = new ArrayList<E>(initialContent);
        this.currentRevision = revision;
        this.elementList = new ArrayList<Integer>(this.size);
        for (int i = 0; i < this.size; ++i) {
            this.sourceRevisions.add(null);
            this.elementList.add(i);
        }
    }

    @Override
    public Iterator<AnnotatedElement<R, E>> iterator() {
        return new AnnotatedContentIterator();
    }

    @Override
    public R getOldestRevision() {
        return this.currentRevision;
    }

    @Override
    public boolean isEntirelyAnnotated() {
        for (int i = 0; i < this.size; ++i) {
            if (this.sourceRevisions.get(i) != null) continue;
            return false;
        }
        return true;
    }

    void analyseRevision(R revision, List<E> previous) {
        if (this.currentRevision == null) {
            return;
        }
        if (previous == null || previous.isEmpty()) {
            this.resolveRemainingToCurrent();
        } else {
            this.resolveToCurrent(DiffUtils.diff(this.currentRevisionContent, previous).getDeltas());
            assert (this.currentRevisionContent.equals(previous)) : "Patch application failed";
        }
        this.currentRevision = revision;
    }

    private void resolveToCurrent(List<AbstractDelta<E>> deltas) {
        int lineOffset = 0;
        for (AbstractDelta<E> d : deltas) {
            int i;
            Chunk original = d.getSource();
            Chunk revised = d.getTarget();
            int pos = original.getPosition() + lineOffset;
            for (i = 0; i < original.size(); ++i) {
                int origLine = this.elementList.remove(pos);
                this.currentRevisionContent.remove(pos);
                if (origLine == -1) continue;
                this.sourceRevisions.set(origLine, this.currentRevision);
            }
            for (i = 0; i < revised.size(); ++i) {
                this.currentRevisionContent.add(pos + i, revised.getLines().get(i));
                this.elementList.add(pos + i, -1);
            }
            lineOffset += revised.size() - original.size();
        }
    }

    private void resolveRemainingToCurrent() {
        for (int i = 0; i < this.size; ++i) {
            if (this.sourceRevisions.get(i) != null) continue;
            this.sourceRevisions.set(i, this.currentRevision);
        }
    }

    private class AnnotatedContentIterator
    implements Iterator<AnnotatedElement<R, E>> {
        private int index = -1;

        private AnnotatedContentIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.index < DefaultAnnotatedContent.this.size - 1;
        }

        @Override
        public AnnotatedElement<R, E> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("No more annotated content");
            }
            ++this.index;
            return new DefaultAnnotatedElement(DefaultAnnotatedContent.this.sourceRevisions.get(this.index), DefaultAnnotatedContent.this.initialContent.get(this.index));
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

