/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.connection;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xsocket.connection.IIoDispatcherPoolListener;
import org.xsocket.connection.IoProvider;
import org.xsocket.connection.IoSocketDispatcher;
import org.xsocket.connection.IoSocketHandler;
import org.xsocket.connection.IoUnsynchronizedMemoryManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class IoSocketDispatcherPool
implements Closeable {
    private static final Logger LOG = Logger.getLogger(IoSocketDispatcherPool.class.getName());
    private volatile boolean isOpen = true;
    private String name = null;
    private final ArrayList<IIoDispatcherPoolListener> listeners = new ArrayList();
    private int preallocationSize = 65536;
    private int bufferMinsize = 64;
    private boolean preallocation = true;
    private boolean useDirect = false;
    private final LinkedList<IoSocketDispatcher> dispatchers = new LinkedList();
    private int size = 0;
    private int pointer = 0;
    private long acceptedConnections = 0L;
    private long lastRequestAccpetedRate = System.currentTimeMillis();

    public IoSocketDispatcherPool(String name) {
        this(name, IoSocketDispatcherPool.getDefaultSize());
    }

    public IoSocketDispatcherPool(String name, int size) {
        this.name = name;
        this.setDispatcherSize(size);
    }

    public static int getDefaultSize() {
        if (IoProvider.getCountDispatcher() == null) {
            return Runtime.getRuntime().availableProcessors() + 1;
        }
        return IoProvider.getCountDispatcher();
    }

    void addListener(IIoDispatcherPoolListener listener) {
        this.listeners.add(listener);
    }

    boolean removeListener(IIoDispatcherPoolListener listener) {
        return this.listeners.remove(listener);
    }

    IoSocketDispatcher nextDispatcher(int currentTrial) throws IOException {
        IoSocketDispatcher dispatcher = null;
        try {
            boolean peregistered;
            ++this.pointer;
            if (this.pointer >= this.size) {
                this.pointer = 0;
            }
            if (peregistered = (dispatcher = this.dispatchers.get(this.pointer)).preRegister()) {
                return dispatcher;
            }
            if (currentTrial < this.size) {
                return this.nextDispatcher(++currentTrial);
            }
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("increasing dispatcher size because max handle size " + dispatcher.getHandlesMaxCount() + " of all " + this.size + " dispatcher reached");
            }
            this.incDispatcherSize();
            return this.nextDispatcher(0);
        }
        catch (Exception concurrentException) {
            if (this.isOpen) {
                if (currentTrial < 3) {
                    dispatcher = this.nextDispatcher(++currentTrial);
                } else {
                    throw new IOException(concurrentException.toString());
                }
            }
            return dispatcher;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void updateDispatcher() {
        if (this.isOpen) {
            LinkedList<IoSocketDispatcher> linkedList = this.dispatchers;
            synchronized (linkedList) {
                int currentRunning = this.dispatchers.size();
                if (currentRunning != this.size) {
                    int i;
                    if (currentRunning > this.size) {
                        for (i = this.size; i < currentRunning; ++i) {
                            IoSocketDispatcher dispatcher;
                            block15: {
                                dispatcher = this.dispatchers.getLast();
                                this.dispatchers.remove(dispatcher);
                                try {
                                    dispatcher.close();
                                }
                                catch (IOException ioe) {
                                    if (!LOG.isLoggable(Level.FINE)) break block15;
                                    LOG.fine("error occured by closing the dispatcher " + dispatcher + ". reason " + ioe.toString());
                                }
                            }
                            for (IIoDispatcherPoolListener listener : this.listeners) {
                                listener.onDispatcherRemoved(dispatcher);
                            }
                        }
                    } else if (currentRunning < this.size) {
                        for (i = currentRunning; i < this.size; ++i) {
                            IoUnsynchronizedMemoryManager memoryManager = null;
                            memoryManager = this.preallocation ? IoUnsynchronizedMemoryManager.createPreallocatedMemoryManager(this.preallocationSize, this.bufferMinsize, this.useDirect) : IoUnsynchronizedMemoryManager.createNonPreallocatedMemoryManager(this.useDirect);
                            IoSocketDispatcher dispatcher = new IoSocketDispatcher(memoryManager, "xDispatcher" + this.name + "#" + i);
                            this.dispatchers.addLast(dispatcher);
                            Thread t = new Thread(dispatcher);
                            t.setDaemon(false);
                            t.start();
                            for (IIoDispatcherPoolListener listener : this.listeners) {
                                listener.onDispatcherAdded(dispatcher);
                            }
                        }
                    }
                }
                IoSocketDispatcher[] connectionDispatchers = new IoSocketDispatcher[this.dispatchers.size()];
                for (int i = 0; i < connectionDispatchers.length; ++i) {
                    connectionDispatchers[i] = this.dispatchers.get(i);
                }
            }
        }
    }

    @Override
    public void close() throws IOException {
        if (this.isOpen) {
            this.isOpen = false;
            this.shutdownDispatcher();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdownDispatcher() {
        if (LOG.isLoggable(Level.FINER)) {
            LOG.fine("terminate dispatchers");
        }
        LinkedList<IoSocketDispatcher> linkedList = this.dispatchers;
        synchronized (linkedList) {
            for (IoSocketDispatcher dispatcher : this.dispatchers) {
                try {
                    dispatcher.close();
                    for (IIoDispatcherPoolListener listener : this.listeners) {
                        listener.onDispatcherRemoved(dispatcher);
                    }
                }
                catch (IOException ioe) {
                    if (!LOG.isLoggable(Level.FINE)) continue;
                    LOG.fine("error occured by closing the dispatcher " + dispatcher + ". reason " + ioe.toString());
                }
            }
        }
        this.dispatchers.clear();
    }

    public int getNumberOfOpenConnections() {
        return this.getOpenConntionInfos().size();
    }

    public List<String> getOpenConntionInfos() {
        ArrayList<String> result = new ArrayList<String>();
        for (IoSocketDispatcher dispatcher : this.getDispatchers()) {
            for (IoSocketHandler handler : dispatcher.getRegistered()) {
                result.add(handler.toString());
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<IoSocketDispatcher> getDispatchers() {
        List result = null;
        LinkedList<IoSocketDispatcher> linkedList = this.dispatchers;
        synchronized (linkedList) {
            result = (List)this.dispatchers.clone();
        }
        return result;
    }

    synchronized void setDispatcherSize(int size) {
        this.size = size;
        this.updateDispatcher();
    }

    synchronized int getDispatcherSize() {
        return this.size;
    }

    synchronized void incDispatcherSize() {
        this.setDispatcherSize(this.getDispatcherSize() + 1);
    }

    boolean getReceiveBufferIsDirect() {
        return this.useDirect;
    }

    void setReceiveBufferIsDirect(boolean isDirect) {
        this.useDirect = isDirect;
        for (IoSocketDispatcher dispatcher : this.dispatchers) {
            dispatcher.setReceiveBufferIsDirect(isDirect);
        }
    }

    boolean isReceiveBufferPreallocationMode() {
        return this.preallocation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setReceiveBufferPreallocationMode(boolean mode) {
        this.preallocation = mode;
        LinkedList<IoSocketDispatcher> linkedList = this.dispatchers;
        synchronized (linkedList) {
            for (IoSocketDispatcher dispatcher : this.dispatchers) {
                dispatcher.setReceiveBufferPreallocationMode(mode);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setReceiveBufferPreallocatedMinSize(Integer minSize) {
        this.bufferMinsize = minSize;
        LinkedList<IoSocketDispatcher> linkedList = this.dispatchers;
        synchronized (linkedList) {
            for (IoSocketDispatcher dispatcher : this.dispatchers) {
                dispatcher.setReceiveBufferPreallocatedMinSize(minSize);
            }
        }
    }

    Integer getReceiveBufferPreallocatedMinSize() {
        return this.bufferMinsize;
    }

    Integer getReceiveBufferPreallocationSize() {
        return this.preallocationSize;
    }

    void setReceiveBufferPreallocationSize(int size) {
        this.preallocationSize = size;
        for (IoSocketDispatcher dispatcher : this.dispatchers) {
            dispatcher.setReceiveBufferPreallocatedSize(size);
        }
    }

    double getAcceptedRateCountPerSec() {
        double rate = 0.0;
        long elapsed = System.currentTimeMillis() - this.lastRequestAccpetedRate;
        rate = this.acceptedConnections == 0L ? 0.0 : (elapsed == 0L ? 2.147483647E9 : (double)(this.acceptedConnections * 1000L) / (double)elapsed);
        this.lastRequestAccpetedRate = System.currentTimeMillis();
        this.acceptedConnections = 0L;
        return rate;
    }

    long getSendRateBytesPerSec() {
        long rate = 0L;
        for (IoSocketDispatcher dispatcher : this.dispatchers) {
            rate += dispatcher.getSendRateBytesPerSec();
        }
        return rate;
    }

    long getReceiveRateBytesPerSec() {
        long rate = 0L;
        for (IoSocketDispatcher dispatcher : this.dispatchers) {
            rate += dispatcher.getReceiveRateBytesPerSec();
        }
        return rate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getNumberOfConnectionTimeouts() {
        long timeouts = 0L;
        LinkedList copy = null;
        LinkedList<IoSocketDispatcher> linkedList = this.dispatchers;
        synchronized (linkedList) {
            copy = (LinkedList)this.dispatchers.clone();
        }
        for (IoSocketDispatcher dispatcher : copy) {
            timeouts += dispatcher.getCountConnectionTimeout();
        }
        return timeouts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getNumberOfIdleTimeouts() {
        long timeouts = 0L;
        LinkedList copy = null;
        LinkedList<IoSocketDispatcher> linkedList = this.dispatchers;
        synchronized (linkedList) {
            copy = (LinkedList)this.dispatchers.clone();
        }
        for (IoSocketDispatcher dispatcher : copy) {
            timeouts += dispatcher.getCountIdleTimeout();
        }
        return timeouts;
    }
}

