/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.connection;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.rmi.server.UID;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Timer;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.JMException;
import javax.management.ObjectName;
import javax.net.ssl.SSLContext;
import org.xsocket.DataConverter;
import org.xsocket.connection.AbstractMemoryManager;
import org.xsocket.connection.IIoAcceptorCallback;
import org.xsocket.connection.IIoDispatcherPoolListener;
import org.xsocket.connection.IServerListener;
import org.xsocket.connection.IntrospectionBasedDynamicMBean;
import org.xsocket.connection.IoAcceptor;
import org.xsocket.connection.IoActivateableSSLHandler;
import org.xsocket.connection.IoChainableHandler;
import org.xsocket.connection.IoSSLHandler;
import org.xsocket.connection.IoSocketDispatcher;
import org.xsocket.connection.IoSocketDispatcherPool;
import org.xsocket.connection.IoSocketHandler;
import org.xsocket.connection.IoSynchronizedMemoryManager;
import org.xsocket.connection.IoThrottledReadHandler;
import org.xsocket.connection.IoThrottledWriteHandler;
import org.xsocket.connection.Server;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class IoProvider {
    private static final Logger LOG;
    static final String SO_SNDBUF = "SOL_SOCKET.SO_SNDBUF";
    static final String SO_RCVBUF = "SOL_SOCKET.SO_RCVBUF";
    static final String SO_REUSEADDR = "SOL_SOCKET.SO_REUSEADDR";
    static final String SO_TIMEOUT = "SOL_SOCKET.SO_TIMEOUT";
    static final String SO_KEEPALIVE = "SOL_SOCKET.SO_KEEPALIVE";
    static final String SO_LINGER = "SOL_SOCKET.SO_LINGER";
    static final String TCP_NODELAY = "IPPROTO_TCP.TCP_NODELAY";
    static final int UNLIMITED = Integer.MAX_VALUE;
    static final long DEFAULT_CONNECTION_TIMEOUT_MILLIS = Long.MAX_VALUE;
    static final long DEFAULT_IDLE_TIMEOUT_MILLIS = Long.MAX_VALUE;
    private static final Timer TIMER;
    private static IoSocketDispatcherPool globalClientDispatcherPool;
    public static final String COUNT_DISPATCHER_KEY = "org.xsocket.connection.dispatcher.initialCount";
    private static final String MAX_HANDLES = "org.xsocket.connection.dispatcher.maxHandles";
    private static final String DETACH_HANDLE_ON_NO_OPS = "org.xsocket.connection.dispatcher.detachHandleOnNoOps";
    private static final String IS_UNREGISTERED_WRITE_ALLOWED = "org.xsocket.connection.dispatcher.unregisteredWriteAllowed";
    public static final String DEFAULT_USE_DIRECT_BUFFER = "true";
    public static final String CLIENT_READBUFFER_USE_DIRECT_KEY = "org.xsocket.connection.client.readbuffer.usedirect";
    public static final String SERVER_READBUFFER_USE_DIRECT_KEY = "org.xsocket.connection.server.readbuffer.usedirect";
    public static final String DEFAULT_READ_BUFFER_PREALLOCATION_ON = "true";
    public static final int DEFAULT_READ_BUFFER_PREALLOCATION_SIZE = 65536;
    public static final int DEFAULT_READ_BUFFER_MIN_SIZE = 64;
    public static final String CLIENT_READBUFFER_PREALLOCATION_ON_KEY = "org.xsocket.connection.client.readbuffer.preallocation.on";
    public static final String CLIENT_READBUFFER_PREALLOCATION_SIZE_KEY = "org.xsocket.connection.client.readbuffer.preallocation.size";
    public static final String CLIENT_READBUFFER_PREALLOCATION_MIN_SIZE_KEY = "org.xsocket.connection.client.readbuffer.preallocated.minSize";
    public static final String SERVER_READBUFFER_PREALLOCATION_ON_KEY = "org.xsocket.connection.server.readbuffer.preallocation.on";
    public static final String SERVER_READBUFFER_PREALLOCATION_SIZE_KEY = "org.xsocket.connection.server.readbuffer.preallocation.size";
    public static final String SERVER_READBUFFER_PREALLOCATION_MIN_SIZE_KEY = "org.xsocket.connection.server.readbuffer.preallocated.minSize";
    private static Integer countDispatcher;
    private static Integer maxHandles;
    private static boolean detachHandleOnNoOps;
    private static boolean unregisteredWriteAllowed;
    private static Boolean clientReadBufferUseDirect;
    private static Boolean serverReadBufferUseDirect;
    private static Boolean clientReadBufferPreallocationOn;
    private static int clientReadBufferPreallocationsize;
    private static int clientReadBufferMinsize;
    private static Boolean serverReadBufferPreallocationOn;
    private static int serverReadBufferPreallocationsize;
    private static int serverReadBufferMinsize;
    private static String idPrefix;
    private AbstractMemoryManager sslMemoryManagerServer = null;
    private AbstractMemoryManager sslMemoryManagerClient = null;
    private final AtomicInteger nextId = new AtomicInteger();

    IoProvider() {
        this.sslMemoryManagerServer = serverReadBufferPreallocationOn != false ? IoSynchronizedMemoryManager.createPreallocatedMemoryManager(serverReadBufferPreallocationsize, serverReadBufferMinsize, serverReadBufferUseDirect) : IoSynchronizedMemoryManager.createNonPreallocatedMemoryManager(serverReadBufferUseDirect);
        this.sslMemoryManagerClient = clientReadBufferPreallocationOn != false ? IoSynchronizedMemoryManager.createPreallocatedMemoryManager(clientReadBufferPreallocationsize, clientReadBufferMinsize, clientReadBufferUseDirect) : IoSynchronizedMemoryManager.createNonPreallocatedMemoryManager(clientReadBufferUseDirect);
    }

    static Integer getCountDispatcher() {
        return countDispatcher;
    }

    static Integer getMaxHandles() {
        return maxHandles;
    }

    static boolean getDetachHandleOnNoOps() {
        return detachHandleOnNoOps;
    }

    static boolean isUnregisteredWriteAllowed() {
        return unregisteredWriteAllowed;
    }

    public String getImplementationVersion() {
        return "";
    }

    public IoAcceptor createAcceptor(IIoAcceptorCallback callback, InetSocketAddress address, int backlog, Map<String, Object> options) throws IOException {
        IoAcceptor acceptor = new IoAcceptor(callback, address, backlog);
        for (Map.Entry<String, Object> entry : options.entrySet()) {
            acceptor.setOption(entry.getKey(), entry.getValue());
        }
        acceptor.setReceiveBufferIsDirect(serverReadBufferUseDirect);
        acceptor.setReceiveBufferPreallocationMode(serverReadBufferPreallocationOn);
        acceptor.setReceiveBufferPreallocatedMinSize(serverReadBufferMinsize);
        acceptor.setReceiveBufferPreallocationSize(serverReadBufferPreallocationsize);
        return acceptor;
    }

    public IoAcceptor createAcceptor(IIoAcceptorCallback callback, InetSocketAddress address, int backlog, Map<String, Object> options, SSLContext sslContext, boolean sslOn) throws IOException {
        IoAcceptor acceptor = new IoAcceptor(callback, address, backlog, sslContext, sslOn);
        for (Map.Entry<String, Object> entry : options.entrySet()) {
            acceptor.setOption(entry.getKey(), entry.getValue());
        }
        acceptor.setReceiveBufferIsDirect(serverReadBufferUseDirect);
        acceptor.setReceiveBufferPreallocationMode(serverReadBufferPreallocationOn);
        acceptor.setReceiveBufferPreallocatedMinSize(serverReadBufferMinsize);
        acceptor.setReceiveBufferPreallocationSize(serverReadBufferPreallocationsize);
        return acceptor;
    }

    public IoChainableHandler createClientIoHandler(InetSocketAddress remoteAddress, int connectTimeoutMillis, Map<String, Object> options) throws IOException {
        return this.createIoHandler(true, IoProvider.getGlobalClientDisptacherPool().nextDispatcher(0), IoProvider.openSocket(remoteAddress, options, connectTimeoutMillis), null, false);
    }

    public IoChainableHandler createSSLClientIoHandler(InetSocketAddress remoteAddress, int connectTimeoutMillis, Map<String, Object> options, SSLContext sslContext, boolean sslOn) throws IOException {
        return this.createIoHandler(true, IoProvider.getGlobalClientDisptacherPool().nextDispatcher(0), IoProvider.openSocket(remoteAddress, options, connectTimeoutMillis), sslContext, sslOn);
    }

    IoChainableHandler createIoHandler(boolean isClient, IoSocketDispatcher dispatcher, SocketChannel channel, SSLContext sslContext, boolean sslOn) throws IOException {
        String connectionId = null;
        connectionId = isClient ? idPrefix + ".c." + this.nextId.incrementAndGet() : idPrefix + ".s." + this.nextId.incrementAndGet();
        IoChainableHandler ioHandler = new IoSocketHandler(channel, dispatcher, connectionId);
        if (sslContext != null) {
            AbstractMemoryManager mm = null;
            mm = isClient ? this.sslMemoryManagerClient : this.sslMemoryManagerServer;
            ioHandler = sslOn ? new IoSSLHandler(ioHandler, sslContext, isClient, mm) : new IoActivateableSSLHandler(ioHandler, sslContext, isClient, mm);
        }
        return ioHandler;
    }

    public IoChainableHandler setWriteTransferRate(IoChainableHandler ioHandler, int bytesPerSecond) throws IOException {
        if (bytesPerSecond == Integer.MAX_VALUE) {
            IoThrottledWriteHandler delayWriter = (IoThrottledWriteHandler)this.getHandler(ioHandler, IoThrottledWriteHandler.class);
            if (delayWriter != null) {
                delayWriter.flushOutgoing();
                IoChainableHandler successor = delayWriter.getSuccessor();
                return successor;
            }
            return ioHandler;
        }
        IoThrottledWriteHandler delayWriter = (IoThrottledWriteHandler)this.getHandler(ioHandler, IoThrottledWriteHandler.class);
        if (delayWriter == null) {
            delayWriter = new IoThrottledWriteHandler(ioHandler);
        }
        delayWriter.setWriteRateSec(bytesPerSecond);
        return delayWriter;
    }

    public IoChainableHandler setReadTransferRate(IoChainableHandler ioHandler, int bytesPerSecond) throws IOException {
        if (bytesPerSecond == Integer.MAX_VALUE) {
            IoThrottledReadHandler delayReader = (IoThrottledReadHandler)this.getHandler(ioHandler, IoThrottledReadHandler.class);
            if (delayReader != null) {
                delayReader.reset();
                IoChainableHandler successor = delayReader.getSuccessor();
                return successor;
            }
            return ioHandler;
        }
        IoThrottledReadHandler delayReader = (IoThrottledReadHandler)this.getHandler(ioHandler, IoThrottledReadHandler.class);
        if (delayReader == null) {
            delayReader = new IoThrottledReadHandler(ioHandler);
        }
        delayReader.setReadRateSec(bytesPerSecond);
        delayReader.init(ioHandler.getPreviousCallback());
        return delayReader;
    }

    public boolean preStartSecuredMode(IoChainableHandler ioHandler) throws IOException {
        IoActivateableSSLHandler activateableHandler = (IoActivateableSSLHandler)this.getHandler(ioHandler, IoActivateableSSLHandler.class);
        if (activateableHandler != null) {
            return activateableHandler.preStartSecuredMode();
        }
        throw new IOException("connection is not SSL activatable (non IoActivateableHandler in chain)");
    }

    public void startSecuredMode(IoChainableHandler ioHandler, ByteBuffer[] buffers) throws IOException {
        ioHandler.flushOutgoing();
        IoActivateableSSLHandler activateableHandler = (IoActivateableSSLHandler)this.getHandler(ioHandler, IoActivateableSSLHandler.class);
        if (activateableHandler != null) {
            activateableHandler.startSecuredMode(buffers);
        } else {
            LOG.warning("connection is not SSL activatable (non IoActivateableHandler in chain");
        }
    }

    static Timer getTimer() {
        return TIMER;
    }

    static boolean isUseDirectReadBufferServer() {
        return serverReadBufferUseDirect;
    }

    static int getReadBufferPreallocationsizeServer() {
        return serverReadBufferPreallocationsize;
    }

    static int getReadBufferMinSizeServer() {
        return serverReadBufferMinsize;
    }

    static boolean isReadBufferPreallocationActivated() {
        return serverReadBufferPreallocationOn;
    }

    private static SocketChannel openSocket(InetSocketAddress remoteAddress, Map<String, Object> options, int connectTimeoutMillis) throws IOException {
        SocketChannel channel = SocketChannel.open();
        for (Map.Entry<String, Object> entry : options.entrySet()) {
            IoProvider.setOption(channel.socket(), entry.getKey(), entry.getValue());
        }
        try {
            channel.socket().connect(remoteAddress, connectTimeoutMillis);
        }
        catch (IOException ioe) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("error occured by bindung socket to remote address " + remoteAddress + " " + ioe.toString());
            }
            throw ioe;
        }
        return channel;
    }

    static void setOption(Socket socket, String name, Object value) throws IOException {
        if (name.equals(SO_SNDBUF)) {
            socket.setSendBufferSize(IoProvider.asInt(value));
        } else if (name.equals(SO_REUSEADDR)) {
            socket.setReuseAddress(IoProvider.asBoolean(value));
        } else if (name.equals(SO_TIMEOUT)) {
            socket.setSoTimeout(IoProvider.asInt(value));
        } else if (name.equals(SO_RCVBUF)) {
            socket.setReceiveBufferSize(IoProvider.asInt(value));
        } else if (name.equals(SO_KEEPALIVE)) {
            socket.setKeepAlive(IoProvider.asBoolean(value));
        } else if (name.equals(SO_LINGER)) {
            try {
                socket.setSoLinger(true, IoProvider.asInt(value));
            }
            catch (ClassCastException cce) {
                socket.setSoLinger(Boolean.FALSE, 0);
            }
        } else if (name.equals(TCP_NODELAY)) {
            socket.setTcpNoDelay(IoProvider.asBoolean(value));
        } else {
            LOG.warning("option " + name + " is not supported");
        }
    }

    static Object getOption(Socket socket, String name) throws IOException {
        if (name.equals(SO_SNDBUF)) {
            return socket.getSendBufferSize();
        }
        if (name.equals(SO_REUSEADDR)) {
            return socket.getReuseAddress();
        }
        if (name.equals(SO_RCVBUF)) {
            return socket.getReceiveBufferSize();
        }
        if (name.equals(SO_KEEPALIVE)) {
            return socket.getKeepAlive();
        }
        if (name.equals(SO_TIMEOUT)) {
            return socket.getSoTimeout();
        }
        if (name.equals(TCP_NODELAY)) {
            return socket.getTcpNoDelay();
        }
        if (name.equals(SO_LINGER)) {
            return socket.getSoLinger();
        }
        LOG.warning("option " + name + " is not supported");
        return null;
    }

    private static int asInt(Object obj) {
        if (obj instanceof Integer) {
            return (Integer)obj;
        }
        return Integer.parseInt(obj.toString());
    }

    private static boolean asBoolean(Object obj) {
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        return Boolean.parseBoolean(obj.toString());
    }

    private IoChainableHandler getHandler(IoChainableHandler head, Class clazz) {
        IoChainableHandler handler = head;
        do {
            if (handler.getClass() != clazz) continue;
            return handler;
        } while ((handler = handler.getSuccessor()) != null);
        return null;
    }

    private static synchronized IoSocketDispatcherPool getGlobalClientDisptacherPool() {
        if (globalClientDispatcherPool == null) {
            globalClientDispatcherPool = new IoSocketDispatcherPool("Glb", 1);
            globalClientDispatcherPool.setReceiveBufferIsDirect(clientReadBufferUseDirect);
            globalClientDispatcherPool.setReceiveBufferPreallocationMode(clientReadBufferPreallocationOn);
            globalClientDispatcherPool.setReceiveBufferPreallocatedMinSize(clientReadBufferMinsize);
            globalClientDispatcherPool.setReceiveBufferPreallocationSize(clientReadBufferPreallocationsize);
        }
        return globalClientDispatcherPool;
    }

    public ObjectName registerMBeans(Server server, IoAcceptor acceptor, String domain, String address) throws JMException {
        address = address.replace(":", "_");
        if (acceptor instanceof IoAcceptor) {
            IntrospectionBasedDynamicMBean serverMBean = new IntrospectionBasedDynamicMBean(new MBeanAdapter(server, acceptor));
            IoSocketDispatcherPool dispatcherPool = acceptor.getDispatcherPool();
            DispatcherPoolListener dispatcherPoolListener = new DispatcherPoolListener(domain, address);
            dispatcherPool.addListener(dispatcherPoolListener);
            for (IoSocketDispatcher dispatcher : dispatcherPool.getDispatchers()) {
                try {
                    dispatcherPoolListener.onDispatcherAdded(dispatcher);
                }
                catch (Exception ignore) {}
            }
            server.addListener(new ServerListener());
            ObjectName serverObjectName = new ObjectName(domain + ".server." + address + ":type=xServer");
            ManagementFactory.getPlatformMBeanServer().registerMBean(serverMBean, serverObjectName);
            return serverObjectName;
        }
        throw new JMException("only accpetor of instance " + IoAcceptor.class.getName() + " is supported, not " + acceptor.getClass().getName());
    }

    static {
        String unregisteredWriteAllowedString;
        String detachHandleOnNoOpsString;
        String maxHandlesString;
        LOG = Logger.getLogger(IoProvider.class.getName());
        TIMER = new Timer("xIoTimer", true);
        globalClientDispatcherPool = null;
        countDispatcher = null;
        maxHandles = null;
        detachHandleOnNoOps = true;
        unregisteredWriteAllowed = false;
        clientReadBufferUseDirect = null;
        serverReadBufferUseDirect = null;
        clientReadBufferPreallocationOn = null;
        clientReadBufferPreallocationsize = 65536;
        clientReadBufferMinsize = 64;
        serverReadBufferPreallocationOn = null;
        serverReadBufferPreallocationsize = 65536;
        serverReadBufferMinsize = 64;
        idPrefix = null;
        String countDispatcherString = System.getProperty(COUNT_DISPATCHER_KEY);
        if (countDispatcherString != null) {
            countDispatcher = new Integer(countDispatcherString);
        }
        if ((maxHandlesString = System.getProperty(MAX_HANDLES)) != null) {
            maxHandles = new Integer(maxHandlesString);
        }
        if ((detachHandleOnNoOpsString = System.getProperty(DETACH_HANDLE_ON_NO_OPS)) != null) {
            detachHandleOnNoOps = Boolean.parseBoolean(detachHandleOnNoOpsString);
        }
        if ((unregisteredWriteAllowedString = System.getProperty(IS_UNREGISTERED_WRITE_ALLOWED)) != null) {
            unregisteredWriteAllowed = Boolean.parseBoolean(unregisteredWriteAllowedString);
        }
        try {
            clientReadBufferUseDirect = Boolean.valueOf(System.getProperty(CLIENT_READBUFFER_USE_DIRECT_KEY, "true"));
        }
        catch (Exception e) {
            LOG.warning("invalid value for system property org.xsocket.connection.client.readbuffer.usedirect: " + System.getProperty(CLIENT_READBUFFER_USE_DIRECT_KEY) + " (valid is true|false)" + " using direct buffer");
            clientReadBufferUseDirect = Boolean.TRUE;
        }
        try {
            serverReadBufferUseDirect = Boolean.valueOf(System.getProperty(SERVER_READBUFFER_USE_DIRECT_KEY, "true"));
        }
        catch (Exception e) {
            LOG.warning("invalid value for system property org.xsocket.connection.server.readbuffer.usedirect: " + System.getProperty(SERVER_READBUFFER_USE_DIRECT_KEY) + " (valid is true|false)" + " using direct buffer");
            serverReadBufferUseDirect = Boolean.TRUE;
        }
        try {
            clientReadBufferPreallocationOn = Boolean.valueOf(System.getProperty(CLIENT_READBUFFER_PREALLOCATION_ON_KEY, "true"));
        }
        catch (Exception e) {
            LOG.warning("invalid value for system property org.xsocket.connection.client.readbuffer.preallocation.on: " + System.getProperty(CLIENT_READBUFFER_PREALLOCATION_ON_KEY) + " using preallocation mode");
            clientReadBufferPreallocationOn = Boolean.TRUE;
        }
        if (clientReadBufferPreallocationOn.booleanValue()) {
            try {
                clientReadBufferPreallocationsize = Integer.parseInt(System.getProperty(CLIENT_READBUFFER_PREALLOCATION_SIZE_KEY, Integer.toString(65536)));
            }
            catch (Exception e) {
                LOG.warning("invalid value for system property org.xsocket.connection.client.readbuffer.preallocation.size: " + System.getProperty(CLIENT_READBUFFER_PREALLOCATION_SIZE_KEY) + " using default preallocation size " + 65536);
                clientReadBufferPreallocationsize = 65536;
            }
            try {
                clientReadBufferMinsize = Integer.parseInt(System.getProperty(CLIENT_READBUFFER_PREALLOCATION_MIN_SIZE_KEY, Integer.toString(64)));
            }
            catch (Exception e) {
                LOG.warning("invalid value for system property org.xsocket.connection.client.readbuffer.preallocated.minSize: " + System.getProperty(CLIENT_READBUFFER_PREALLOCATION_MIN_SIZE_KEY) + " using default min size " + 64);
                clientReadBufferMinsize = 64;
            }
        }
        try {
            serverReadBufferPreallocationOn = Boolean.valueOf(System.getProperty(SERVER_READBUFFER_PREALLOCATION_ON_KEY, "true"));
        }
        catch (Exception e) {
            LOG.warning("invalid value for system property org.xsocket.connection.server.readbuffer.preallocation.on: " + System.getProperty(SERVER_READBUFFER_PREALLOCATION_ON_KEY) + " using preallocation mode");
            serverReadBufferPreallocationOn = Boolean.TRUE;
        }
        if (serverReadBufferPreallocationOn.booleanValue()) {
            try {
                serverReadBufferPreallocationsize = Integer.parseInt(System.getProperty(SERVER_READBUFFER_PREALLOCATION_SIZE_KEY, Integer.toString(65536)));
            }
            catch (Exception e) {
                LOG.warning("invalid value for system property org.xsocket.connection.server.readbuffer.preallocation.size: " + System.getProperty(SERVER_READBUFFER_PREALLOCATION_SIZE_KEY) + " using default preallocation size " + 65536);
                serverReadBufferPreallocationsize = 65536;
            }
            try {
                serverReadBufferMinsize = Integer.parseInt(System.getProperty(SERVER_READBUFFER_PREALLOCATION_MIN_SIZE_KEY, Integer.toString(64)));
            }
            catch (Exception e) {
                LOG.warning("invalid value for system property org.xsocket.connection.server.readbuffer.preallocated.minSize: " + System.getProperty(SERVER_READBUFFER_PREALLOCATION_MIN_SIZE_KEY) + " using default min size " + 64);
                serverReadBufferMinsize = 64;
            }
        }
        String base = null;
        try {
            base = InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (Exception e) {
            base = new UID().toString();
        }
        int random = 0;
        Random rand = new Random();
        while ((random = rand.nextInt()) < 0) {
        }
        idPrefix = Integer.toHexString(base.hashCode()) + "." + Long.toHexString(System.currentTimeMillis()) + "." + Integer.toHexString(random);
        if (LOG.isLoggable(Level.FINE)) {
            StringBuilder sb = new StringBuilder();
            sb.append(IoProvider.class.getName() + " initialized (");
            sb.append("countDispatcher=" + countDispatcher + " ");
            sb.append("maxHandles=" + maxHandles + " ");
            sb.append("detachHandleOnNoOps=" + detachHandleOnNoOps + " ");
            sb.append("client: directMemory=" + clientReadBufferUseDirect);
            sb.append(" preallocation=" + clientReadBufferPreallocationOn);
            if (clientReadBufferPreallocationOn.booleanValue()) {
                sb.append(" preallocationSize=" + DataConverter.toFormatedBytesSize(clientReadBufferPreallocationsize));
                sb.append(" minBufferSize=" + DataConverter.toFormatedBytesSize(clientReadBufferMinsize));
            }
            sb.append(" & server: directMemory=" + serverReadBufferUseDirect);
            sb.append(" preallocation=" + serverReadBufferPreallocationOn);
            if (serverReadBufferPreallocationOn.booleanValue()) {
                sb.append(" preallocationSize=" + DataConverter.toFormatedBytesSize(serverReadBufferPreallocationsize));
                sb.append(" minBufferSize=" + DataConverter.toFormatedBytesSize(serverReadBufferMinsize));
            }
            sb.append(")");
            LOG.fine(sb.toString());
        }
    }

    private static final class DispatcherPoolListener
    implements IIoDispatcherPoolListener {
        private String domain = null;
        private String address = null;

        DispatcherPoolListener(String domain, String address) {
            this.domain = domain;
            this.address = address;
        }

        public void onDispatcherAdded(IoSocketDispatcher dispatcher) {
            block2: {
                try {
                    ObjectName objectName = new ObjectName(this.domain + ".server." + this.address + ":type=xDispatcher,name=" + dispatcher.getName());
                    ManagementFactory.getPlatformMBeanServer().registerMBean(new IntrospectionBasedDynamicMBean(dispatcher), objectName);
                }
                catch (Exception e) {
                    if (!LOG.isLoggable(Level.FINE)) break block2;
                    LOG.fine("error occured by adding mbean for new dispatcher: " + e.toString());
                }
            }
        }

        public void onDispatcherRemoved(IoSocketDispatcher dispatcher) {
            block2: {
                try {
                    ObjectName objectName = new ObjectName(this.domain + ".server." + this.address + ":type=xDispatcher,name=" + dispatcher.getName());
                    ManagementFactory.getPlatformMBeanServer().unregisterMBean(objectName);
                }
                catch (Exception e) {
                    if (!LOG.isLoggable(Level.FINE)) break block2;
                    LOG.fine("error occured by removing mbean of dispatcher: " + e.toString());
                }
            }
        }
    }

    private static final class ServerListener
    implements IServerListener {
        private ServerListener() {
        }

        public void onInit() {
        }

        public void onDestroy() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class MBeanAdapter {
        private Server server = null;
        private IoAcceptor acceptor = null;

        public MBeanAdapter(Server server, IoAcceptor acceptor) {
            this.server = server;
            this.acceptor = acceptor;
        }

        public long getNumberOfConnectionTimeouts() {
            return this.server.getNumberOfConnectionTimeouts();
        }

        public long getNumberOfIdleTimeouts() {
            return this.server.getNumberOfIdleTimeouts();
        }

        public String getVersion() {
            return this.server.getVersion();
        }

        public String getLocalHost() {
            return this.acceptor.getLocalAddress().getCanonicalHostName();
        }

        public int getLocalPort() {
            return this.acceptor.getLocalPort();
        }

        public int getDispatcherPoolSize() {
            return this.acceptor.getDispatcherSize();
        }

        public void setDispatcherPoolSize(int size) {
            this.acceptor.setDispatcherSize(size);
        }

        public List<String> getActiveConnectionInfos() {
            return this.server.getOpenConnectionInfos();
        }

        public boolean getReceiveBufferIsDirect() {
            return this.acceptor.getReceiveBufferIsDirect();
        }

        public void setReceiveBufferIsDirect(boolean isDirect) {
            this.acceptor.setReceiveBufferIsDirect(isDirect);
        }

        public Integer getReceiveBufferPreallocatedMinSize() {
            if (this.acceptor.isReceiveBufferPreallocationMode()) {
                return this.acceptor.getReceiveBufferPreallocatedMinSize();
            }
            return null;
        }

        public void setReceiveBufferPreallocatedMinSize(Integer minSize) {
            this.acceptor.setReceiveBufferPreallocatedMinSize(minSize);
        }

        public boolean getReceiveBufferPreallocationMode() {
            return this.acceptor.isReceiveBufferPreallocationMode();
        }

        public void setReceiveBufferPreallocationMode(boolean mode) {
            this.acceptor.setReceiveBufferPreallocationMode(mode);
        }

        public Integer getReceiveBufferPreallocationSize() {
            if (this.acceptor.isReceiveBufferPreallocationMode()) {
                return this.acceptor.getReceiveBufferPreallocationSize();
            }
            return null;
        }

        public void setReceiveBufferPreallocationSize(Integer size) {
            this.acceptor.setReceiveBufferPreallocationSize(size);
        }

        public long getConnectionTimeoutMillis() {
            return this.server.getConnectionTimeoutMillis();
        }

        public void setConnectionTimeoutMillis(int timeoutMillis) {
            this.server.setConnectionTimeoutMillis(timeoutMillis);
        }

        public long getIdleTimeoutMillis() {
            return this.server.getIdleTimeoutMillis();
        }

        public void setIdleTimeoutMillis(int timeoutMillis) {
            this.server.setIdleTimeoutMillis(timeoutMillis);
        }

        public long getReceiveRateBytesPerSec() {
            return this.acceptor.getReceiveRateBytesPerSec();
        }

        public long getSendRateBytesPerSec() {
            return this.acceptor.getSendRateBytesPerSec();
        }

        public double getAcceptedRateCountPerSec() {
            return this.acceptor.getAcceptedRateCountPerSec();
        }
    }
}

