/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.codec.binary.types;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.xrpl.xrpl4j.codec.binary.types.Hop;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Hop", generator="Immutables")
@Immutable
public final class ImmutableHop
implements Hop {
    @Nullable
    private final JsonNode issuer;
    @Nullable
    private final JsonNode account;
    @Nullable
    private final JsonNode currency;

    private ImmutableHop(@Nullable JsonNode issuer, @Nullable JsonNode account, @Nullable JsonNode currency) {
        this.issuer = issuer;
        this.account = account;
        this.currency = currency;
    }

    @Override
    @JsonProperty(value="issuer")
    public Optional<JsonNode> issuer() {
        return Optional.ofNullable(this.issuer);
    }

    @Override
    @JsonProperty(value="account")
    public Optional<JsonNode> account() {
        return Optional.ofNullable(this.account);
    }

    @Override
    @JsonProperty(value="currency")
    public Optional<JsonNode> currency() {
        return Optional.ofNullable(this.currency);
    }

    public final ImmutableHop withIssuer(JsonNode value) {
        JsonNode newValue = Objects.requireNonNull(value, "issuer");
        if (this.issuer == newValue) {
            return this;
        }
        return new ImmutableHop(newValue, this.account, this.currency);
    }

    public final ImmutableHop withIssuer(Optional<? extends JsonNode> optional) {
        JsonNode value = optional.orElse(null);
        if (this.issuer == value) {
            return this;
        }
        return new ImmutableHop(value, this.account, this.currency);
    }

    public final ImmutableHop withAccount(JsonNode value) {
        JsonNode newValue = Objects.requireNonNull(value, "account");
        if (this.account == newValue) {
            return this;
        }
        return new ImmutableHop(this.issuer, newValue, this.currency);
    }

    public final ImmutableHop withAccount(Optional<? extends JsonNode> optional) {
        JsonNode value = optional.orElse(null);
        if (this.account == value) {
            return this;
        }
        return new ImmutableHop(this.issuer, value, this.currency);
    }

    public final ImmutableHop withCurrency(JsonNode value) {
        JsonNode newValue = Objects.requireNonNull(value, "currency");
        if (this.currency == newValue) {
            return this;
        }
        return new ImmutableHop(this.issuer, this.account, newValue);
    }

    public final ImmutableHop withCurrency(Optional<? extends JsonNode> optional) {
        JsonNode value = optional.orElse(null);
        if (this.currency == value) {
            return this;
        }
        return new ImmutableHop(this.issuer, this.account, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableHop && this.equalTo((ImmutableHop)another);
    }

    private boolean equalTo(ImmutableHop another) {
        return Objects.equals(this.issuer, another.issuer) && Objects.equals(this.account, another.account) && Objects.equals(this.currency, another.currency);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.issuer);
        h += (h << 5) + Objects.hashCode(this.account);
        h += (h << 5) + Objects.hashCode(this.currency);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Hop").omitNullValues().add("issuer", (Object)this.issuer).add("account", (Object)this.account).add("currency", (Object)this.currency).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableHop fromJson(Json json) {
        Builder builder = ImmutableHop.builder();
        if (json.issuer != null) {
            builder.issuer(json.issuer);
        }
        if (json.account != null) {
            builder.account(json.account);
        }
        if (json.currency != null) {
            builder.currency(json.currency);
        }
        return builder.build();
    }

    public static ImmutableHop copyOf(Hop instance) {
        if (instance instanceof ImmutableHop) {
            return (ImmutableHop)instance;
        }
        return ImmutableHop.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Hop", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private JsonNode issuer;
        @Nullable
        private JsonNode account;
        @Nullable
        private JsonNode currency;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Hop instance) {
            Optional<JsonNode> currencyOptional;
            Optional<JsonNode> accountOptional;
            Objects.requireNonNull(instance, "instance");
            Optional<JsonNode> issuerOptional = instance.issuer();
            if (issuerOptional.isPresent()) {
                this.issuer(issuerOptional);
            }
            if ((accountOptional = instance.account()).isPresent()) {
                this.account(accountOptional);
            }
            if ((currencyOptional = instance.currency()).isPresent()) {
                this.currency(currencyOptional);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder issuer(JsonNode issuer) {
            this.issuer = Objects.requireNonNull(issuer, "issuer");
            return this;
        }

        @JsonProperty(value="issuer")
        @CanIgnoreReturnValue
        public final Builder issuer(Optional<? extends JsonNode> issuer) {
            this.issuer = issuer.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder account(JsonNode account) {
            this.account = Objects.requireNonNull(account, "account");
            return this;
        }

        @JsonProperty(value="account")
        @CanIgnoreReturnValue
        public final Builder account(Optional<? extends JsonNode> account) {
            this.account = account.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder currency(JsonNode currency) {
            this.currency = Objects.requireNonNull(currency, "currency");
            return this;
        }

        @JsonProperty(value="currency")
        @CanIgnoreReturnValue
        public final Builder currency(Optional<? extends JsonNode> currency) {
            this.currency = currency.orElse(null);
            return this;
        }

        public ImmutableHop build() {
            return new ImmutableHop(this.issuer, this.account, this.currency);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="Hop", generator="Immutables")
    static final class Json
    implements Hop {
        @Nullable
        Optional<JsonNode> issuer = Optional.empty();
        @Nullable
        Optional<JsonNode> account = Optional.empty();
        @Nullable
        Optional<JsonNode> currency = Optional.empty();

        Json() {
        }

        @JsonProperty(value="issuer")
        public void setIssuer(Optional<JsonNode> issuer) {
            this.issuer = issuer;
        }

        @JsonProperty(value="account")
        public void setAccount(Optional<JsonNode> account) {
            this.account = account;
        }

        @JsonProperty(value="currency")
        public void setCurrency(Optional<JsonNode> currency) {
            this.currency = currency;
        }

        @Override
        public Optional<JsonNode> issuer() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<JsonNode> account() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<JsonNode> currency() {
            throw new UnsupportedOperationException();
        }
    }
}

