/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.codec.binary.types;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.regex.Pattern;
import org.xrpl.xrpl4j.codec.addresses.UnsignedByteArray;
import org.xrpl.xrpl4j.codec.binary.serdes.BinaryParser;
import org.xrpl.xrpl4j.codec.binary.types.HashType;

public class Hash160Type
extends HashType<Hash160Type> {
    public static final int WIDTH = 20;
    protected static final Pattern HEX_REGEX = Pattern.compile("^[A-Z0-9]{40}$");

    public Hash160Type() {
        this(UnsignedByteArray.ofSize((int)20));
    }

    public Hash160Type(UnsignedByteArray list) {
        super(list, 20);
    }

    @Override
    public Hash160Type fromParser(BinaryParser parser) {
        return new Hash160Type(parser.read(20));
    }

    @Override
    public Hash160Type fromJson(JsonNode node) {
        return new Hash160Type(UnsignedByteArray.fromHex((String)node.asText()));
    }
}

