/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.codec.binary.math;

import com.google.common.base.Strings;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Objects;

public class MathUtils {
    public static int getExponent(BigDecimal value) {
        return value.precision() - value.scale() - 1;
    }

    public static BigInteger toPaddedBigInteger(BigDecimal numberToPad, int expectedDigits) {
        Objects.requireNonNull(numberToPad);
        String unscaled = numberToPad.abs().stripTrailingZeros().unscaledValue().toString();
        if (unscaled.length() > expectedDigits) {
            throw new IllegalArgumentException(numberToPad + " has more than " + expectedDigits + " digits");
        }
        return new BigInteger(Strings.padEnd((String)unscaled, (int)expectedDigits, (char)'0'));
    }
}

