/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.codec.binary.definitions;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.xrpl.xrpl4j.codec.binary.BinaryCodecObjectMapperFactory;
import org.xrpl.xrpl4j.codec.binary.FieldHeader;
import org.xrpl.xrpl4j.codec.binary.ImmutableFieldHeader;
import org.xrpl.xrpl4j.codec.binary.definitions.Definitions;
import org.xrpl.xrpl4j.codec.binary.definitions.DefinitionsProvider;
import org.xrpl.xrpl4j.codec.binary.definitions.FieldInfo;
import org.xrpl.xrpl4j.codec.binary.definitions.FieldInstance;

public class DefinitionsService {
    private static final DefinitionsService INSTANCE = new DefinitionsService(DefinitionsProvider.getInstance(), BinaryCodecObjectMapperFactory.getObjectMapper());
    private final Definitions definitions;
    private final Map<String, FieldInfo> fieldInfoMap;
    private final Map<FieldHeader, String> fieldIdNameMap;
    private final Map<String, Integer> typeOrdinalMap;
    private final Map<Integer, String> transactionTypeReverseLookupMap;
    private final Map<Integer, String> transactionResultReverseLookupNap;
    private final Map<Integer, String> ledgerEntryTypeReverseLookupMap;

    DefinitionsService(DefinitionsProvider definitionsProvider, ObjectMapper mapper) {
        this.definitions = (Definitions)definitionsProvider.get();
        this.typeOrdinalMap = ImmutableMap.copyOf(this.definitions.types());
        HashMap tempFieldInfoMap = new HashMap();
        HashMap tempFieldIdNameMap = new HashMap();
        this.definitions.fields().forEach(field -> {
            try {
                String fieldName = ((JsonNode)field.get(0)).textValue();
                FieldInfo metadata = (FieldInfo)mapper.readValue(((JsonNode)field.get(1)).toString(), FieldInfo.class);
                ImmutableFieldHeader fieldHeader = FieldHeader.builder().fieldCode(metadata.nth()).typeCode(this.typeOrdinalMap.get(metadata.type())).build();
                tempFieldInfoMap.put(fieldName, metadata);
                tempFieldIdNameMap.put(fieldHeader, fieldName);
            }
            catch (JsonProcessingException e) {
                throw new IllegalArgumentException("invalid json", e);
            }
        });
        this.fieldInfoMap = ImmutableMap.copyOf(tempFieldInfoMap);
        this.fieldIdNameMap = ImmutableMap.copyOf(tempFieldIdNameMap);
        this.transactionTypeReverseLookupMap = this.inverse(this.definitions.transactionTypes());
        this.transactionResultReverseLookupNap = this.inverse(this.definitions.transactionResults());
        this.ledgerEntryTypeReverseLookupMap = this.inverse(this.definitions.ledgerEntryTypes());
    }

    public static DefinitionsService getInstance() {
        return INSTANCE;
    }

    public String getFieldName(FieldHeader fieldHeader) {
        return this.fieldIdNameMap.get(fieldHeader);
    }

    public Optional<FieldInfo> getFieldInfo(String fieldName) {
        return Optional.ofNullable(this.fieldInfoMap.get(fieldName));
    }

    public Integer getTypeOrdinal(String typeName) {
        return this.typeOrdinalMap.get(typeName);
    }

    public Optional<FieldHeader> getFieldHeader(String fieldName) {
        return this.getFieldInfo(fieldName).map(info -> {
            Integer typeCode = this.getTypeOrdinal(info.type());
            Preconditions.checkNotNull((Object)typeCode, (Object)(typeCode + " is not a valid type"));
            return FieldHeader.builder().typeCode(typeCode).fieldCode(info.nth()).build();
        });
    }

    public Optional<FieldInstance> getFieldInstance(String fieldName) {
        return DefinitionsService.getInstance().getFieldInfo(fieldName).flatMap(info -> this.getFieldHeader(fieldName).map(header -> FieldInstance.builder().header((FieldHeader)header).isSerialized(info.isSerialized()).isSigningField(info.isSigningField()).isVariableLengthEncoded(info.isVariableLengthEncoded()).nth(info.nth()).name(fieldName).type(info.type()).build()));
    }

    public Optional<Integer> mapFieldSpecialization(String fieldName, String value) {
        if (fieldName == null) {
            return Optional.empty();
        }
        switch (fieldName) {
            case "LedgerEntryType": {
                return Optional.ofNullable(this.definitions.ledgerEntryTypes().get(value));
            }
            case "TransactionResult": {
                return Optional.ofNullable(this.definitions.transactionResults().get(value));
            }
            case "TransactionType": {
                return Optional.ofNullable(this.definitions.transactionTypes().get(value));
            }
        }
        return Optional.empty();
    }

    public Optional<String> mapFieldRawValueToSpecialization(String fieldName, String value) {
        if (fieldName == null) {
            return Optional.empty();
        }
        switch (fieldName) {
            case "LedgerEntryType": {
                return Optional.ofNullable(this.ledgerEntryTypeReverseLookupMap.get(Integer.valueOf(value)));
            }
            case "TransactionResult": {
                return Optional.ofNullable(this.transactionResultReverseLookupNap.get(Integer.valueOf(value)));
            }
            case "TransactionType": {
                return Optional.ofNullable(this.transactionTypeReverseLookupMap.get(Integer.valueOf(value)));
            }
        }
        return Optional.empty();
    }

    private Map<Integer, String> inverse(Map<String, Integer> map) {
        return map.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
    }
}

