package org.xrpl.xrpl4j.codec.binary.types;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Hop}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableHop.builder()}.
 */
@Generated(from = "Hop", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableHop implements Hop {
  private final @Nullable JsonNode issuer;
  private final @Nullable JsonNode account;
  private final @Nullable JsonNode currency;

  private ImmutableHop(
      @Nullable JsonNode issuer,
      @Nullable JsonNode account,
      @Nullable JsonNode currency) {
    this.issuer = issuer;
    this.account = account;
    this.currency = currency;
  }

  /**
   * @return The value of the {@code issuer} attribute
   */
  @JsonProperty("issuer")
  @Override
  public Optional<JsonNode> issuer() {
    return Optional.ofNullable(issuer);
  }

  /**
   * @return The value of the {@code account} attribute
   */
  @JsonProperty("account")
  @Override
  public Optional<JsonNode> account() {
    return Optional.ofNullable(account);
  }

  /**
   * @return The value of the {@code currency} attribute
   */
  @JsonProperty("currency")
  @Override
  public Optional<JsonNode> currency() {
    return Optional.ofNullable(currency);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Hop#issuer() issuer} attribute.
   * @param value The value for issuer
   * @return A modified copy of {@code this} object
   */
  public final ImmutableHop withIssuer(JsonNode value) {
    @Nullable JsonNode newValue = Objects.requireNonNull(value, "issuer");
    if (this.issuer == newValue) return this;
    return new ImmutableHop(newValue, this.account, this.currency);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Hop#issuer() issuer} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for issuer
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutableHop withIssuer(Optional<? extends JsonNode> optional) {
    @Nullable JsonNode value = optional.orElse(null);
    if (this.issuer == value) return this;
    return new ImmutableHop(value, this.account, this.currency);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Hop#account() account} attribute.
   * @param value The value for account
   * @return A modified copy of {@code this} object
   */
  public final ImmutableHop withAccount(JsonNode value) {
    @Nullable JsonNode newValue = Objects.requireNonNull(value, "account");
    if (this.account == newValue) return this;
    return new ImmutableHop(this.issuer, newValue, this.currency);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Hop#account() account} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for account
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutableHop withAccount(Optional<? extends JsonNode> optional) {
    @Nullable JsonNode value = optional.orElse(null);
    if (this.account == value) return this;
    return new ImmutableHop(this.issuer, value, this.currency);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Hop#currency() currency} attribute.
   * @param value The value for currency
   * @return A modified copy of {@code this} object
   */
  public final ImmutableHop withCurrency(JsonNode value) {
    @Nullable JsonNode newValue = Objects.requireNonNull(value, "currency");
    if (this.currency == newValue) return this;
    return new ImmutableHop(this.issuer, this.account, newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Hop#currency() currency} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for currency
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutableHop withCurrency(Optional<? extends JsonNode> optional) {
    @Nullable JsonNode value = optional.orElse(null);
    if (this.currency == value) return this;
    return new ImmutableHop(this.issuer, this.account, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableHop} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableHop
        && equalTo((ImmutableHop) another);
  }

  private boolean equalTo(ImmutableHop another) {
    return Objects.equals(issuer, another.issuer)
        && Objects.equals(account, another.account)
        && Objects.equals(currency, another.currency);
  }

  /**
   * Computes a hash code from attributes: {@code issuer}, {@code account}, {@code currency}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(issuer);
    h += (h << 5) + Objects.hashCode(account);
    h += (h << 5) + Objects.hashCode(currency);
    return h;
  }

  /**
   * Prints the immutable value {@code Hop} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Hop")
        .omitNullValues()
        .add("issuer", issuer)
        .add("account", account)
        .add("currency", currency)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "Hop", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements Hop {
    @Nullable Optional<JsonNode> issuer = Optional.empty();
    @Nullable Optional<JsonNode> account = Optional.empty();
    @Nullable Optional<JsonNode> currency = Optional.empty();
    @JsonProperty("issuer")
    public void setIssuer(Optional<JsonNode> issuer) {
      this.issuer = issuer;
    }
    @JsonProperty("account")
    public void setAccount(Optional<JsonNode> account) {
      this.account = account;
    }
    @JsonProperty("currency")
    public void setCurrency(Optional<JsonNode> currency) {
      this.currency = currency;
    }
    @Override
    public Optional<JsonNode> issuer() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<JsonNode> account() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<JsonNode> currency() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableHop fromJson(Json json) {
    ImmutableHop.Builder builder = ImmutableHop.builder();
    if (json.issuer != null) {
      builder.issuer(json.issuer);
    }
    if (json.account != null) {
      builder.account(json.account);
    }
    if (json.currency != null) {
      builder.currency(json.currency);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link Hop} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Hop instance
   */
  public static ImmutableHop copyOf(Hop instance) {
    if (instance instanceof ImmutableHop) {
      return (ImmutableHop) instance;
    }
    return ImmutableHop.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableHop ImmutableHop}.
   * <pre>
   * ImmutableHop.builder()
   *    .issuer(com.fasterxml.jackson.databind.JsonNode) // optional {@link Hop#issuer() issuer}
   *    .account(com.fasterxml.jackson.databind.JsonNode) // optional {@link Hop#account() account}
   *    .currency(com.fasterxml.jackson.databind.JsonNode) // optional {@link Hop#currency() currency}
   *    .build();
   * </pre>
   * @return A new ImmutableHop builder
   */
  public static ImmutableHop.Builder builder() {
    return new ImmutableHop.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableHop ImmutableHop}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Hop", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @Nullable JsonNode issuer;
    private @Nullable JsonNode account;
    private @Nullable JsonNode currency;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Hop} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Hop instance) {
      Objects.requireNonNull(instance, "instance");
      Optional<JsonNode> issuerOptional = instance.issuer();
      if (issuerOptional.isPresent()) {
        issuer(issuerOptional);
      }
      Optional<JsonNode> accountOptional = instance.account();
      if (accountOptional.isPresent()) {
        account(accountOptional);
      }
      Optional<JsonNode> currencyOptional = instance.currency();
      if (currencyOptional.isPresent()) {
        currency(currencyOptional);
      }
      return this;
    }

    /**
     * Initializes the optional value {@link Hop#issuer() issuer} to issuer.
     * @param issuer The value for issuer
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder issuer(JsonNode issuer) {
      this.issuer = Objects.requireNonNull(issuer, "issuer");
      return this;
    }

    /**
     * Initializes the optional value {@link Hop#issuer() issuer} to issuer.
     * @param issuer The value for issuer
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("issuer")
    public final Builder issuer(Optional<? extends JsonNode> issuer) {
      this.issuer = issuer.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link Hop#account() account} to account.
     * @param account The value for account
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder account(JsonNode account) {
      this.account = Objects.requireNonNull(account, "account");
      return this;
    }

    /**
     * Initializes the optional value {@link Hop#account() account} to account.
     * @param account The value for account
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("account")
    public final Builder account(Optional<? extends JsonNode> account) {
      this.account = account.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link Hop#currency() currency} to currency.
     * @param currency The value for currency
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder currency(JsonNode currency) {
      this.currency = Objects.requireNonNull(currency, "currency");
      return this;
    }

    /**
     * Initializes the optional value {@link Hop#currency() currency} to currency.
     * @param currency The value for currency
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("currency")
    public final Builder currency(Optional<? extends JsonNode> currency) {
      this.currency = currency.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link ImmutableHop ImmutableHop}.
     * @return An immutable instance of Hop
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableHop build() {
      return new ImmutableHop(issuer, account, currency);
    }
  }
}
