package org.xrpl.xrpl4j.codec.binary;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link FieldHeader}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableFieldHeader.builder()}.
 */
@Generated(from = "FieldHeader", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableFieldHeader implements FieldHeader {
  private final int fieldCode;
  private final int typeCode;

  private ImmutableFieldHeader(int fieldCode, int typeCode) {
    this.fieldCode = fieldCode;
    this.typeCode = typeCode;
  }

  /**
   * @return The value of the {@code fieldCode} attribute
   */
  @JsonProperty("fieldCode")
  @Override
  public int fieldCode() {
    return fieldCode;
  }

  /**
   * @return The value of the {@code typeCode} attribute
   */
  @JsonProperty("typeCode")
  @Override
  public int typeCode() {
    return typeCode;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FieldHeader#fieldCode() fieldCode} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for fieldCode
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFieldHeader withFieldCode(int value) {
    if (this.fieldCode == value) return this;
    return new ImmutableFieldHeader(value, this.typeCode);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FieldHeader#typeCode() typeCode} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for typeCode
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFieldHeader withTypeCode(int value) {
    if (this.typeCode == value) return this;
    return new ImmutableFieldHeader(this.fieldCode, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableFieldHeader} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableFieldHeader
        && equalTo((ImmutableFieldHeader) another);
  }

  private boolean equalTo(ImmutableFieldHeader another) {
    return fieldCode == another.fieldCode
        && typeCode == another.typeCode;
  }

  /**
   * Computes a hash code from attributes: {@code fieldCode}, {@code typeCode}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + fieldCode;
    h += (h << 5) + typeCode;
    return h;
  }

  /**
   * Prints the immutable value {@code FieldHeader} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("FieldHeader")
        .omitNullValues()
        .add("fieldCode", fieldCode)
        .add("typeCode", typeCode)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "FieldHeader", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements FieldHeader {
    int fieldCode;
    boolean fieldCodeIsSet;
    int typeCode;
    boolean typeCodeIsSet;
    @JsonProperty("fieldCode")
    public void setFieldCode(int fieldCode) {
      this.fieldCode = fieldCode;
      this.fieldCodeIsSet = true;
    }
    @JsonProperty("typeCode")
    public void setTypeCode(int typeCode) {
      this.typeCode = typeCode;
      this.typeCodeIsSet = true;
    }
    @Override
    public int fieldCode() { throw new UnsupportedOperationException(); }
    @Override
    public int typeCode() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableFieldHeader fromJson(Json json) {
    ImmutableFieldHeader.Builder builder = ImmutableFieldHeader.builder();
    if (json.fieldCodeIsSet) {
      builder.fieldCode(json.fieldCode);
    }
    if (json.typeCodeIsSet) {
      builder.typeCode(json.typeCode);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link FieldHeader} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable FieldHeader instance
   */
  public static ImmutableFieldHeader copyOf(FieldHeader instance) {
    if (instance instanceof ImmutableFieldHeader) {
      return (ImmutableFieldHeader) instance;
    }
    return ImmutableFieldHeader.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableFieldHeader ImmutableFieldHeader}.
   * <pre>
   * ImmutableFieldHeader.builder()
   *    .fieldCode(int) // required {@link FieldHeader#fieldCode() fieldCode}
   *    .typeCode(int) // required {@link FieldHeader#typeCode() typeCode}
   *    .build();
   * </pre>
   * @return A new ImmutableFieldHeader builder
   */
  public static ImmutableFieldHeader.Builder builder() {
    return new ImmutableFieldHeader.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableFieldHeader ImmutableFieldHeader}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "FieldHeader", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_FIELD_CODE = 0x1L;
    private static final long INIT_BIT_TYPE_CODE = 0x2L;
    private long initBits = 0x3L;

    private int fieldCode;
    private int typeCode;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code FieldHeader} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(FieldHeader instance) {
      Objects.requireNonNull(instance, "instance");
      fieldCode(instance.fieldCode());
      typeCode(instance.typeCode());
      return this;
    }

    /**
     * Initializes the value for the {@link FieldHeader#fieldCode() fieldCode} attribute.
     * @param fieldCode The value for fieldCode 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("fieldCode")
    public final Builder fieldCode(int fieldCode) {
      this.fieldCode = fieldCode;
      initBits &= ~INIT_BIT_FIELD_CODE;
      return this;
    }

    /**
     * Initializes the value for the {@link FieldHeader#typeCode() typeCode} attribute.
     * @param typeCode The value for typeCode 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("typeCode")
    public final Builder typeCode(int typeCode) {
      this.typeCode = typeCode;
      initBits &= ~INIT_BIT_TYPE_CODE;
      return this;
    }

    /**
     * Builds a new {@link ImmutableFieldHeader ImmutableFieldHeader}.
     * @return An immutable instance of FieldHeader
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableFieldHeader build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableFieldHeader(fieldCode, typeCode);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_FIELD_CODE) != 0) attributes.add("fieldCode");
      if ((initBits & INIT_BIT_TYPE_CODE) != 0) attributes.add("typeCode");
      return "Cannot build FieldHeader, some of required attributes are not set " + attributes;
    }
  }
}
