/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.codec.binary.types;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.ArrayList;
import java.util.Iterator;
import org.xrpl.xrpl4j.codec.addresses.UnsignedByteArray;
import org.xrpl.xrpl4j.codec.binary.BinaryCodecObjectMapperFactory;
import org.xrpl.xrpl4j.codec.binary.serdes.BinaryParser;
import org.xrpl.xrpl4j.codec.binary.types.Hash256Type;
import org.xrpl.xrpl4j.codec.binary.types.SerializedType;

public class Vector256Type
extends SerializedType<Vector256Type> {
    public static final int WIDTH = 32;

    public Vector256Type() {
        this(UnsignedByteArray.empty());
    }

    public Vector256Type(UnsignedByteArray list) {
        super(list);
    }

    @Override
    public Vector256Type fromParser(BinaryParser parser, int lengthHint) {
        UnsignedByteArray byteArray = UnsignedByteArray.empty();
        int bytes = lengthHint;
        int hashes = bytes / 32;
        for (int i = 0; i < hashes; ++i) {
            new Hash256Type().fromParser(parser).toBytesSink(byteArray);
        }
        return new Vector256Type(byteArray);
    }

    @Override
    public Vector256Type fromJson(JsonNode node) {
        if (!node.isArray()) {
            throw new IllegalArgumentException("node is not an array");
        }
        UnsignedByteArray byteList = UnsignedByteArray.empty();
        Iterator nodeIterator = node.elements();
        while (nodeIterator.hasNext()) {
            JsonNode child = (JsonNode)nodeIterator.next();
            if (!child.isTextual()) {
                throw new IllegalArgumentException("non-string value found in vector");
            }
            new Hash256Type().fromJson(child).toBytesSink(byteList);
        }
        return new Vector256Type(byteList);
    }

    @Override
    public JsonNode toJson() {
        BinaryParser parser = new BinaryParser(this.toString());
        ArrayList<TextNode> values = new ArrayList<TextNode>();
        while (parser.hasMore()) {
            UnsignedByteArray bytes = parser.read(32);
            values.add(new TextNode(bytes.hexValue()));
        }
        return new ArrayNode(BinaryCodecObjectMapperFactory.getObjectMapper().getNodeFactory(), values);
    }
}

