/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.codec.binary.serdes;

import com.google.common.primitives.UnsignedLong;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import org.xrpl.xrpl4j.codec.addresses.ByteUtils;
import org.xrpl.xrpl4j.codec.addresses.UnsignedByte;
import org.xrpl.xrpl4j.codec.addresses.UnsignedByteArray;
import org.xrpl.xrpl4j.codec.binary.FieldHeader;
import org.xrpl.xrpl4j.codec.binary.definitions.DefinitionsService;
import org.xrpl.xrpl4j.codec.binary.definitions.FieldInstance;
import org.xrpl.xrpl4j.codec.binary.types.FieldWithValue;
import org.xrpl.xrpl4j.codec.binary.types.SerializedType;

public class BinaryParser {
    public static final int MAX_SINGLE_BYTE_LENGTH = 192;
    public static final int MAX_DOUBLE_BYTE_LENGTH = 12481;
    public static final int MAX_SECOND_BYTE_VALUE = 240;
    public static final int MAX_BYTE_VALUE = 256;
    public static final int MAX_DOUBLE_BYTE_VALUE = 65536;
    private static final int BYTE_HEX_LENGTH = 2;
    private final String hex;
    private int cursor = 0;

    public BinaryParser(String hex) {
        this.hex = hex;
    }

    public UnsignedByte peek() {
        return UnsignedByte.of((String)this.hex.substring(this.cursor, this.cursor + 2));
    }

    public void skip(int bytesToSkip) {
        this.cursor += bytesToSkip * 2;
    }

    public UnsignedByteArray read(int bytesToRead) {
        if (this.cursor >= this.hex.length()) {
            throw new IndexOutOfBoundsException("cursor moved past end of buffer");
        }
        ArrayList<UnsignedByte> result = new ArrayList<UnsignedByte>();
        for (int i = 0; i < bytesToRead; ++i) {
            result.add(this.peek());
            this.skip(1);
        }
        return new UnsignedByteArray(result);
    }

    public UnsignedLong readUInt8() {
        return this.readUInt(1);
    }

    public UnsignedLong readUInt16() {
        return this.readUInt(2);
    }

    public UnsignedLong readUInt32() {
        return this.readUInt(4);
    }

    public UnsignedLong readUInt64() {
        return this.readUInt(8);
    }

    public int size() {
        return this.hex.length() / 2;
    }

    public boolean hasMore() {
        return this.cursor < this.hex.length();
    }

    public int readVariableLengthLength() {
        int firstByte = this.readUInt8().intValue();
        if (firstByte <= 192) {
            return firstByte;
        }
        if (firstByte <= 240) {
            int b2 = this.readUInt8().intValue();
            return 239 + (firstByte - 240 - 1) * 256 + b2;
        }
        if (firstByte <= 254) {
            int b2 = this.readUInt8().intValue();
            int b3 = this.readUInt8().intValue();
            return 12481 + (firstByte - 240 - 1) * 65536 + b2 * 256 + b3;
        }
        throw new Error("Invalid variable length indicator");
    }

    public FieldHeader readFieldHeader() {
        int type = this.readUInt8().intValue();
        int nth = type & 0xF;
        if ((type >>= 4) == 0 && ((type = this.readUInt8().intValue()) == 0 || type < 16)) {
            throw new Error("Cannot read FieldOrdinal, type_code out of range");
        }
        if (nth == 0 && ((nth = this.readUInt8().intValue()) == 0 || nth < 16)) {
            throw new Error("Cannot read FieldOrdinal, field_code out of range");
        }
        return FieldHeader.builder().fieldCode(nth).typeCode(type).build();
    }

    public Optional<FieldInstance> readField() {
        FieldHeader header = this.readFieldHeader();
        String fieldName = DefinitionsService.getInstance().getFieldName(header);
        return DefinitionsService.getInstance().getFieldInstance(fieldName);
    }

    public <T extends SerializedType<T>> T readType(Class<T> type) {
        try {
            return ((SerializedType)type.getDeclaredConstructor(new Class[0]).newInstance(new Object[0])).fromParser(this);
        }
        catch (Exception e) {
            throw new RuntimeException("could not instantiate field of type " + type.getName(), e);
        }
    }

    public SerializedType typeForField(FieldInstance field) {
        return SerializedType.getTypeByName(field.type());
    }

    public SerializedType readFieldValue(FieldInstance field) {
        Objects.requireNonNull(field);
        SerializedType type = this.typeForField(field);
        if (type == null) {
            throw new IllegalArgumentException("unsupported type " + type);
        }
        try {
            if (field.isVariableLengthEncoded()) {
                int sizeHint = this.readVariableLengthLength();
                return type.fromParser(this, sizeHint);
            }
            return type.fromParser(this);
        }
        catch (Exception e) {
            throw new RuntimeException("could not instantiate field of type " + field.name(), e);
        }
    }

    public Optional<FieldWithValue> readFieldAndValue() {
        return this.readField().map(field -> FieldWithValue.builder().field((FieldInstance)field).value(this.readFieldValue((FieldInstance)field)).build());
    }

    private UnsignedLong readUInt(int bytes) {
        return ByteUtils.toUnsignedLong((UnsignedByteArray)this.read(bytes));
    }
}

