/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.codec.binary;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.xrpl.xrpl4j.codec.addresses.ByteUtils;
import org.xrpl.xrpl4j.codec.addresses.UnsignedByte;
import org.xrpl.xrpl4j.codec.binary.BinaryCodecObjectMapperFactory;
import org.xrpl.xrpl4j.codec.binary.FieldHeader;
import org.xrpl.xrpl4j.codec.binary.ImmutableFieldHeader;
import org.xrpl.xrpl4j.codec.binary.definitions.Definitions;
import org.xrpl.xrpl4j.codec.binary.definitions.DefinitionsProvider;
import org.xrpl.xrpl4j.codec.binary.definitions.FieldInfo;

public class FieldHeaderCodec {
    private static final FieldHeaderCodec INSTANCE = new FieldHeaderCodec((Definitions)DefinitionsProvider.getInstance().get(), BinaryCodecObjectMapperFactory.getObjectMapper());
    private final Definitions definitions;
    private final Map<String, FieldInfo> fieldMetadataMap;
    private final Map<FieldHeader, String> fieldIdNameMap;
    private final Map<String, Integer> typeOrdinalMap;

    public FieldHeaderCodec(Definitions definitions, ObjectMapper mapper) {
        this.definitions = definitions;
        this.fieldMetadataMap = new HashMap<String, FieldInfo>();
        this.fieldIdNameMap = new HashMap<FieldHeader, String>();
        this.typeOrdinalMap = definitions.types();
        this.definitions.fields().forEach(field -> {
            try {
                String fieldName = ((JsonNode)field.get(0)).textValue();
                FieldInfo metadata = (FieldInfo)mapper.readValue(((JsonNode)field.get(1)).toString(), FieldInfo.class);
                ImmutableFieldHeader fieldHeader = FieldHeader.builder().fieldCode(metadata.nth()).typeCode(this.typeOrdinalMap.get(metadata.type())).build();
                this.fieldMetadataMap.put(fieldName, metadata);
                this.fieldIdNameMap.put(fieldHeader, fieldName);
            }
            catch (JsonProcessingException e) {
                throw new IllegalArgumentException("invalid json", e);
            }
        });
    }

    public static FieldHeaderCodec getInstance() {
        return INSTANCE;
    }

    public String encode(String fieldName) {
        return this.encode(this.getFieldId(fieldName));
    }

    protected String encode(FieldHeader fieldHeader) {
        ArrayList<UnsignedByte> segments = new ArrayList<UnsignedByte>();
        int typeCode = fieldHeader.typeCode();
        int fieldCode = fieldHeader.fieldCode();
        if (typeCode < 16) {
            if (fieldCode < 16) {
                segments.add(UnsignedByte.of((byte)((byte)typeCode), (byte)((byte)fieldCode)));
            } else {
                segments.add(UnsignedByte.of((byte)((byte)typeCode), (byte)0));
                segments.add(UnsignedByte.of((int)fieldCode));
            }
        } else if (fieldCode < 16) {
            segments.add(UnsignedByte.of((byte)0, (byte)((byte)fieldCode)));
            segments.add(UnsignedByte.of((int)typeCode));
        } else {
            segments.add(UnsignedByte.of((byte)0));
            segments.add(UnsignedByte.of((int)typeCode));
            segments.add(UnsignedByte.of((int)fieldCode));
        }
        return ByteUtils.toHex(segments);
    }

    public String decode(String hex) {
        FieldHeader fieldHeader = this.decodeFieldId(hex);
        return this.fieldIdNameMap.get(fieldHeader);
    }

    protected FieldHeader decodeFieldId(String hex) {
        Preconditions.checkNotNull((Object)hex, (Object)"hex cannot be null");
        Preconditions.checkArgument((hex.length() >= 2 ? 1 : 0) != 0, (Object)"hex must be at least 2 characters");
        List segments = ByteUtils.parse((String)hex);
        Preconditions.checkArgument((segments.size() <= 3 ? 1 : 0) != 0, (Object)"hex value is too large");
        if (segments.size() == 1) {
            UnsignedByte first = (UnsignedByte)segments.get(0);
            return FieldHeader.builder().typeCode(first.getHighBits()).fieldCode(first.getLowBits()).build();
        }
        if (segments.size() == 2) {
            UnsignedByte first = (UnsignedByte)segments.get(0);
            UnsignedByte second = (UnsignedByte)segments.get(1);
            if (first.getHighBits() == 0) {
                return FieldHeader.builder().fieldCode(first.getLowBits()).typeCode(second.asInt()).build();
            }
            return FieldHeader.builder().typeCode(first.getHighBits()).fieldCode(second.asInt()).build();
        }
        return FieldHeader.builder().typeCode(((UnsignedByte)segments.get(1)).asInt()).fieldCode(((UnsignedByte)segments.get(2)).asInt()).build();
    }

    protected FieldHeader getFieldId(String fieldName) {
        FieldInfo metadata = this.fieldMetadataMap.get(fieldName);
        Preconditions.checkNotNull((Object)metadata, (Object)(fieldName + " is not a valid field name"));
        Integer typeCode = this.typeOrdinalMap.get(metadata.type());
        Preconditions.checkNotNull((Object)typeCode, (Object)(typeCode + " is not a valid type"));
        return FieldHeader.builder().typeCode(typeCode).fieldCode(metadata.nth()).build();
    }
}

