package org.xrpl.xrpl4j.codec.addresses;

import com.google.common.base.MoreObjects;
import com.google.common.primitives.Booleans;
import com.google.common.primitives.UnsignedInteger;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link DecodedXAddress}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableDecodedXAddress.builder()}.
 */
@Generated(from = "DecodedXAddress", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableDecodedXAddress implements DecodedXAddress {
  private final UnsignedByteArray accountId;
  private final UnsignedInteger tag;
  private final boolean test;

  private ImmutableDecodedXAddress(
      UnsignedByteArray accountId,
      UnsignedInteger tag,
      boolean test) {
    this.accountId = accountId;
    this.tag = tag;
    this.test = test;
  }

  /**
   * The Account ID of the X-Address.
   * @return An {@link UnsignedByteArray} containing the Account ID.
   */
  @Override
  public UnsignedByteArray accountId() {
    return accountId;
  }

  /**
   * The tag of the X-Address.
   * @return An {@link UnsignedInteger} representing the tag.
   */
  @Override
  public UnsignedInteger tag() {
    return tag;
  }

  /**
   * Whether or not this address exists on mainnet or testnet.
   * @return {@code true} if it is a tesnet address, {@code false} if it is mainnet.
   */
  @Override
  public boolean test() {
    return test;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DecodedXAddress#accountId() accountId} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for accountId
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDecodedXAddress withAccountId(UnsignedByteArray value) {
    if (this.accountId == value) return this;
    UnsignedByteArray newValue = Objects.requireNonNull(value, "accountId");
    return new ImmutableDecodedXAddress(newValue, this.tag, this.test);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DecodedXAddress#tag() tag} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for tag
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDecodedXAddress withTag(UnsignedInteger value) {
    UnsignedInteger newValue = Objects.requireNonNull(value, "tag");
    if (this.tag.equals(newValue)) return this;
    return new ImmutableDecodedXAddress(this.accountId, newValue, this.test);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DecodedXAddress#test() test} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for test
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDecodedXAddress withTest(boolean value) {
    if (this.test == value) return this;
    return new ImmutableDecodedXAddress(this.accountId, this.tag, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableDecodedXAddress} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableDecodedXAddress
        && equalTo((ImmutableDecodedXAddress) another);
  }

  private boolean equalTo(ImmutableDecodedXAddress another) {
    return accountId.equals(another.accountId)
        && tag.equals(another.tag)
        && test == another.test;
  }

  /**
   * Computes a hash code from attributes: {@code accountId}, {@code tag}, {@code test}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + accountId.hashCode();
    h += (h << 5) + tag.hashCode();
    h += (h << 5) + Booleans.hashCode(test);
    return h;
  }

  /**
   * Prints the immutable value {@code DecodedXAddress} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("DecodedXAddress")
        .omitNullValues()
        .add("accountId", accountId)
        .add("tag", tag)
        .add("test", test)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link DecodedXAddress} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable DecodedXAddress instance
   */
  public static ImmutableDecodedXAddress copyOf(DecodedXAddress instance) {
    if (instance instanceof ImmutableDecodedXAddress) {
      return (ImmutableDecodedXAddress) instance;
    }
    return ImmutableDecodedXAddress.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableDecodedXAddress ImmutableDecodedXAddress}.
   * <pre>
   * ImmutableDecodedXAddress.builder()
   *    .accountId(org.xrpl.xrpl4j.codec.addresses.UnsignedByteArray) // required {@link DecodedXAddress#accountId() accountId}
   *    .tag(com.google.common.primitives.UnsignedInteger) // required {@link DecodedXAddress#tag() tag}
   *    .test(boolean) // required {@link DecodedXAddress#test() test}
   *    .build();
   * </pre>
   * @return A new ImmutableDecodedXAddress builder
   */
  public static ImmutableDecodedXAddress.Builder builder() {
    return new ImmutableDecodedXAddress.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableDecodedXAddress ImmutableDecodedXAddress}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "DecodedXAddress", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_ACCOUNT_ID = 0x1L;
    private static final long INIT_BIT_TAG = 0x2L;
    private static final long INIT_BIT_TEST = 0x4L;
    private long initBits = 0x7L;

    private @Nullable UnsignedByteArray accountId;
    private @Nullable UnsignedInteger tag;
    private boolean test;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code DecodedXAddress} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(DecodedXAddress instance) {
      Objects.requireNonNull(instance, "instance");
      accountId(instance.accountId());
      tag(instance.tag());
      test(instance.test());
      return this;
    }

    /**
     * Initializes the value for the {@link DecodedXAddress#accountId() accountId} attribute.
     * @param accountId The value for accountId 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder accountId(UnsignedByteArray accountId) {
      this.accountId = Objects.requireNonNull(accountId, "accountId");
      initBits &= ~INIT_BIT_ACCOUNT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link DecodedXAddress#tag() tag} attribute.
     * @param tag The value for tag 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder tag(UnsignedInteger tag) {
      this.tag = Objects.requireNonNull(tag, "tag");
      initBits &= ~INIT_BIT_TAG;
      return this;
    }

    /**
     * Initializes the value for the {@link DecodedXAddress#test() test} attribute.
     * @param test The value for test 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder test(boolean test) {
      this.test = test;
      initBits &= ~INIT_BIT_TEST;
      return this;
    }

    /**
     * Builds a new {@link ImmutableDecodedXAddress ImmutableDecodedXAddress}.
     * @return An immutable instance of DecodedXAddress
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableDecodedXAddress build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableDecodedXAddress(accountId, tag, test);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ACCOUNT_ID) != 0) attributes.add("accountId");
      if ((initBits & INIT_BIT_TAG) != 0) attributes.add("tag");
      if ((initBits & INIT_BIT_TEST) != 0) attributes.add("test");
      return "Cannot build DecodedXAddress, some of required attributes are not set " + attributes;
    }
  }
}
