package org.xrpl.xrpl4j.codec.addresses;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Decoded}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableDecoded.builder()}.
 */
@Generated(from = "Decoded", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableDecoded implements Decoded {
  private final Version version;
  private final UnsignedByteArray bytes;
  private final @Nullable VersionType type;

  private ImmutableDecoded(
      Version version,
      UnsignedByteArray bytes,
      @Nullable VersionType type) {
    this.version = version;
    this.bytes = bytes;
    this.type = type;
  }

  /**
   * The {@link Version} of the decoded Base58 {@link String}.
   * @return A {@link Version}.
   */
  @Override
  public Version version() {
    return version;
  }

  /**
   * The bytes of the decoded Base58 {@link String}.
   * @return An {@link UnsignedByteArray}.
   */
  @Override
  public UnsignedByteArray bytes() {
    return bytes;
  }

  /**
   * The {@link VersionType} of the decoded Base58 {@link String}.
   * @return An optionally present {@link VersionType}.
   */
  @Override
  public Optional<VersionType> type() {
    return Optional.ofNullable(type);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Decoded#version() version} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for version
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDecoded withVersion(Version value) {
    if (this.version == value) return this;
    Version newValue = Objects.requireNonNull(value, "version");
    if (this.version.equals(newValue)) return this;
    return new ImmutableDecoded(newValue, this.bytes, this.type);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Decoded#bytes() bytes} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for bytes
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDecoded withBytes(UnsignedByteArray value) {
    if (this.bytes == value) return this;
    UnsignedByteArray newValue = Objects.requireNonNull(value, "bytes");
    return new ImmutableDecoded(this.version, newValue, this.type);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Decoded#type() type} attribute.
   * @param value The value for type
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDecoded withType(VersionType value) {
    @Nullable VersionType newValue = Objects.requireNonNull(value, "type");
    if (this.type == newValue) return this;
    return new ImmutableDecoded(this.version, this.bytes, newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Decoded#type() type} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for type
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutableDecoded withType(Optional<? extends VersionType> optional) {
    @Nullable VersionType value = optional.orElse(null);
    if (Objects.equals(this.type, value)) return this;
    return new ImmutableDecoded(this.version, this.bytes, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableDecoded} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableDecoded
        && equalTo((ImmutableDecoded) another);
  }

  private boolean equalTo(ImmutableDecoded another) {
    return version.equals(another.version)
        && bytes.equals(another.bytes)
        && Objects.equals(type, another.type);
  }

  /**
   * Computes a hash code from attributes: {@code version}, {@code bytes}, {@code type}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + version.hashCode();
    h += (h << 5) + bytes.hashCode();
    h += (h << 5) + Objects.hashCode(type);
    return h;
  }

  /**
   * Prints the immutable value {@code Decoded} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Decoded")
        .omitNullValues()
        .add("version", version)
        .add("bytes", bytes)
        .add("type", type)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link Decoded} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Decoded instance
   */
  public static ImmutableDecoded copyOf(Decoded instance) {
    if (instance instanceof ImmutableDecoded) {
      return (ImmutableDecoded) instance;
    }
    return ImmutableDecoded.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableDecoded ImmutableDecoded}.
   * <pre>
   * ImmutableDecoded.builder()
   *    .version(org.xrpl.xrpl4j.codec.addresses.Version) // required {@link Decoded#version() version}
   *    .bytes(org.xrpl.xrpl4j.codec.addresses.UnsignedByteArray) // required {@link Decoded#bytes() bytes}
   *    .type(org.xrpl.xrpl4j.codec.addresses.VersionType) // optional {@link Decoded#type() type}
   *    .build();
   * </pre>
   * @return A new ImmutableDecoded builder
   */
  public static ImmutableDecoded.Builder builder() {
    return new ImmutableDecoded.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableDecoded ImmutableDecoded}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Decoded", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_VERSION = 0x1L;
    private static final long INIT_BIT_BYTES = 0x2L;
    private long initBits = 0x3L;

    private @Nullable Version version;
    private @Nullable UnsignedByteArray bytes;
    private @Nullable VersionType type;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Decoded} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Decoded instance) {
      Objects.requireNonNull(instance, "instance");
      version(instance.version());
      bytes(instance.bytes());
      Optional<VersionType> typeOptional = instance.type();
      if (typeOptional.isPresent()) {
        type(typeOptional);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Decoded#version() version} attribute.
     * @param version The value for version 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder version(Version version) {
      this.version = Objects.requireNonNull(version, "version");
      initBits &= ~INIT_BIT_VERSION;
      return this;
    }

    /**
     * Initializes the value for the {@link Decoded#bytes() bytes} attribute.
     * @param bytes The value for bytes 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder bytes(UnsignedByteArray bytes) {
      this.bytes = Objects.requireNonNull(bytes, "bytes");
      initBits &= ~INIT_BIT_BYTES;
      return this;
    }

    /**
     * Initializes the optional value {@link Decoded#type() type} to type.
     * @param type The value for type
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder type(VersionType type) {
      this.type = Objects.requireNonNull(type, "type");
      return this;
    }

    /**
     * Initializes the optional value {@link Decoded#type() type} to type.
     * @param type The value for type
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder type(Optional<? extends VersionType> type) {
      this.type = type.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link ImmutableDecoded ImmutableDecoded}.
     * @return An immutable instance of Decoded
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableDecoded build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableDecoded(version, bytes, type);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_VERSION) != 0) attributes.add("version");
      if ((initBits & INIT_BIT_BYTES) != 0) attributes.add("bytes");
      return "Cannot build Decoded, some of required attributes are not set " + attributes;
    }
  }
}
