package org.xrpl.xrpl4j.codec.addresses;

import com.google.common.base.MoreObjects;
import com.google.common.primitives.Booleans;
import com.google.common.primitives.UnsignedInteger;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.xrpl.xrpl4j.model.transactions.Address;

/**
 * Immutable implementation of {@link ClassicAddress}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableClassicAddress.builder()}.
 */
@Generated(from = "ClassicAddress", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableClassicAddress implements ClassicAddress {
  private final Address classicAddress;
  private final UnsignedInteger tag;
  private final boolean test;

  private ImmutableClassicAddress(
      Address classicAddress,
      UnsignedInteger tag,
      boolean test) {
    this.classicAddress = classicAddress;
    this.tag = tag;
    this.test = test;
  }

  /**
   * A classic address, as an {@link Address}.
   * @return An {@link Address} containing the classic address.
   */
  @Override
  public Address classicAddress() {
    return classicAddress;
  }

  /**
   * The tag of the classic address.
   * @return An {@link UnsignedInteger}.
   */
  @Override
  public UnsignedInteger tag() {
    return tag;
  }

  /**
   * Whether or not this address exists on mainnet or testnet.
   * @return {@code true} if it is a tesnet address, {@code false} if it is mainnet.
   */
  @Override
  public boolean test() {
    return test;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ClassicAddress#classicAddress() classicAddress} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for classicAddress
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableClassicAddress withClassicAddress(Address value) {
    if (this.classicAddress == value) return this;
    Address newValue = Objects.requireNonNull(value, "classicAddress");
    return new ImmutableClassicAddress(newValue, this.tag, this.test);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ClassicAddress#tag() tag} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for tag
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableClassicAddress withTag(UnsignedInteger value) {
    UnsignedInteger newValue = Objects.requireNonNull(value, "tag");
    if (this.tag.equals(newValue)) return this;
    return new ImmutableClassicAddress(this.classicAddress, newValue, this.test);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ClassicAddress#test() test} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for test
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableClassicAddress withTest(boolean value) {
    if (this.test == value) return this;
    return new ImmutableClassicAddress(this.classicAddress, this.tag, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableClassicAddress} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableClassicAddress
        && equalTo((ImmutableClassicAddress) another);
  }

  private boolean equalTo(ImmutableClassicAddress another) {
    return classicAddress.equals(another.classicAddress)
        && tag.equals(another.tag)
        && test == another.test;
  }

  /**
   * Computes a hash code from attributes: {@code classicAddress}, {@code tag}, {@code test}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + classicAddress.hashCode();
    h += (h << 5) + tag.hashCode();
    h += (h << 5) + Booleans.hashCode(test);
    return h;
  }

  /**
   * Prints the immutable value {@code ClassicAddress} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ClassicAddress")
        .omitNullValues()
        .add("classicAddress", classicAddress)
        .add("tag", tag)
        .add("test", test)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link ClassicAddress} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ClassicAddress instance
   */
  public static ImmutableClassicAddress copyOf(ClassicAddress instance) {
    if (instance instanceof ImmutableClassicAddress) {
      return (ImmutableClassicAddress) instance;
    }
    return ImmutableClassicAddress.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableClassicAddress ImmutableClassicAddress}.
   * <pre>
   * ImmutableClassicAddress.builder()
   *    .classicAddress(org.xrpl.xrpl4j.model.transactions.Address) // required {@link ClassicAddress#classicAddress() classicAddress}
   *    .tag(com.google.common.primitives.UnsignedInteger) // required {@link ClassicAddress#tag() tag}
   *    .test(boolean) // required {@link ClassicAddress#test() test}
   *    .build();
   * </pre>
   * @return A new ImmutableClassicAddress builder
   */
  public static ImmutableClassicAddress.Builder builder() {
    return new ImmutableClassicAddress.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableClassicAddress ImmutableClassicAddress}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ClassicAddress", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_CLASSIC_ADDRESS = 0x1L;
    private static final long INIT_BIT_TAG = 0x2L;
    private static final long INIT_BIT_TEST = 0x4L;
    private long initBits = 0x7L;

    private @Nullable Address classicAddress;
    private @Nullable UnsignedInteger tag;
    private boolean test;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ClassicAddress} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ClassicAddress instance) {
      Objects.requireNonNull(instance, "instance");
      classicAddress(instance.classicAddress());
      tag(instance.tag());
      test(instance.test());
      return this;
    }

    /**
     * Initializes the value for the {@link ClassicAddress#classicAddress() classicAddress} attribute.
     * @param classicAddress The value for classicAddress 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder classicAddress(Address classicAddress) {
      this.classicAddress = Objects.requireNonNull(classicAddress, "classicAddress");
      initBits &= ~INIT_BIT_CLASSIC_ADDRESS;
      return this;
    }

    /**
     * Initializes the value for the {@link ClassicAddress#tag() tag} attribute.
     * @param tag The value for tag 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder tag(UnsignedInteger tag) {
      this.tag = Objects.requireNonNull(tag, "tag");
      initBits &= ~INIT_BIT_TAG;
      return this;
    }

    /**
     * Initializes the value for the {@link ClassicAddress#test() test} attribute.
     * @param test The value for test 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder test(boolean test) {
      this.test = test;
      initBits &= ~INIT_BIT_TEST;
      return this;
    }

    /**
     * Builds a new {@link ImmutableClassicAddress ImmutableClassicAddress}.
     * @return An immutable instance of ClassicAddress
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableClassicAddress build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableClassicAddress(classicAddress, tag, test);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_CLASSIC_ADDRESS) != 0) attributes.add("classicAddress");
      if ((initBits & INIT_BIT_TAG) != 0) attributes.add("tag");
      if ((initBits & INIT_BIT_TEST) != 0) attributes.add("test");
      return "Cannot build ClassicAddress, some of required attributes are not set " + attributes;
    }
  }
}
