/*
 * Decompiled with CFR 0.152.
 */
package org.custommonkey.xmlunit;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.custommonkey.xmlunit.exceptions.XMLUnitRuntimeException;
import org.custommonkey.xmlunit.util.IntegerBuffer;

final class DoctypeSupport {
    static final String DOCTYPE_OPEN_DECL = "<!";
    static final String DOCTYPE_CLOSE_DECL = ">";
    static final String DOCTYPE = "DOCTYPE ";
    static final String SYSTEM = " SYSTEM \"";
    private static final int[] DOCTYPE_INTS = new int[]{68, 79, 67, 84, 89, 80, 69, 32};
    private boolean hasSplit;
    private final Readable original;
    private Readable decl;
    private Readable beforeDoctype;
    private Readable afterDoctype;

    DoctypeSupport(String name, String systemId, Readable original, boolean characters, String encoding) {
        this.original = original;
        StringBuffer sb = new StringBuffer(DOCTYPE_OPEN_DECL);
        sb.append(DOCTYPE).append(name).append(SYSTEM).append(systemId).append('\"').append(DOCTYPE_CLOSE_DECL);
        String s = sb.toString();
        IntegerBuffer buf = new IntegerBuffer(s.length() * (characters ? 1 : 2));
        if (characters) {
            char[] c = s.toCharArray();
            for (int i = 0; i < c.length; ++i) {
                buf.append(c[i]);
            }
        } else {
            try {
                byte[] b = encoding == null ? s.getBytes() : s.getBytes(encoding);
                for (int i = 0; i < b.length; ++i) {
                    buf.append(b[i] & 0xFF);
                }
            }
            catch (UnsupportedEncodingException use) {
                throw new XMLUnitRuntimeException("Unsupported encoding", use);
            }
        }
        this.decl = new IntBufferReadable(buf);
    }

    int read() throws IOException {
        int nextInt = -1;
        if (!this.hasSplit) {
            this.split();
        }
        if (this.beforeDoctype != null && (nextInt = this.beforeDoctype.read()) == -1) {
            this.beforeDoctype = null;
        }
        if (nextInt == -1 && this.decl != null && (nextInt = this.decl.read()) == -1) {
            this.decl = null;
        }
        if (nextInt == -1 && this.afterDoctype != null && (nextInt = this.afterDoctype.read()) == -1) {
            this.afterDoctype = null;
        }
        if (nextInt == -1) {
            nextInt = this.original.read();
        }
        return nextInt;
    }

    private void split() throws IOException {
        IntegerBuffer b;
        int[] elementOrDeclOr;
        int current;
        this.hasSplit = true;
        IntegerBuffer before = new IntegerBuffer();
        IntegerBuffer after = new IntegerBuffer();
        boolean ready = false;
        boolean stillNeedToSeeDoctype = true;
        while (!ready && (current = this.original.read()) != -1) {
            if (Character.isWhitespace((char)current)) {
                before.append(current);
                continue;
            }
            if (current == 60) {
                elementOrDeclOr = this.readUntilCloseCharIsReached();
                if (elementOrDeclOr.length > 0) {
                    if (elementOrDeclOr[0] == 63) {
                        before.append(60);
                        before.append(elementOrDeclOr);
                        continue;
                    }
                    if (elementOrDeclOr[0] != 33) {
                        after.append(60);
                        after.append(elementOrDeclOr);
                        stillNeedToSeeDoctype = false;
                        ready = true;
                        continue;
                    }
                    b = new IntegerBuffer(elementOrDeclOr.length);
                    b.append(elementOrDeclOr);
                    if (b.indexOf(DOCTYPE_INTS) == -1) {
                        after.append(60);
                        after.append(elementOrDeclOr);
                    } else {
                        stillNeedToSeeDoctype = false;
                    }
                    ready = true;
                    continue;
                }
                after.append(60);
                stillNeedToSeeDoctype = false;
                ready = true;
                continue;
            }
            after.append(current);
            stillNeedToSeeDoctype = false;
            ready = true;
        }
        while (stillNeedToSeeDoctype && (current = this.original.read()) != -1) {
            if (Character.isWhitespace((char)current)) {
                after.append(current);
                continue;
            }
            if (current == 60) {
                elementOrDeclOr = this.readUntilCloseCharIsReached();
                if (elementOrDeclOr.length > 0) {
                    if (elementOrDeclOr[0] == 63) {
                        after.append(60);
                        after.append(elementOrDeclOr);
                        continue;
                    }
                    if (elementOrDeclOr[0] != 33) {
                        after.append(60);
                        after.append(elementOrDeclOr);
                        stillNeedToSeeDoctype = false;
                        continue;
                    }
                    b = new IntegerBuffer(elementOrDeclOr.length);
                    b.append(elementOrDeclOr);
                    if (b.indexOf(DOCTYPE_INTS) == -1) {
                        after.append(60);
                        after.append(elementOrDeclOr);
                        continue;
                    }
                    stillNeedToSeeDoctype = false;
                    continue;
                }
                after.append(60);
                stillNeedToSeeDoctype = false;
                continue;
            }
            after.append(current);
            stillNeedToSeeDoctype = false;
        }
        this.beforeDoctype = before.size() > 0 ? new IntBufferReadable(before) : null;
        this.afterDoctype = after.size() > 0 ? new IntBufferReadable(after) : null;
    }

    private int[] readUntilCloseCharIsReached() throws IOException {
        IntegerBuffer i = new IntegerBuffer();
        int intRead = -1;
        int openCount = 1;
        while (openCount > 0 && (intRead = this.original.read()) != -1) {
            i.append(intRead);
            if (intRead == 60) {
                ++openCount;
            }
            if (intRead != 62) continue;
            --openCount;
        }
        return i.toIntArray();
    }

    private static class IntBufferReadable
    implements Readable {
        private final int[] buf;
        private int off;

        IntBufferReadable(IntegerBuffer b) {
            this.buf = b.toIntArray();
        }

        @Override
        public int read() {
            return this.off >= this.buf.length ? -1 : this.buf[this.off++];
        }
    }

    static interface Readable {
        public int read() throws IOException;
    }
}

