/*
 * Decompiled with CFR 0.152.
 */
package org.xmlunit.diff;

import java.util.Collections;
import java.util.Map;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;
import org.xmlunit.diff.Comparison;
import org.xmlunit.diff.ComparisonController;
import org.xmlunit.diff.ComparisonControllers;
import org.xmlunit.diff.ComparisonListener;
import org.xmlunit.diff.ComparisonListenerSupport;
import org.xmlunit.diff.ComparisonResult;
import org.xmlunit.diff.DefaultNodeMatcher;
import org.xmlunit.diff.Difference;
import org.xmlunit.diff.DifferenceEngine;
import org.xmlunit.diff.DifferenceEvaluator;
import org.xmlunit.diff.DifferenceEvaluators;
import org.xmlunit.diff.NodeFilters;
import org.xmlunit.diff.NodeMatcher;
import org.xmlunit.diff.XPathContext;
import org.xmlunit.util.Predicate;

public abstract class AbstractDifferenceEngine
implements DifferenceEngine {
    private final ComparisonListenerSupport listeners = new ComparisonListenerSupport();
    private NodeMatcher nodeMatcher = new DefaultNodeMatcher();
    private DifferenceEvaluator diffEvaluator = DifferenceEvaluators.Default;
    private ComparisonController comparisonController = ComparisonControllers.Default;
    private Map<String, String> prefix2uri = Collections.emptyMap();
    private Predicate<Attr> attributeFilter = new Predicate<Attr>(){

        @Override
        public boolean test(Attr a) {
            return true;
        }
    };
    private Predicate<Node> nodeFilter = NodeFilters.Default;

    protected AbstractDifferenceEngine() {
    }

    @Override
    public void addComparisonListener(ComparisonListener l) {
        if (l == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        this.listeners.addComparisonListener(l);
    }

    @Override
    public void addMatchListener(ComparisonListener l) {
        if (l == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        this.listeners.addMatchListener(l);
    }

    @Override
    public void addDifferenceListener(ComparisonListener l) {
        if (l == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        this.listeners.addDifferenceListener(l);
    }

    @Override
    public void setNodeMatcher(NodeMatcher n) {
        if (n == null) {
            throw new IllegalArgumentException("node matcher must not be null");
        }
        this.nodeMatcher = n;
    }

    protected NodeMatcher getNodeMatcher() {
        return this.nodeMatcher;
    }

    @Override
    public void setDifferenceEvaluator(DifferenceEvaluator e) {
        if (e == null) {
            throw new IllegalArgumentException("difference evaluator must not be null");
        }
        this.diffEvaluator = e;
    }

    protected DifferenceEvaluator getDifferenceEvaluator() {
        return this.diffEvaluator;
    }

    @Override
    public void setComparisonController(ComparisonController c) {
        if (c == null) {
            throw new IllegalArgumentException("comparison controller must not be null");
        }
        this.comparisonController = c;
    }

    protected ComparisonController getComparisonController() {
        return this.comparisonController;
    }

    @Override
    public void setNamespaceContext(Map<String, String> prefix2uri) {
        this.prefix2uri = Collections.unmodifiableMap(prefix2uri);
    }

    protected Map<String, String> getNamespaceContext() {
        return this.prefix2uri;
    }

    @Override
    public void setAttributeFilter(Predicate<Attr> af) {
        if (af == null) {
            throw new IllegalArgumentException("attribute filter must not be null");
        }
        this.attributeFilter = af;
    }

    protected Predicate<Attr> getAttributeFilter() {
        return this.attributeFilter;
    }

    @Override
    public void setNodeFilter(Predicate<Node> nf) {
        if (nf == null) {
            throw new IllegalArgumentException("node filter must not be null");
        }
        this.nodeFilter = nf;
    }

    protected Predicate<Node> getNodeFilter() {
        return this.nodeFilter;
    }

    protected final ComparisonState compare(Comparison comp) {
        Object controlValue = comp.getControlDetails().getValue();
        Object testValue = comp.getTestDetails().getValue();
        boolean equal = controlValue == null ? testValue == null : controlValue.equals(testValue);
        ComparisonResult initial = equal ? ComparisonResult.EQUAL : ComparisonResult.DIFFERENT;
        ComparisonResult altered = this.getDifferenceEvaluator().evaluate(comp, initial);
        this.listeners.fireComparisonPerformed(comp, altered);
        return altered != ComparisonResult.EQUAL && this.getComparisonController().stopDiffing(new Difference(comp, altered)) ? new FinishedComparisonState(altered) : new OngoingComparisonState(altered);
    }

    protected static String getXPath(XPathContext ctx) {
        return ctx == null ? null : ctx.getXPath();
    }

    protected static String getParentXPath(XPathContext ctx) {
        return ctx == null ? null : ctx.getParentXPath();
    }

    protected final class OngoingComparisonState
    extends ComparisonState {
        protected OngoingComparisonState(ComparisonResult result) {
            super(false, result);
        }

        protected OngoingComparisonState() {
            this(ComparisonResult.EQUAL);
        }
    }

    protected final class FinishedComparisonState
    extends ComparisonState {
        protected FinishedComparisonState(ComparisonResult result) {
            super(true, result);
        }
    }

    protected abstract class ComparisonState {
        private final boolean finished;
        private final ComparisonResult result;

        protected ComparisonState(boolean finished, ComparisonResult result) {
            this.finished = finished;
            this.result = result;
        }

        protected ComparisonState andThen(DeferredComparison newStateProducer) {
            return this.finished ? this : newStateProducer.apply();
        }

        protected ComparisonState andIfTrueThen(boolean predicate, DeferredComparison newStateProducer) {
            return predicate ? this.andThen(newStateProducer) : this;
        }

        protected ComparisonState andThen(final Comparison comp) {
            return this.andThen(new DeferredComparison(){

                @Override
                public ComparisonState apply() {
                    return AbstractDifferenceEngine.this.compare(comp);
                }
            });
        }

        protected ComparisonState andIfTrueThen(boolean predicate, final Comparison comp) {
            return this.andIfTrueThen(predicate, new DeferredComparison(){

                @Override
                public ComparisonState apply() {
                    return AbstractDifferenceEngine.this.compare(comp);
                }
            });
        }

        public String toString() {
            return this.getClass().getName() + ": current result is " + (Object)((Object)this.result);
        }

        public boolean equals(Object other) {
            if (other == null || !this.getClass().equals(other.getClass())) {
                return false;
            }
            ComparisonState cs = (ComparisonState)other;
            return this.finished == cs.finished && this.result == cs.result;
        }

        public int hashCode() {
            return (this.finished ? 7 : 1) * this.result.hashCode();
        }
    }

    protected static interface DeferredComparison {
        public ComparisonState apply();
    }
}

