/*
 * Decompiled with CFR 0.152.
 */
package org.xmlunit.assertj3;

import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import org.assertj.core.error.ErrorMessageFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;
import org.xmlunit.assertj3.AssertionsAdapter;
import org.xmlunit.assertj3.CustomAbstractAssert;
import org.xmlunit.assertj3.error.ShouldBeNotSimilar;
import org.xmlunit.assertj3.error.ShouldNotHaveThrown;
import org.xmlunit.builder.DiffBuilder;
import org.xmlunit.builder.DifferenceEngineConfigurer;
import org.xmlunit.diff.Comparison;
import org.xmlunit.diff.ComparisonController;
import org.xmlunit.diff.ComparisonControllers;
import org.xmlunit.diff.ComparisonFormatter;
import org.xmlunit.diff.ComparisonListener;
import org.xmlunit.diff.ComparisonType;
import org.xmlunit.diff.DefaultComparisonFormatter;
import org.xmlunit.diff.DefaultNodeMatcher;
import org.xmlunit.diff.Diff;
import org.xmlunit.diff.Difference;
import org.xmlunit.diff.DifferenceEvaluator;
import org.xmlunit.diff.DifferenceEvaluators;
import org.xmlunit.diff.ElementSelector;
import org.xmlunit.diff.ElementSelectors;
import org.xmlunit.diff.NodeMatcher;
import org.xmlunit.util.Predicate;

public class CompareAssert
extends CustomAbstractAssert<CompareAssert, Object>
implements DifferenceEngineConfigurer<CompareAssert> {
    private static final String EXPECTING_NOT_NULL = "Expecting control not to be null";
    private static DifferenceEvaluator IgnoreNodeListSequence = DifferenceEvaluators.downgradeDifferencesToEqual((ComparisonType[])new ComparisonType[]{ComparisonType.CHILD_NODELIST_SEQUENCE});
    private final DiffBuilder diffBuilder;
    private ComparisonController customComparisonController;
    private boolean formatXml;
    private ComparisonFormatter formatter = new DefaultComparisonFormatter();
    private static final String COMPARISON_FAILURE_PATTERN = "%nExpecting:%n <%s> and <%s> to be %s%n%s%nexpected:<%s> but was:<%s>>";

    private CompareAssert(Object actual, DiffBuilder diffBuilder) {
        super(actual, CompareAssert.class);
        this.diffBuilder = diffBuilder;
    }

    static CompareAssert create(Object actual, Object control, Map<String, String> prefix2Uri, DocumentBuilderFactory dbf) {
        AssertionsAdapter.assertThat(control).as(EXPECTING_NOT_NULL, new Object[0]).isNotNull();
        DiffBuilder diffBuilder = DiffBuilder.compare((Object)control).withTest(actual).withNamespaceContext(prefix2Uri).withDocumentBuilderFactory(dbf);
        return new CompareAssert(actual, diffBuilder);
    }

    public CompareAssert withNodeMatcher(NodeMatcher nodeMatcher) {
        this.diffBuilder.withNodeMatcher(nodeMatcher);
        return this;
    }

    public CompareAssert withDifferenceEvaluator(DifferenceEvaluator differenceEvaluator) {
        this.diffBuilder.withDifferenceEvaluator(differenceEvaluator);
        return this;
    }

    public CompareAssert withComparisonController(ComparisonController comparisonController) {
        this.customComparisonController = comparisonController;
        return this;
    }

    public CompareAssert withComparisonListeners(ComparisonListener ... comparisonListeners) {
        this.diffBuilder.withComparisonListeners(comparisonListeners);
        return this;
    }

    public CompareAssert withDifferenceListeners(ComparisonListener ... comparisonListeners) {
        this.diffBuilder.withDifferenceListeners(comparisonListeners);
        return this;
    }

    public CompareAssert withNamespaceContext(Map<String, String> prefix2Uri) {
        this.diffBuilder.withNamespaceContext(prefix2Uri);
        return this;
    }

    public CompareAssert withAttributeFilter(Predicate<Attr> attributeFilter) {
        this.diffBuilder.withAttributeFilter(attributeFilter);
        return this;
    }

    public CompareAssert withNodeFilter(Predicate<Node> nodeFilter) {
        this.diffBuilder.withNodeFilter(nodeFilter);
        return this;
    }

    public CompareAssert withComparisonFormatter(ComparisonFormatter formatter) {
        this.formatter = formatter;
        this.diffBuilder.withComparisonFormatter(formatter);
        return this;
    }

    public CompareAssert withDocumentBuilderFactory(DocumentBuilderFactory f) {
        this.diffBuilder.withDocumentBuilderFactory(f);
        return this;
    }

    public CompareAssert ignoreWhitespace() {
        this.formatXml = true;
        this.diffBuilder.ignoreWhitespace();
        return this;
    }

    public CompareAssert normalizeWhitespace() {
        this.formatXml = true;
        this.diffBuilder.normalizeWhitespace();
        return this;
    }

    public CompareAssert ignoreElementContentWhitespace() {
        this.diffBuilder.ignoreElementContentWhitespace();
        return this;
    }

    public CompareAssert ignoreComments() {
        this.diffBuilder.ignoreComments();
        return this;
    }

    public CompareAssert ignoreCommentsUsingXSLTVersion(String xsltVersion) {
        this.diffBuilder.ignoreCommentsUsingXSLTVersion(xsltVersion);
        return this;
    }

    public CompareAssert ignoreChildNodesOrder() {
        this.diffBuilder.withNodeMatcher((NodeMatcher)new DefaultNodeMatcher(new ElementSelector[]{ElementSelectors.byNameAndText}));
        this.diffBuilder.withDifferenceEvaluator(DifferenceEvaluators.chain((DifferenceEvaluator[])new DifferenceEvaluator[]{DifferenceEvaluators.Default, IgnoreNodeListSequence}));
        return this;
    }

    public CompareAssert areIdentical() {
        this.diffBuilder.checkForIdentical();
        this.compare(ComparisonContext.IDENTICAL);
        return this;
    }

    public CompareAssert areNotIdentical() {
        this.diffBuilder.checkForIdentical();
        this.compare(ComparisonContext.NOT_IDENTICAL);
        return this;
    }

    public CompareAssert areSimilar() {
        this.diffBuilder.checkForSimilar();
        this.compare(ComparisonContext.SIMILAR);
        return this;
    }

    public CompareAssert areNotSimilar() {
        this.diffBuilder.checkForSimilar();
        this.compare(ComparisonContext.NOT_SIMILAR);
        return this;
    }

    private void compare(ComparisonContext context) {
        Diff diff;
        if (this.customComparisonController != null) {
            this.diffBuilder.withComparisonController(this.customComparisonController);
        } else if (ComparisonContext.IDENTICAL == context || ComparisonContext.NOT_IDENTICAL == context) {
            this.diffBuilder.withComparisonController(ComparisonControllers.StopWhenSimilar);
        } else if (ComparisonContext.SIMILAR == context || ComparisonContext.NOT_SIMILAR == context) {
            this.diffBuilder.withComparisonController(ComparisonControllers.StopWhenDifferent);
        }
        try {
            diff = this.diffBuilder.build();
        }
        catch (Exception e) {
            this.throwAssertionError(ShouldNotHaveThrown.shouldNotHaveThrown(e));
            return;
        }
        String controlSystemId = diff.getControlSource().getSystemId();
        String testSystemId = diff.getTestSource().getSystemId();
        if (diff.hasDifferences()) {
            Comparison firstDifferenceComparison = ((Difference)diff.getDifferences().iterator().next()).getComparison();
            if (ComparisonContext.IDENTICAL == context) {
                this.failComparison("identical", controlSystemId, testSystemId, firstDifferenceComparison, this.formatter, this.formatXml);
            } else if (ComparisonContext.SIMILAR == context) {
                this.failComparison("similar", controlSystemId, testSystemId, firstDifferenceComparison, this.formatter, this.formatXml);
            }
        } else if (ComparisonContext.NOT_IDENTICAL == context) {
            this.throwAssertionError((ErrorMessageFactory)ShouldBeNotSimilar.shouldBeNotIdentical(controlSystemId, testSystemId));
        } else if (ComparisonContext.NOT_SIMILAR == context) {
            this.throwAssertionError((ErrorMessageFactory)ShouldBeNotSimilar.shouldBeNotSimilar(controlSystemId, testSystemId));
        }
    }

    private void failComparison(String type, String controlSystemId, String testSystemId, Comparison difference, ComparisonFormatter formatter, boolean formatXml) {
        String controlId = controlSystemId != null ? controlSystemId : "control instance";
        String testId = testSystemId != null ? testSystemId : "test instance";
        String description = formatter.getDescription(difference);
        String expected = formatter.getDetails(difference.getControlDetails(), difference.getType(), formatXml);
        String actual = formatter.getDetails(difference.getTestDetails(), difference.getType(), formatXml);
        String msg = String.format(COMPARISON_FAILURE_PATTERN, controlId, testId, type, description, expected, actual).replace("%", "%%");
        this.failWithActualExpectedAndMessage(expected, actual, msg, new Object[0]);
    }

    private static enum ComparisonContext {
        IDENTICAL,
        NOT_IDENTICAL,
        SIMILAR,
        NOT_SIMILAR;

    }
}

