/*
 * Decompiled with CFR 0.152.
 */
package org.xmlunit.assertj.error;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.assertj.core.description.Description;
import org.assertj.core.error.AssertionErrorFactory;
import org.assertj.core.internal.Failures;
import org.assertj.core.presentation.Representation;

abstract class ComparisonFailureErrorFactory
implements AssertionErrorFactory {
    private static Constructor<?> comparisonFailureConstructor;
    private static final String EXPECTED_BUT_WAS_MESSAGE = "%nExpecting:%n <%s>%nto be equal to:%n <%s>%nbut was not.";

    ComparisonFailureErrorFactory() {
    }

    abstract String getMessage();

    abstract String getExpected();

    abstract String getActual();

    public AssertionError newAssertionError(Description d, Representation representation) {
        AssertionError assertionError = this.getComparisonFailureInstance();
        if (assertionError != null) {
            return assertionError;
        }
        String message = String.format(EXPECTED_BUT_WAS_MESSAGE, this.getActual(), this.getExpected());
        return Failures.instance().failure(message);
    }

    private AssertionError getComparisonFailureInstance() {
        Constructor<?> constructor = ComparisonFailureErrorFactory.getComparisonFailureConstructor();
        if (constructor != null) {
            try {
                Object o = constructor.newInstance(this.getMessage(), this.getExpected(), this.getActual());
                if (o instanceof AssertionError) {
                    return (AssertionError)o;
                }
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException reflectiveOperationException) {
                // empty catch block
            }
        }
        return null;
    }

    private static Constructor<?> getComparisonFailureConstructor() {
        if (comparisonFailureConstructor == null) {
            try {
                Class<?> targetType = Class.forName("org.junit.ComparisonFailure");
                comparisonFailureConstructor = targetType.getConstructor(String.class, String.class, String.class);
            }
            catch (ClassNotFoundException | NoSuchMethodException reflectiveOperationException) {
                // empty catch block
            }
        }
        return comparisonFailureConstructor;
    }
}

