/*
 * Decompiled with CFR 0.152.
 */
package org.xmlunit.assertj;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.MethodDelegation;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import net.bytebuddy.utility.RandomString;
import org.assertj.core.api.Assert;
import org.assertj.core.api.AssertFactory;
import org.w3c.dom.Node;
import org.xmlunit.assertj.NodeAssertFactory;
import org.xmlunit.assertj.SingleNodeAssert;
import org.xmlunit.xpath.JAXPXPathEngine;

class AssertFactoryProvider {
    private static Class<? extends AssertFactory> assertFactoryClass;

    AssertFactoryProvider() {
    }

    AssertFactory<Node, SingleNodeAssert> create(JAXPXPathEngine engine) {
        if (this.hasAssertFactoryUpperBoundOnAssertType()) {
            return this.createProxyInstance(engine);
        }
        return this.createDefaultInstance(engine);
    }

    private boolean hasAssertFactoryUpperBoundOnAssertType() {
        Type assertType;
        Type[] bounds;
        TypeVariable<Class<T>>[] typeParameters = AssertFactory.class.getTypeParameters();
        if (typeParameters.length == 2 && (bounds = typeParameters[1].getBounds()).length == 1 && (assertType = bounds[0]) instanceof ParameterizedType) {
            ParameterizedType at = (ParameterizedType)assertType;
            return at.getRawType().equals(Assert.class);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AssertFactory<Node, SingleNodeAssert> createProxyInstance(JAXPXPathEngine engine) {
        try {
            Class<AssertFactoryProvider> clazz = AssertFactoryProvider.class;
            synchronized (AssertFactoryProvider.class) {
                if (assertFactoryClass == null) {
                    assertFactoryClass = new ByteBuddy().subclass(AssertFactory.class).name(NodeAssertFactoryDelegate.class.getPackage().getName() + ".XmlUnit$AssertFactory$" + RandomString.make()).method((ElementMatcher)ElementMatchers.named((String)"createAssert")).intercept((Implementation)MethodDelegation.to((Object)new NodeAssertFactoryDelegate(this.createDefaultInstance(engine)))).make().load(this.getClass().getClassLoader(), (ClassLoadingStrategy)ClassLoadingStrategy.Default.INJECTION).getLoaded();
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                AssertFactory instance = assertFactoryClass.newInstance();
                return instance;
            }
        }
        catch (IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
            return this.createDefaultInstance(engine);
        }
    }

    private NodeAssertFactory createDefaultInstance(JAXPXPathEngine engine) {
        return new NodeAssertFactory(engine);
    }

    static class NodeAssertFactoryDelegate {
        private final NodeAssertFactory delegate;

        private NodeAssertFactoryDelegate(NodeAssertFactory delegate) {
            this.delegate = delegate;
        }

        Assert delegate(Object obj) {
            return this.delegate.createAssert((Node)obj);
        }
    }
}

