/*
 * Decompiled with CFR 0.152.
 */
package org.xmlunit.assertj;

import javax.xml.transform.Source;
import javax.xml.validation.Schema;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractObjectArrayAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.error.ErrorMessageFactory;
import org.xmlunit.assertj.error.ShouldBeInvalid;
import org.xmlunit.assertj.error.ShouldBeValid;
import org.xmlunit.builder.Input;
import org.xmlunit.validation.JAXPValidator;
import org.xmlunit.validation.ValidationResult;

public class ValidationAssert
extends AbstractAssert<ValidationAssert, Source> {
    private final Source[] schemaSources;
    private final Schema schema;

    private ValidationAssert(Source actual, Source[] schemaSources, Schema schema) {
        super((Object)actual, ValidationAssert.class);
        this.schemaSources = schemaSources;
        this.schema = schema;
    }

    static ValidationAssert create(Object xmlSource, Object ... schemaSources) {
        Assertions.assertThat((Object)xmlSource).isNotNull();
        ((AbstractObjectArrayAssert)Assertions.assertThat((Object[])schemaSources).isNotNull()).doesNotContainNull();
        Source source = Input.from((Object)xmlSource).build();
        Source[] sources = new Source[schemaSources.length];
        for (int i = 0; i < schemaSources.length; ++i) {
            sources[i] = Input.from((Object)schemaSources[i]).build();
        }
        return new ValidationAssert(source, sources, null);
    }

    static ValidationAssert create(Object xmlSource, Schema schema) {
        Assertions.assertThat((Object)xmlSource).isNotNull();
        Assertions.assertThat((Object)schema).isNotNull();
        Source source = Input.from((Object)xmlSource).build();
        return new ValidationAssert(source, null, schema);
    }

    static ValidationAssert create(Object xmlSource) {
        Source source = Input.from((Object)xmlSource).build();
        return new ValidationAssert(source, null, null);
    }

    private ValidationResult validate() {
        JAXPValidator validator = new JAXPValidator("http://www.w3.org/2001/XMLSchema");
        if (this.schema != null) {
            validator.setSchema(this.schema);
        } else if (this.schemaSources != null && this.schemaSources.length > 0) {
            validator.setSchemaSources(this.schemaSources);
        }
        return validator.validateInstance((Source)this.actual);
    }

    public ValidationAssert isValid() {
        ValidationResult validationResult = this.validate();
        if (!validationResult.isValid()) {
            this.throwAssertionError((ErrorMessageFactory)ShouldBeValid.shouldBeValid(((Source)this.actual).getSystemId(), validationResult.getProblems()));
        }
        return this;
    }

    public void isInvalid() {
        ValidationResult validateResult = this.validate();
        if (validateResult.isValid()) {
            this.throwAssertionError((ErrorMessageFactory)ShouldBeInvalid.shouldBeInvalid(((Source)this.actual).getSystemId()));
        }
    }
}

