/*
 * Decompiled with CFR 0.152.
 */
package org.xmlunit.assertj;

import java.util.Map;
import javax.xml.namespace.QName;
import org.assertj.core.api.AbstractAssert;
import org.w3c.dom.Node;
import org.xmlunit.assertj.error.ShouldHaveAttribute;
import org.xmlunit.assertj.error.ShouldNotHaveAttribute;
import org.xmlunit.util.Nodes;

public class SingleNodeAssert
extends AbstractAssert<SingleNodeAssert, Node> {
    SingleNodeAssert(Node node) {
        super((Object)node, SingleNodeAssert.class);
    }

    public SingleNodeAssert hasAttribute(String attributeName) {
        this.isNotNull();
        Map.Entry<QName, String> entry = this.attributeForName(attributeName);
        if (entry == null) {
            this.throwAssertionError(ShouldHaveAttribute.shouldHaveAttribute(((Node)this.actual).getNodeName(), attributeName));
        }
        return this;
    }

    public SingleNodeAssert hasAttribute(String attributeName, String attributeValue) {
        this.isNotNull();
        Map.Entry<QName, String> attribute = this.attributeForName(attributeName);
        if (attribute == null || !attribute.getValue().equals(attributeValue)) {
            this.throwAssertionError(ShouldHaveAttribute.shouldHaveAttributeWithValue(((Node)this.actual).getNodeName(), attributeName, attributeValue));
        }
        return this;
    }

    public SingleNodeAssert doesNotHaveAttribute(String attributeName) {
        this.isNotNull();
        Map.Entry<QName, String> entry = this.attributeForName(attributeName);
        if (entry != null) {
            this.throwAssertionError(ShouldNotHaveAttribute.shouldNotHaveAttribute(((Node)this.actual).getNodeName(), attributeName));
        }
        return this;
    }

    public SingleNodeAssert doesNotHaveAttribute(String attributeName, String attributeValue) {
        this.isNotNull();
        Map.Entry<QName, String> attribute = this.attributeForName(attributeName);
        if (attribute != null && attribute.getValue().equals(attributeValue)) {
            this.throwAssertionError(ShouldNotHaveAttribute.shouldNotHaveAttributeWithValue(((Node)this.actual).getNodeName(), attributeName, attributeValue));
        }
        return this;
    }

    private Map.Entry<QName, String> attributeForName(String attributeName) {
        Map attributes = Nodes.getAttributes((Node)((Node)this.actual));
        for (Map.Entry<QName, String> entry : attributes.entrySet()) {
            QName qName = (QName)entry.getKey();
            if (!SingleNodeAssert.matchQName(qName, attributeName)) continue;
            return entry;
        }
        return null;
    }

    private static boolean matchQName(QName qName, String name) {
        return qName.toString().equals(name) || (qName.getPrefix() + ":" + qName.getLocalPart()).equals(name) || qName.getLocalPart().equals(name);
    }
}

