/*
 * Decompiled with CFR 0.152.
 */
package org.xmlbeam.util.intern;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.regex.Pattern;
import org.xmlbeam.exceptions.XBException;

public final class ReflectionHelper {
    private static final Method ISDEFAULT = ReflectionHelper.findMethodByName(Method.class, "isDefault");
    private static final Class<?> OPTIONAL_CLASS = ReflectionHelper.findClass("java.util.Optional");
    private static final Method OFNULLABLE = ReflectionHelper.findMethodByName(OPTIONAL_CLASS, "ofNullable");
    private static final Method GETPARAMETERS = ReflectionHelper.findMethodByName(Method.class, "getParameters");
    private static final int PUBLIC_STATIC_MODIFIER = 9;
    private static final Pattern VALID_FACTORY_METHOD_NAMES = Pattern.compile("valueOf|of|parse|getInstance");
    private static final Method STREAM = ReflectionHelper.findMethodByName(List.class, "stream");

    private static Class<?> findClass(String name) {
        try {
            return Class.forName(name, false, ReflectionHelper.class.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public static Set<Class<?>> findAllCommonSuperInterfaces(Class<?> a, Class<?> b) {
        HashSet seta = new HashSet(ReflectionHelper.findAllSuperInterfaces(a));
        HashSet setb = new HashSet(ReflectionHelper.findAllSuperInterfaces(b));
        seta.retainAll(setb);
        return seta;
    }

    public static Method findMethodByName(Class<?> clazz, String name) {
        if (clazz == null) {
            return null;
        }
        for (Method m : clazz.getMethods()) {
            if (!name.equals(m.getName())) continue;
            return m;
        }
        return null;
    }

    public static List<Class<?>> findAllSuperInterfaces(Class<?> a) {
        LinkedList list = new LinkedList();
        LinkedList queue = new LinkedList();
        queue.add(a);
        while (!queue.isEmpty()) {
            Class c = (Class)queue.poll();
            if (c.isInterface()) {
                list.addFirst(c);
            }
            queue.addAll(Arrays.asList(c.getInterfaces()));
        }
        return list;
    }

    public static boolean hasReturnType(Method method) {
        if (method == null) {
            return false;
        }
        if (method.getReturnType() == null) {
            return false;
        }
        if (Void.class.equals(method.getReturnType())) {
            return false;
        }
        return !Void.TYPE.equals(method.getReturnType());
    }

    public static boolean hasParameters(Method method) {
        return method != null && method.getParameterTypes().length > 0;
    }

    public static List<Object> array2ObjectList(Object array) {
        int length = Array.getLength(array);
        ArrayList<Object> list = new ArrayList<Object>(length);
        for (int i = 0; i < length; ++i) {
            list.add(Array.get(array, i));
        }
        return list;
    }

    public static boolean isDefaultMethod(Method m) {
        try {
            return ISDEFAULT != null && (Boolean)ISDEFAULT.invoke((Object)m, (Object[])null) != false;
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static Map<String, Integer> getMethodParameterIndexes(Method m) {
        if (GETPARAMETERS == null || m == null) {
            return Collections.emptyMap();
        }
        HashMap<String, Integer> paramNames = new HashMap<String, Integer>();
        try {
            Object[] params = (Object[])GETPARAMETERS.invoke((Object)m, new Object[0]);
            if (params.length == 0) {
                return Collections.emptyMap();
            }
            Method getName = ReflectionHelper.findMethodByName(params[0].getClass(), "getName");
            if (getName == null) {
                return Collections.emptyMap();
            }
            int i = -1;
            for (Object o : params) {
                ++i;
                String name = (String)getName.invoke(o, new Object[0]);
                if (name == null) continue;
                paramNames.put(name.toUpperCase(Locale.ENGLISH), i);
            }
            return Collections.unmodifiableMap(paramNames);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> Constructor<T> getCallableConstructorForParams(Class<T> type, Class<?> ... params) {
        for (Constructor<?> c : type.getConstructors()) {
            Object[] parameterTypes = c.getParameterTypes();
            if (!Arrays.equals(parameterTypes, params)) continue;
            return c;
        }
        return null;
    }

    public static Method getCallableFactoryForParams(Class<?> type, Class<?> ... params) {
        for (Method m : type.getMethods()) {
            if ((m.getModifiers() & 9) != 9 || !type.isAssignableFrom(m.getReturnType()) || !Arrays.equals(m.getParameterTypes(), params) || !VALID_FACTORY_METHOD_NAMES.matcher(m.getName()).matches()) continue;
            return m;
        }
        return null;
    }

    public static boolean mayProvideParameterNames() {
        return GETPARAMETERS != null;
    }

    public static Object unwrap(Class<?> type, Object object) throws Exception {
        if (object == null) {
            return null;
        }
        if (type == null) {
            return object;
        }
        if (Callable.class.equals(type)) {
            assert (object instanceof Callable);
            return ((Callable)object).call();
        }
        if ("java.util.function.Supplier".equals(type.getName())) {
            return ReflectionHelper.findMethodByName(type, "get").invoke(object, (Object[])null);
        }
        return object;
    }

    public static Class<?> getParameterType(Type type) {
        assert (type instanceof ParameterizedType);
        Type rawType = ((ParameterizedType)type).getRawType();
        if (Map.class.equals((Object)rawType)) {
            if (!((ParameterizedType)type).getActualTypeArguments()[0].equals(String.class)) {
                throw new XBException((CharSequence)"If Map is used as return type, String must be used as key type.");
            }
            return (Class)((ParameterizedType)type).getActualTypeArguments()[1];
        }
        assert (((ParameterizedType)type).getActualTypeArguments().length == 1);
        return (Class)((ParameterizedType)type).getActualTypeArguments()[0];
    }

    public static boolean isOptional(Type type) {
        if (OPTIONAL_CLASS == null) {
            return false;
        }
        if (!(type instanceof ParameterizedType)) {
            return false;
        }
        return OPTIONAL_CLASS.equals(((ParameterizedType)type).getRawType());
    }

    public static boolean isRawType(Type type) {
        if (type instanceof Class) {
            Class clazz = (Class)type;
            return clazz.getTypeParameters().length > 0;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType ptype = (ParameterizedType)type;
            return ptype.getActualTypeArguments().length == 0;
        }
        return false;
    }

    public static Object createOptional(Object value) {
        if (OPTIONAL_CLASS == null || OFNULLABLE == null) {
            throw new IllegalStateException("Unreachable Code executed. You just found a bug. Please report!");
        }
        try {
            return OFNULLABLE.invoke(null, value);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static Object invokeDefaultMethod(Method method, Object[] args, Object proxy) throws Throwable {
        try {
            Class<?> MHclass = Class.forName("java.lang.invoke.MethodHandles");
            Object lookup = MHclass.getMethod("lookup", null).invoke(null, (Object[])null);
            Constructor<?> constructor = lookup.getClass().getDeclaredConstructor(Class.class);
            constructor.setAccessible(true);
            Object newLookupInstance = constructor.newInstance(method.getDeclaringClass());
            Object in = newLookupInstance.getClass().getMethod("in", Class.class).invoke(newLookupInstance, method.getDeclaringClass());
            Object unreflectSpecial = in.getClass().getMethod("unreflectSpecial", Method.class, Class.class).invoke(in, method, method.getDeclaringClass());
            Object bindTo = unreflectSpecial.getClass().getMethod("bindTo", Object.class).invoke(unreflectSpecial, proxy);
            try {
                Object result = bindTo.getClass().getMethod("invokeWithArguments", Object[].class).invoke(bindTo, new Object[]{args});
                return result;
            }
            catch (InvocationTargetException e) {
                if (e.getCause() != null) {
                    throw e.getCause();
                }
                throw e;
            }
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    public static void throwThrowable(Class<?> throwableType, Object[] args, Throwable optionalCause) throws Throwable {
        Class<?>[] argsClasses = ReflectionHelper.getClassesOfObjects(args);
        Constructor<?> constructor = ReflectionHelper.getCallableConstructorForParams(throwableType, argsClasses);
        Throwable throwable = null;
        throwable = constructor != null ? (Throwable)constructor.newInstance(args) : (Throwable)throwableType.newInstance();
        if (optionalCause != null) {
            throwable.initCause(optionalCause);
        }
        throw throwable;
    }

    private static Class<?>[] getClassesOfObjects(Object ... objects) {
        Class[] classes = new Class[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            classes[i] = objects[i].getClass();
        }
        return classes;
    }

    public static Class<?> getCallerClass(int level) {
        return ((ClassContextAccess)ClassContextAccess.classContextAccess.get()).getCallerClass(level + 1);
    }

    public static Class<?> getDirectCallerClass() {
        return ((ClassContextAccess)ClassContextAccess.classContextAccess.get()).getCallerClass(3);
    }

    public static boolean isStreamClass(Class<?> returnType) {
        return "java.util.stream.Stream".equals(returnType.getName());
    }

    public static Object toStream(List<?> result) {
        if (STREAM == null) {
            throw new IllegalArgumentException("Can not invoke List.stream, you need at least a JDK8 to run this");
        }
        try {
            return STREAM.invoke(result, new Object[0]);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private static class ClassContextAccess
    extends SecurityManager {
        private static final ThreadLocal<ClassContextAccess> classContextAccess = new ThreadLocal<ClassContextAccess>(){

            @Override
            protected ClassContextAccess initialValue() {
                return new ClassContextAccess();
            }
        };

        private ClassContextAccess() {
        }

        public Class<?> getCallerClass(int level) {
            return this.getClassContext()[level];
        }
    }
}

