/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.http.servlet;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public class ServletURI {
    private String path;
    private String fragement;
    private String query;
    private Map<String, String> parameters;

    public ServletURI(String rawPath) throws URISyntaxException {
        if (rawPath == null || rawPath.isEmpty() || "/".equals(rawPath)) {
            this.path = "/";
        } else {
            URI uri = new URI(rawPath);
            this.path = uri.getPath();
            if (this.path == null || this.path.isEmpty()) {
                this.path = "/";
            } else if (this.path.charAt(0) != '/') {
                this.path = this.path + "/" + this.path;
            }
            this.fragement = uri.getFragment();
            this.query = uri.getQuery();
        }
    }

    public void setPath(String path) {
        this.path = path == null || path.isEmpty() ? "/" : path;
    }

    public String path() {
        return this.path;
    }

    public String query() {
        return this.query;
    }

    public String fragement() {
        return this.fragement;
    }

    public String parameter(String name) {
        if (this.query == null) {
            return null;
        }
        if (this.parameters != null) {
            return this.parameters.get(name);
        }
        this.parameters = new HashMap<String, String>();
        StringTokenizer st = new StringTokenizer(this.query, "&");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            int idx = token.indexOf(61);
            if (idx == -1 || idx == token.length()) continue;
            String pn = token.substring(0, idx);
            String pv = token.substring(idx + 1);
            this.parameters.put(pn, pv);
        }
        return this.parameters.get(name);
    }
}

