/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.pkcs12;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import javax.crypto.SecretKey;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.params.KeyParameter;
import org.xipki.common.util.ParamUtil;
import org.xipki.security.HashAlgoType;
import org.xipki.security.bc.XiContentSigner;
import org.xipki.security.exception.XiSecurityException;
import org.xipki.security.util.AlgorithmUtil;

public class HmacContentSigner
implements XiContentSigner {
    private final AlgorithmIdentifier algorithmIdentifier;
    private final byte[] encodedAlgorithmIdentifier;
    private final HmacOutputStream outputStream;
    private final HMac hmac;
    private final int outLen;

    public HmacContentSigner(AlgorithmIdentifier algorithmIdentifier, SecretKey signingKey) throws XiSecurityException {
        this(null, algorithmIdentifier, signingKey);
    }

    public HmacContentSigner(HashAlgoType hashAlgo, AlgorithmIdentifier algorithmIdentifier, SecretKey signingKey) throws XiSecurityException {
        this.algorithmIdentifier = (AlgorithmIdentifier)ParamUtil.requireNonNull((String)"algorithmIdentifier", (Object)algorithmIdentifier);
        try {
            this.encodedAlgorithmIdentifier = algorithmIdentifier.getEncoded();
        }
        catch (IOException ex) {
            throw new XiSecurityException("could not encode AlgorithmIdentifier", ex);
        }
        ParamUtil.requireNonNull((String)"signingKey", (Object)signingKey);
        if (hashAlgo == null) {
            hashAlgo = AlgorithmUtil.extractHashAlgoFromMacAlg(algorithmIdentifier);
        }
        this.hmac = new HMac(hashAlgo.createDigest());
        byte[] keyBytes = signingKey.getEncoded();
        this.hmac.init((CipherParameters)new KeyParameter(keyBytes, 0, keyBytes.length));
        this.outLen = this.hmac.getMacSize();
        this.outputStream = new HmacOutputStream();
    }

    public AlgorithmIdentifier getAlgorithmIdentifier() {
        return this.algorithmIdentifier;
    }

    @Override
    public byte[] getEncodedAlgorithmIdentifier() {
        return Arrays.copyOf(this.encodedAlgorithmIdentifier, this.encodedAlgorithmIdentifier.length);
    }

    public OutputStream getOutputStream() {
        this.hmac.reset();
        return this.outputStream;
    }

    public byte[] getSignature() {
        byte[] signature = new byte[this.outLen];
        this.hmac.doFinal(signature, 0);
        return signature;
    }

    private class HmacOutputStream
    extends OutputStream {
        private HmacOutputStream() {
        }

        @Override
        public void write(int bb) throws IOException {
            HmacContentSigner.this.hmac.update((byte)bb);
        }

        @Override
        public void write(byte[] bytes) throws IOException {
            HmacContentSigner.this.hmac.update(bytes, 0, bytes.length);
        }

        @Override
        public void write(byte[] bytes, int off, int len) throws IOException {
            HmacContentSigner.this.hmac.update(bytes, off, len);
        }
    }
}

