/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.pkcs12;

import java.io.IOException;
import java.io.OutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.GCMParameterSpec;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.cms.GCMParameters;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.util.Arrays;
import org.xipki.common.util.IoUtil;
import org.xipki.common.util.ParamUtil;
import org.xipki.security.bc.XiContentSigner;
import org.xipki.security.exception.XiSecurityException;

public class AESGmacContentSigner
implements XiContentSigner {
    private static final int tagByteLen = 16;
    private static final int nonceLen = 12;
    private final byte[] nonce = new byte[12];
    private final SecureRandom random;
    private final ASN1ObjectIdentifier oid;
    private final Cipher cipher;
    private final SecretKey signingKey;
    private final OutputStream outputStream;
    private final byte[] sigAlgIdTemplate;
    private final int nonceOffset;

    public AESGmacContentSigner(ASN1ObjectIdentifier oid, SecretKey signingKey) throws XiSecurityException {
        Cipher cipher0;
        this.oid = (ASN1ObjectIdentifier)ParamUtil.requireNonNull((String)"oid", (Object)oid);
        this.signingKey = (SecretKey)ParamUtil.requireNonNull((String)"signingKey", (Object)signingKey);
        try {
            cipher0 = Cipher.getInstance("AES/GCM/NoPadding", "SunJCE");
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException | NoSuchPaddingException ex) {
            try {
                cipher0 = Cipher.getInstance("AES/GCM/NoPadding");
            }
            catch (NoSuchAlgorithmException | NoSuchPaddingException ex2) {
                throw new XiSecurityException(ex2);
            }
        }
        this.cipher = cipher0;
        this.random = new SecureRandom();
        this.outputStream = new AESGmacOutputStream();
        GCMParameters params = new GCMParameters(this.nonce, 16);
        try {
            this.sigAlgIdTemplate = new AlgorithmIdentifier(oid, (ASN1Encodable)params).getEncoded();
        }
        catch (IOException ex) {
            throw new XiSecurityException("could not encode AlgorithmIdentifier", ex);
        }
        this.nonceOffset = IoUtil.getIndex((byte[])this.sigAlgIdTemplate, (byte[])this.nonce);
        int keyLen = signingKey.getEncoded().length;
        if (keyLen == 16) {
            if (!oid.equals((Object)NISTObjectIdentifiers.id_aes128_GCM)) {
                throw new XiSecurityException("oid and singingKey do not match");
            }
        } else if (keyLen == 24) {
            if (!oid.equals((Object)NISTObjectIdentifiers.id_aes192_GCM)) {
                throw new XiSecurityException("oid and singingKey do not match");
            }
        } else if (keyLen == 32) {
            if (!oid.equals((Object)NISTObjectIdentifiers.id_aes256_GCM)) {
                throw new XiSecurityException("oid and singingKey do not match");
            }
        } else {
            throw new XiSecurityException("invalid AES key length: " + keyLen);
        }
        try {
            this.cipher.init(1, (Key)signingKey, new GCMParameterSpec(128, this.nonce));
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException ex) {
            throw new XiSecurityException(ex);
        }
    }

    public AlgorithmIdentifier getAlgorithmIdentifier() {
        GCMParameters params = new GCMParameters(this.nonce, 16);
        return new AlgorithmIdentifier(this.oid, (ASN1Encodable)params);
    }

    @Override
    public byte[] getEncodedAlgorithmIdentifier() {
        byte[] bytes = Arrays.copyOf((byte[])this.sigAlgIdTemplate, (int)this.sigAlgIdTemplate.length);
        System.arraycopy(this.nonce, 0, bytes, this.nonceOffset, 12);
        return bytes;
    }

    public OutputStream getOutputStream() {
        this.random.nextBytes(this.nonce);
        try {
            this.cipher.init(1, (Key)this.signingKey, new GCMParameterSpec(128, this.nonce));
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException ex) {
            throw new IllegalStateException(ex);
        }
        return this.outputStream;
    }

    public byte[] getSignature() {
        try {
            return this.cipher.doFinal();
        }
        catch (IllegalBlockSizeException ex) {
            throw new IllegalStateException("IllegalBlockSizeException: " + ex.getMessage());
        }
        catch (BadPaddingException ex) {
            throw new IllegalStateException("BadPaddingException: " + ex.getMessage());
        }
    }

    private class AESGmacOutputStream
    extends OutputStream {
        private AESGmacOutputStream() {
        }

        @Override
        public void write(int bb) throws IOException {
            AESGmacContentSigner.this.cipher.updateAAD(new byte[]{(byte)bb});
        }

        @Override
        public void write(byte[] bytes) throws IOException {
            AESGmacContentSigner.this.cipher.updateAAD(bytes);
        }

        @Override
        public void write(byte[] bytes, int off, int len) throws IOException {
            AESGmacContentSigner.this.cipher.updateAAD(bytes, off, len);
        }
    }
}

