/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.pkcs11.proxy.msg;

import java.io.IOException;
import java.math.BigInteger;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.bouncycastle.asn1.ASN1Boolean;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERSequence;
import org.xipki.common.util.ParamUtil;
import org.xipki.security.exception.BadAsn1ObjectException;
import org.xipki.security.pkcs11.proxy.msg.Asn1Util;

public class Asn1ServerCaps
extends ASN1Object {
    private final Set<Short> versions;
    private final boolean readOnly;

    public Asn1ServerCaps(boolean readOnly, Set<Short> versions) {
        this.readOnly = readOnly;
        this.versions = Collections.unmodifiableSet(ParamUtil.requireNonEmpty((String)"versions", versions));
    }

    private Asn1ServerCaps(ASN1Sequence seq) throws BadAsn1ObjectException {
        ASN1Sequence vecVersions;
        Asn1Util.requireRange(seq, 2, 2);
        try {
            this.readOnly = ASN1Boolean.getInstance((Object)seq.getObjectAt(0)).isTrue();
        }
        catch (IllegalArgumentException ex) {
            throw new BadAsn1ObjectException("invalid readOnly: " + ex.getMessage(), ex);
        }
        try {
            vecVersions = ASN1Sequence.getInstance((Object)seq.getObjectAt(1));
        }
        catch (IllegalArgumentException ex) {
            throw new BadAsn1ObjectException("invalid versions: " + ex.getMessage(), ex);
        }
        int count = vecVersions.size();
        HashSet<Short> tmpVersions = new HashSet<Short>(count * 2);
        for (int i = 0; i < count; ++i) {
            ASN1Integer asn1Int;
            try {
                asn1Int = ASN1Integer.getInstance((Object)vecVersions.getObjectAt(i));
            }
            catch (IllegalArgumentException ex) {
                throw new BadAsn1ObjectException("invalid version: " + ex.getMessage(), ex);
            }
            tmpVersions.add(asn1Int.getValue().shortValue());
        }
        this.versions = Collections.unmodifiableSet(tmpVersions);
    }

    public static Asn1ServerCaps getInstance(Object obj) throws BadAsn1ObjectException {
        if (obj == null || obj instanceof Asn1ServerCaps) {
            return (Asn1ServerCaps)((Object)obj);
        }
        try {
            if (obj instanceof ASN1Sequence) {
                return new Asn1ServerCaps((ASN1Sequence)obj);
            }
            if (obj instanceof byte[]) {
                return Asn1ServerCaps.getInstance(ASN1Primitive.fromByteArray((byte[])((byte[])obj)));
            }
            throw new BadAsn1ObjectException("unknown object: " + obj.getClass().getName());
        }
        catch (IOException | IllegalArgumentException ex) {
            throw new BadAsn1ObjectException("unable to parse encoded object: " + ex.getMessage(), ex);
        }
    }

    public Set<Short> versions() {
        return this.versions;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector vecVersions = new ASN1EncodableVector();
        for (Short version : this.versions) {
            vecVersions.add((ASN1Encodable)new ASN1Integer(BigInteger.valueOf(version.shortValue())));
        }
        ASN1EncodableVector vec = new ASN1EncodableVector();
        vec.add((ASN1Encodable)ASN1Boolean.getInstance((boolean)this.readOnly));
        vec.add((ASN1Encodable)new DERSequence(vecVersions));
        return new DERSequence(vec);
    }
}

