/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.pkcs11.proxy.msg;

import java.io.IOException;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERSequence;
import org.xipki.common.util.ParamUtil;
import org.xipki.security.exception.BadAsn1ObjectException;
import org.xipki.security.pkcs11.P11SlotIdentifier;
import org.xipki.security.pkcs11.proxy.msg.Asn1Util;

public class Asn1P11SlotIdentifier
extends ASN1Object {
    private final P11SlotIdentifier slotId;

    public Asn1P11SlotIdentifier(P11SlotIdentifier slotId) {
        this.slotId = (P11SlotIdentifier)ParamUtil.requireNonNull((String)"slotId", (Object)slotId);
    }

    private Asn1P11SlotIdentifier(ASN1Sequence seq) throws BadAsn1ObjectException {
        Asn1Util.requireRange(seq, 2, 2);
        int idx = 0;
        long id = Asn1Util.getInteger(seq.getObjectAt(idx++)).longValue();
        int index = Asn1Util.getInteger(seq.getObjectAt(idx++)).intValue();
        this.slotId = new P11SlotIdentifier(index, id);
    }

    public static Asn1P11SlotIdentifier getInstance(Object obj) throws BadAsn1ObjectException {
        if (obj == null || obj instanceof Asn1P11SlotIdentifier) {
            return (Asn1P11SlotIdentifier)((Object)obj);
        }
        try {
            if (obj instanceof ASN1Sequence) {
                return new Asn1P11SlotIdentifier((ASN1Sequence)obj);
            }
            if (obj instanceof byte[]) {
                return Asn1P11SlotIdentifier.getInstance(ASN1Primitive.fromByteArray((byte[])((byte[])obj)));
            }
            throw new BadAsn1ObjectException("unknown object: " + obj.getClass().getName());
        }
        catch (IOException | IllegalArgumentException ex) {
            throw new BadAsn1ObjectException("unable to parse encoded object: " + ex.getMessage(), ex);
        }
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector vector = new ASN1EncodableVector();
        vector.add((ASN1Encodable)new ASN1Integer(this.slotId.id()));
        vector.add((ASN1Encodable)new ASN1Integer((long)this.slotId.index()));
        return new DERSequence(vector);
    }

    public P11SlotIdentifier slotId() {
        return this.slotId;
    }
}

