/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.pkcs11.proxy.msg;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERSequence;
import org.xipki.common.util.ParamUtil;
import org.xipki.security.exception.BadAsn1ObjectException;
import org.xipki.security.pkcs11.proxy.msg.Asn1P11ObjectIdentifier;

public class Asn1P11ObjectIdentifiers
extends ASN1Object {
    private final List<Asn1P11ObjectIdentifier> objectIds;

    public Asn1P11ObjectIdentifiers(List<Asn1P11ObjectIdentifier> objectIds) {
        this.objectIds = (List)ParamUtil.requireNonNull((String)"objectIds", objectIds);
    }

    private Asn1P11ObjectIdentifiers(ASN1Sequence seq) throws BadAsn1ObjectException {
        this.objectIds = new LinkedList<Asn1P11ObjectIdentifier>();
        int size = seq.size();
        for (int i = 0; i < size; ++i) {
            this.objectIds.add(Asn1P11ObjectIdentifier.getInstance(seq.getObjectAt(i)));
        }
    }

    public static Asn1P11ObjectIdentifiers getInstance(Object obj) throws BadAsn1ObjectException {
        if (obj == null || obj instanceof Asn1P11ObjectIdentifiers) {
            return (Asn1P11ObjectIdentifiers)((Object)obj);
        }
        try {
            if (obj instanceof ASN1Sequence) {
                return new Asn1P11ObjectIdentifiers((ASN1Sequence)obj);
            }
            if (obj instanceof byte[]) {
                return Asn1P11ObjectIdentifiers.getInstance(ASN1Primitive.fromByteArray((byte[])((byte[])obj)));
            }
            throw new BadAsn1ObjectException("unknown object: " + obj.getClass().getName());
        }
        catch (IOException | IllegalArgumentException ex) {
            throw new BadAsn1ObjectException("unable to parse encoded object: " + ex.getMessage(), ex);
        }
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector vec = new ASN1EncodableVector();
        for (Asn1P11ObjectIdentifier objectId : this.objectIds) {
            vec.add((ASN1Encodable)objectId);
        }
        return new DERSequence(vec);
    }

    public List<Asn1P11ObjectIdentifier> objectIds() {
        return this.objectIds;
    }
}

