/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.pkcs11.proxy.msg;

import java.io.IOException;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERUTF8String;
import org.xipki.common.util.ParamUtil;
import org.xipki.security.exception.BadAsn1ObjectException;
import org.xipki.security.pkcs11.P11ObjectIdentifier;
import org.xipki.security.pkcs11.proxy.msg.Asn1Util;

public class Asn1P11ObjectIdentifier
extends ASN1Object {
    private final P11ObjectIdentifier objectId;

    public Asn1P11ObjectIdentifier(P11ObjectIdentifier objectId) {
        this.objectId = (P11ObjectIdentifier)ParamUtil.requireNonNull((String)"objectId", (Object)objectId);
    }

    private Asn1P11ObjectIdentifier(ASN1Sequence seq) throws BadAsn1ObjectException {
        Asn1Util.requireRange(seq, 2, 2);
        int idx = 0;
        byte[] id = Asn1Util.getOctetStringBytes(seq.getObjectAt(idx++));
        String label = Asn1Util.getUtf8String(seq.getObjectAt(idx++));
        this.objectId = new P11ObjectIdentifier(id, label);
    }

    public static Asn1P11ObjectIdentifier getInstance(Object obj) throws BadAsn1ObjectException {
        if (obj == null || obj instanceof Asn1P11ObjectIdentifier) {
            return (Asn1P11ObjectIdentifier)((Object)obj);
        }
        try {
            if (obj instanceof ASN1Sequence) {
                return new Asn1P11ObjectIdentifier((ASN1Sequence)obj);
            }
            if (obj instanceof byte[]) {
                return Asn1P11ObjectIdentifier.getInstance(ASN1Primitive.fromByteArray((byte[])((byte[])obj)));
            }
            throw new BadAsn1ObjectException("unknown object: " + obj.getClass().getName());
        }
        catch (IOException | IllegalArgumentException ex) {
            throw new BadAsn1ObjectException("unable to parse encoded object: " + ex.getMessage(), ex);
        }
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector vec = new ASN1EncodableVector();
        vec.add((ASN1Encodable)new DEROctetString(this.objectId.id()));
        vec.add((ASN1Encodable)new DERUTF8String(this.objectId.label()));
        return new DERSequence(vec);
    }

    public P11ObjectIdentifier objectId() {
        return this.objectId;
    }
}

