/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.pkcs11.proxy;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.Random;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Sequence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.common.ConfPairs;
import org.xipki.common.util.IoUtil;
import org.xipki.common.util.LogUtil;
import org.xipki.common.util.ParamUtil;
import org.xipki.common.util.StringUtil;
import org.xipki.security.exception.BadAsn1ObjectException;
import org.xipki.security.exception.P11TokenException;
import org.xipki.security.pkcs11.AbstractP11Module;
import org.xipki.security.pkcs11.P11Module;
import org.xipki.security.pkcs11.P11ModuleConf;
import org.xipki.security.pkcs11.P11Slot;
import org.xipki.security.pkcs11.P11SlotIdentifier;
import org.xipki.security.pkcs11.proxy.P11ProxyConstants;
import org.xipki.security.pkcs11.proxy.ProxyP11Slot;
import org.xipki.security.pkcs11.proxy.msg.Asn1P11SlotIdentifier;
import org.xipki.security.pkcs11.proxy.msg.Asn1ServerCaps;

public class ProxyP11Module
extends AbstractP11Module {
    public static final String PREFIX = "proxy:";
    private static final Logger LOG = LoggerFactory.getLogger(ProxyP11Module.class);
    private static final String REQUEST_MIMETYPE = "application/x-xipki-pkcs11";
    private static final String RESPONSE_MIMETYPE = "application/x-xipki-pkcs11";
    private final Random random = new Random();
    private final short version = (short)256;
    private URL serverUrl;
    private short moduleId;
    private boolean readOnly;

    private ProxyP11Module(P11ModuleConf moduleConf) throws P11TokenException {
        super(moduleConf);
        String modulePath = moduleConf.nativeLibrary();
        if (!StringUtil.startsWithIgnoreCase((String)modulePath, (String)PREFIX)) {
            throw new IllegalArgumentException("the module path does not starts with proxy:: " + modulePath);
        }
        ConfPairs confPairs = new ConfPairs(modulePath.substring(PREFIX.length()));
        String urlStr = confPairs.value("url");
        try {
            this.serverUrl = new URL(urlStr);
        }
        catch (MalformedURLException ex) {
            throw new IllegalArgumentException("invalid url: " + urlStr);
        }
        String moduleStr = confPairs.value("module");
        if (moduleStr == null) {
            throw new IllegalArgumentException("module not specified");
        }
        try {
            moduleStr = moduleStr.trim();
            this.moduleId = moduleStr.startsWith("0x") || moduleStr.startsWith("0X") ? Short.parseShort(moduleStr.substring(2), 16) : Short.parseShort(moduleStr.trim());
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException("invalid module: " + moduleStr);
        }
        this.refresh();
    }

    public static P11Module getInstance(P11ModuleConf moduleConf) throws P11TokenException {
        ParamUtil.requireNonNull((String)"moduleConf", (Object)moduleConf);
        return new ProxyP11Module(moduleConf);
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly || super.isReadOnly();
    }

    public void refresh() throws P11TokenException {
        ASN1Sequence seq;
        Asn1ServerCaps caps;
        byte[] resp = this.send((short)1, null);
        try {
            caps = Asn1ServerCaps.getInstance(resp);
        }
        catch (BadAsn1ObjectException ex) {
            throw new P11TokenException("response is a valid Asn1ServerCaps", ex);
        }
        if (!caps.versions().contains((short)256)) {
            throw new P11TokenException("Server does not support any version supported by the client");
        }
        this.readOnly = caps.isReadOnly();
        resp = this.send((short)259, null);
        try {
            seq = ASN1Sequence.getInstance((Object)resp);
        }
        catch (IllegalArgumentException ex) {
            throw new P11TokenException("response is not ASN1Sequence", ex);
        }
        int n = seq.size();
        HashSet<P11Slot> slots = new HashSet<P11Slot>();
        for (int i = 0; i < n; ++i) {
            Asn1P11SlotIdentifier asn1SlotId;
            try {
                ASN1Encodable obj = seq.getObjectAt(i);
                asn1SlotId = Asn1P11SlotIdentifier.getInstance(obj);
            }
            catch (Exception ex) {
                throw new P11TokenException(ex.getMessage(), ex);
            }
            P11SlotIdentifier slotId = asn1SlotId.slotId();
            if (!this.conf.isSlotIncluded(slotId)) continue;
            if (!this.conf.isSlotIncluded(slotId)) {
                LOG.info("skipped slot {}", (Object)slotId);
                continue;
            }
            ProxyP11Slot slot = new ProxyP11Slot(this, slotId, this.conf.isReadOnly(), this.conf.p11MechanismFilter());
            slots.add(slot);
        }
        this.setSlots(slots);
    }

    @Override
    public void close() {
        for (P11SlotIdentifier slotId : this.slotIdentifiers()) {
            try {
                this.getSlot(slotId).close();
            }
            catch (Throwable th) {
                LogUtil.error((Logger)LOG, (Throwable)th, (String)("could not close PKCS#11 slot " + slotId));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] send(byte[] request) throws IOException {
        ParamUtil.requireNonNull((String)"request", (Object)request);
        HttpURLConnection httpUrlConnection = IoUtil.openHttpConn((URL)this.serverUrl);
        httpUrlConnection.setDoOutput(true);
        httpUrlConnection.setUseCaches(false);
        int size = request.length;
        httpUrlConnection.setRequestMethod("POST");
        httpUrlConnection.setRequestProperty("Content-Type", "application/x-xipki-pkcs11");
        httpUrlConnection.setRequestProperty("Content-Length", Integer.toString(size));
        OutputStream outputstream = httpUrlConnection.getOutputStream();
        outputstream.write(request);
        outputstream.flush();
        if (httpUrlConnection.getResponseCode() != 200) {
            try {
                try {
                    InputStream is = httpUrlConnection.getInputStream();
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException ex) {
                    InputStream errStream = httpUrlConnection.getErrorStream();
                    if (errStream != null) {
                        errStream.close();
                    }
                }
            }
            catch (Throwable ex) {
                // empty catch block
            }
            throw new IOException("bad response: code=" + httpUrlConnection.getResponseCode() + ", message=" + httpUrlConnection.getResponseMessage());
        }
        InputStream inputstream = null;
        try {
            inputstream = httpUrlConnection.getInputStream();
        }
        catch (IOException ex) {
            InputStream errStream = httpUrlConnection.getErrorStream();
            if (errStream != null) {
                errStream.close();
            }
            throw ex;
        }
        try {
            int readedByte;
            String responseContentType = httpUrlConnection.getContentType();
            boolean isValidContentType = false;
            if (responseContentType != null && responseContentType.equalsIgnoreCase("application/x-xipki-pkcs11")) {
                isValidContentType = true;
            }
            if (!isValidContentType) {
                throw new IOException("bad response: mime type " + responseContentType + " is not supported!");
            }
            byte[] buf = new byte[4096];
            ByteArrayOutputStream bytearrayoutputstream = new ByteArrayOutputStream();
            while ((readedByte = inputstream.read(buf)) != -1) {
                bytearrayoutputstream.write(buf, 0, readedByte);
            }
            byte[] byArray = bytearrayoutputstream.toByteArray();
            return byArray;
        }
        finally {
            inputstream.close();
        }
    }

    public byte[] send(short action, ASN1Object content) throws P11TokenException {
        byte[] response;
        byte[] encodedContent;
        if (content == null) {
            encodedContent = null;
        } else {
            try {
                encodedContent = content.getEncoded();
            }
            catch (IOException ex) {
                throw new P11TokenException("could encode the content", ex);
            }
        }
        int bodyLen = 4;
        if (encodedContent != null) {
            bodyLen += encodedContent.length;
        }
        byte[] request = new byte[10 + bodyLen];
        IoUtil.writeShort((short)256, (byte[])request, (int)0);
        byte[] transactionId = this.randomTransactionId();
        System.arraycopy(transactionId, 0, request, 2, 4);
        IoUtil.writeInt((int)bodyLen, (byte[])request, (int)6);
        IoUtil.writeShort((short)action, (byte[])request, (int)10);
        IoUtil.writeShort((short)this.moduleId, (byte[])request, (int)12);
        if (encodedContent != null) {
            System.arraycopy(encodedContent, 0, request, 14, encodedContent.length);
        }
        try {
            response = this.send(request);
        }
        catch (IOException ex) {
            String msg = "could not send the request";
            LOG.error("could not send the request {}", (Object)request);
            throw new P11TokenException("could not send the request: " + ex.getMessage(), ex);
        }
        int respLen = response.length;
        if (respLen < 12) {
            throw new P11TokenException("response too short");
        }
        int respBodyLen = IoUtil.parseInt((byte[])response, (int)6);
        if (respBodyLen + 10 != respLen) {
            throw new P11TokenException("message lengt unmatch");
        }
        short rc = IoUtil.parseShort((byte[])response, (int)10);
        if (rc != 0) {
            throw new P11TokenException("server returned RC " + P11ProxyConstants.getReturnCodeName(rc));
        }
        short respVersion = IoUtil.parseShort((byte[])response, (int)0);
        if (256 != respVersion) {
            throw new P11TokenException("version of response and request unmatch");
        }
        if (!ProxyP11Module.equals(transactionId, response, 2)) {
            throw new P11TokenException("version of response and request unmatch");
        }
        if (respLen < 14) {
            throw new P11TokenException("too short successful response");
        }
        short respAction = IoUtil.parseShort((byte[])response, (int)12);
        if (action != respAction) {
            throw new P11TokenException("action of response and request unmatch");
        }
        int respContentLen = respLen - 14;
        if (respContentLen == 0) {
            return null;
        }
        byte[] respContent = new byte[respContentLen];
        System.arraycopy(response, 14, respContent, 0, respContentLen);
        return respContent;
    }

    private byte[] randomTransactionId() {
        byte[] tid = new byte[4];
        this.random.nextBytes(tid);
        return tid;
    }

    private static boolean equals(byte[] bytes, byte[] bytesB, int offsetB) {
        if (bytesB.length - offsetB < bytes.length) {
            return false;
        }
        for (int i = 0; i < bytes.length; ++i) {
            if (bytes[i] == bytesB[offsetB + i]) continue;
            return false;
        }
        return true;
    }
}

