/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.pkcs11.provider;

import java.io.ByteArrayOutputStream;
import java.security.AlgorithmParameters;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.MGF1ParameterSpec;
import java.security.spec.PSSParameterSpec;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.crypto.AsymmetricBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.CryptoException;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.crypto.signers.PSSSigner;
import org.bouncycastle.jcajce.provider.util.DigestFactory;
import org.xipki.security.pkcs11.P11PlainRSASigner;
import org.xipki.security.pkcs11.P11RSAKeyParameter;
import org.xipki.security.pkcs11.provider.P11PrivateKey;

public class P11RSAPSSSignatureSpi
extends SignatureSpi {
    private AlgorithmParameters engineParams;
    private PSSParameterSpec paramSpec;
    private PSSParameterSpec originalSpec;
    private P11PlainRSASigner signer = new P11PlainRSASigner();
    private Digest contentDigest;
    private Digest mgfDigest;
    private int saltLength;
    private byte trailer;
    private boolean isRaw;
    private P11PrivateKey signingKey;
    private PSSSigner pss;

    protected P11RSAPSSSignatureSpi(PSSParameterSpec paramSpecArg) {
        this(paramSpecArg, false);
    }

    protected P11RSAPSSSignatureSpi(PSSParameterSpec baseParamSpec, boolean isRaw) {
        this.originalSpec = baseParamSpec;
        this.paramSpec = baseParamSpec == null ? PSSParameterSpec.DEFAULT : baseParamSpec;
        this.mgfDigest = DigestFactory.getDigest((String)this.paramSpec.getDigestAlgorithm());
        this.saltLength = this.paramSpec.getSaltLength();
        this.trailer = this.getTrailer(this.paramSpec.getTrailerField());
        this.isRaw = isRaw;
        this.setupContentDigest();
    }

    @Override
    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        throw new UnsupportedOperationException("engineInitVerify unsupported");
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey, SecureRandom random) throws InvalidKeyException {
        if (!(privateKey instanceof P11PrivateKey)) {
            throw new InvalidKeyException("privateKey is not instanceof " + P11PrivateKey.class.getName());
        }
        String algo = privateKey.getAlgorithm();
        if (!"RSA".equals(algo)) {
            throw new InvalidKeyException("privateKey is not an RSA private key: " + algo);
        }
        this.signingKey = (P11PrivateKey)privateKey;
        this.pss = new PSSSigner((AsymmetricBlockCipher)this.signer, this.contentDigest, this.mgfDigest, this.saltLength, this.trailer);
        P11RSAKeyParameter p11KeyParam = P11RSAKeyParameter.getInstance(this.signingKey.p11CryptService(), this.signingKey.identityId());
        if (random == null) {
            this.pss.init(true, (CipherParameters)p11KeyParam);
        } else {
            this.pss.init(true, (CipherParameters)new ParametersWithRandom((CipherParameters)p11KeyParam, random));
        }
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        this.engineInitSign(privateKey, null);
    }

    @Override
    protected void engineUpdate(byte input) throws SignatureException {
        this.pss.update(input);
    }

    @Override
    protected void engineUpdate(byte[] input, int off, int len) throws SignatureException {
        this.pss.update(input, off, len);
    }

    @Override
    protected byte[] engineSign() throws SignatureException {
        try {
            return this.pss.generateSignature();
        }
        catch (CryptoException ex) {
            throw new SignatureException(ex.getMessage(), ex);
        }
    }

    @Override
    protected boolean engineVerify(byte[] sigBytes) throws SignatureException {
        throw new UnsupportedOperationException("engineVerify unsupported");
    }

    @Override
    protected void engineSetParameter(AlgorithmParameterSpec params) throws InvalidParameterException {
        Digest newDigest;
        PSSParameterSpec newParamSpec;
        if (params instanceof PSSParameterSpec) {
            newParamSpec = (PSSParameterSpec)params;
            if (this.originalSpec != null && !DigestFactory.isSameDigest((String)this.originalSpec.getDigestAlgorithm(), (String)newParamSpec.getDigestAlgorithm())) {
                throw new InvalidParameterException("parameter must be using " + this.originalSpec.getDigestAlgorithm());
            }
            if (!newParamSpec.getMGFAlgorithm().equalsIgnoreCase("MGF1") && !newParamSpec.getMGFAlgorithm().equals(PKCSObjectIdentifiers.id_mgf1.getId())) {
                throw new InvalidParameterException("unknown mask generation function specified");
            }
            if (!(newParamSpec.getMGFParameters() instanceof MGF1ParameterSpec)) {
                throw new InvalidParameterException("unkown MGF parameters");
            }
            MGF1ParameterSpec mgfParams = (MGF1ParameterSpec)newParamSpec.getMGFParameters();
            if (!DigestFactory.isSameDigest((String)mgfParams.getDigestAlgorithm(), (String)newParamSpec.getDigestAlgorithm())) {
                throw new InvalidParameterException("digest algorithm for MGF should be the same as for PSS parameters.");
            }
            newDigest = DigestFactory.getDigest((String)mgfParams.getDigestAlgorithm());
            if (newDigest == null) {
                throw new InvalidParameterException("no match on MGF digest algorithm: " + mgfParams.getDigestAlgorithm());
            }
        } else {
            throw new InvalidParameterException("only PSSParameterSpec supported");
        }
        this.engineParams = null;
        this.paramSpec = newParamSpec;
        this.mgfDigest = newDigest;
        this.saltLength = this.paramSpec.getSaltLength();
        this.trailer = this.getTrailer(this.paramSpec.getTrailerField());
        this.setupContentDigest();
    }

    @Override
    protected void engineSetParameter(String param, Object value) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    @Override
    protected AlgorithmParameters engineGetParameters() {
        if (this.engineParams == null && this.paramSpec != null) {
            try {
                this.engineParams = AlgorithmParameters.getInstance("PSS", "BC");
                this.engineParams.init(this.paramSpec);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex.getMessage(), ex);
            }
        }
        return this.engineParams;
    }

    @Override
    protected Object engineGetParameter(String param) {
        throw new UnsupportedOperationException("engineGetParameter unsupported");
    }

    private byte getTrailer(int trailerField) {
        if (trailerField == 1) {
            return -68;
        }
        throw new IllegalArgumentException("unknown trailer field");
    }

    private void setupContentDigest() {
        this.contentDigest = this.isRaw ? new NullPssDigest(this.mgfDigest) : this.mgfDigest;
    }

    private static class NullPssDigest
    implements Digest {
        private ByteArrayOutputStream baOut = new ByteArrayOutputStream();
        private Digest baseDigest;
        private boolean oddTime = true;

        NullPssDigest(Digest mgfDigest) {
            this.baseDigest = mgfDigest;
        }

        public String getAlgorithmName() {
            return "NULL";
        }

        public int getDigestSize() {
            return this.baseDigest.getDigestSize();
        }

        public void update(byte in) {
            this.baOut.write(in);
        }

        public void update(byte[] in, int inOff, int len) {
            this.baOut.write(in, inOff, len);
        }

        public int doFinal(byte[] out, int outOff) {
            byte[] res = this.baOut.toByteArray();
            if (this.oddTime) {
                System.arraycopy(res, 0, out, outOff, res.length);
            } else {
                this.baseDigest.update(res, 0, res.length);
                this.baseDigest.doFinal(out, outOff);
            }
            this.reset();
            this.oddTime = !this.oddTime;
            return res.length;
        }

        public void reset() {
            this.baOut.reset();
            this.baseDigest.reset();
        }
    }

    public static class SHA3_512withRSA
    extends P11RSAPSSSignatureSpi {
        public SHA3_512withRSA() {
            super(new PSSParameterSpec("SHA3-512", "MGF1", new MGF1ParameterSpec("SHA3-512"), 64, 1));
        }
    }

    public static class SHA3_384withRSA
    extends P11RSAPSSSignatureSpi {
        public SHA3_384withRSA() {
            super(new PSSParameterSpec("SHA3-384", "MGF1", new MGF1ParameterSpec("SHA3-384"), 48, 1));
        }
    }

    public static class SHA3_256withRSA
    extends P11RSAPSSSignatureSpi {
        public SHA3_256withRSA() {
            super(new PSSParameterSpec("SHA3-256", "MGF1", new MGF1ParameterSpec("SHA3-256"), 32, 1));
        }
    }

    public static class SHA3_224withRSA
    extends P11RSAPSSSignatureSpi {
        public SHA3_224withRSA() {
            super(new PSSParameterSpec("SHA3-224", "MGF1", new MGF1ParameterSpec("SHA3-224"), 28, 1));
        }
    }

    public static class SHA512withRSA
    extends P11RSAPSSSignatureSpi {
        public SHA512withRSA() {
            super(new PSSParameterSpec("SHA-512", "MGF1", new MGF1ParameterSpec("SHA-512"), 64, 1));
        }
    }

    public static class SHA384withRSA
    extends P11RSAPSSSignatureSpi {
        public SHA384withRSA() {
            super(new PSSParameterSpec("SHA-384", "MGF1", new MGF1ParameterSpec("SHA-384"), 48, 1));
        }
    }

    public static class SHA256withRSA
    extends P11RSAPSSSignatureSpi {
        public SHA256withRSA() {
            super(new PSSParameterSpec("SHA-256", "MGF1", new MGF1ParameterSpec("SHA-256"), 32, 1));
        }
    }

    public static class SHA224withRSA
    extends P11RSAPSSSignatureSpi {
        public SHA224withRSA() {
            super(new PSSParameterSpec("SHA-224", "MGF1", new MGF1ParameterSpec("SHA-224"), 28, 1));
        }
    }

    public static class SHA1withRSA
    extends P11RSAPSSSignatureSpi {
        public SHA1withRSA() {
            super(PSSParameterSpec.DEFAULT);
        }
    }

    public static class PSSwithRSA
    extends P11RSAPSSSignatureSpi {
        public PSSwithRSA() {
            super(null);
        }
    }

    public static class NonePSS
    extends P11RSAPSSSignatureSpi {
        public NonePSS() {
            super(null, true);
        }
    }
}

