/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.pkcs11;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xipki.common.InvalidConfException;
import org.xipki.common.util.CollectionUtil;
import org.xipki.common.util.ParamUtil;
import org.xipki.common.util.StringUtil;
import org.xipki.password.PasswordResolver;
import org.xipki.security.pkcs11.P11MechanismFilter;
import org.xipki.security.pkcs11.P11PasswordsRetriever;
import org.xipki.security.pkcs11.P11SlotIdFilter;
import org.xipki.security.pkcs11.P11SlotIdentifier;
import org.xipki.security.pkcs11.Pkcs11Functions;
import org.xipki.security.pkcs11.jaxb.MechanismSetsType;
import org.xipki.security.pkcs11.jaxb.MechanismsType;
import org.xipki.security.pkcs11.jaxb.ModuleType;
import org.xipki.security.pkcs11.jaxb.NativeLibraryType;
import org.xipki.security.pkcs11.jaxb.PasswordSetsType;
import org.xipki.security.pkcs11.jaxb.PasswordsType;
import org.xipki.security.pkcs11.jaxb.SlotType;
import org.xipki.security.pkcs11.jaxb.SlotsType;

public class P11ModuleConf {
    private static final Logger LOG = LoggerFactory.getLogger(P11ModuleConf.class);
    private final String name;
    private final String nativeLibrary;
    private final boolean readOnly;
    private final Set<P11SlotIdFilter> excludeSlots;
    private final Set<P11SlotIdFilter> includeSlots;
    private final P11PasswordsRetriever passwordRetriever;
    private final P11MechanismFilter mechanismFilter;
    private final int maxMessageSize;
    private final long userType;

    public P11ModuleConf(ModuleType moduleType, PasswordResolver passwordResolver) throws InvalidConfException {
        ParamUtil.requireNonNull((String)"moduleType", (Object)moduleType);
        this.name = moduleType.getName();
        this.readOnly = moduleType.isReadonly();
        this.userType = moduleType.getUser();
        this.maxMessageSize = moduleType.getMaxMessageSize();
        if (this.maxMessageSize < 128) {
            throw new InvalidConfException("invalid maxMessageSize (< 128): " + this.maxMessageSize);
        }
        this.mechanismFilter = new P11MechanismFilter();
        MechanismSetsType mechsList = moduleType.getMechanismSets();
        if (mechsList != null && CollectionUtil.isNonEmpty(mechsList.getMechanisms())) {
            for (MechanismsType mechanismsType : mechsList.getMechanisms()) {
                Set<P11SlotIdFilter> slots = P11ModuleConf.getSlotIdFilters(mechanismsType.getSlots());
                HashSet<Long> mechanisms = new HashSet<Long>();
                for (String mechStr : mechanismsType.getMechanism()) {
                    Long mech = null;
                    if (mechStr.startsWith("CKM_")) {
                        mech = Pkcs11Functions.mechanismStringToCode(mechStr);
                    } else {
                        int radix = 10;
                        String value = mechStr.toLowerCase();
                        if (value.startsWith("0x")) {
                            radix = 16;
                            value = value.substring(2);
                        }
                        if (value.endsWith("l")) {
                            value = value.substring(0, value.length() - 1);
                        }
                        try {
                            mech = Long.parseLong(value, radix);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    if (mech == null) {
                        LOG.warn("skipped unknown mechanism '" + mechStr + "'");
                        continue;
                    }
                    mechanisms.add(mech);
                }
                this.mechanismFilter.addEntry(slots, mechanisms);
            }
        }
        this.passwordRetriever = new P11PasswordsRetriever();
        PasswordSetsType passwordsList = moduleType.getPasswordSets();
        if (passwordsList != null && CollectionUtil.isNonEmpty(passwordsList.getPasswords())) {
            this.passwordRetriever.setPasswordResolver(passwordResolver);
            for (PasswordsType passwordType : passwordsList.getPasswords()) {
                Set<P11SlotIdFilter> slots = P11ModuleConf.getSlotIdFilters(passwordType.getSlots());
                this.passwordRetriever.addPasswordEntry(slots, new ArrayList<String>(passwordType.getPassword()));
            }
        }
        this.includeSlots = P11ModuleConf.getSlotIdFilters(moduleType.getIncludeSlots());
        this.excludeSlots = P11ModuleConf.getSlotIdFilters(moduleType.getExcludeSlots());
        String string = System.getProperty("os.name").toLowerCase();
        String nativeLibraryPath = null;
        for (NativeLibraryType library : moduleType.getNativeLibraries().getNativeLibrary()) {
            List<String> osNames = library.getOs();
            if (CollectionUtil.isEmpty(osNames)) {
                nativeLibraryPath = library.getPath();
            } else {
                for (String entry : osNames) {
                    if (!string.contains(entry.toLowerCase())) continue;
                    nativeLibraryPath = library.getPath();
                    break;
                }
            }
            if (nativeLibraryPath == null) continue;
            break;
        }
        if (nativeLibraryPath == null) {
            throw new InvalidConfException("could not find PKCS#11 library for OS " + string);
        }
        this.nativeLibrary = nativeLibraryPath;
    }

    public String name() {
        return this.name;
    }

    public String nativeLibrary() {
        return this.nativeLibrary;
    }

    public int maxMessageSize() {
        return this.maxMessageSize;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public long userType() {
        return this.userType;
    }

    public P11PasswordsRetriever passwordRetriever() {
        return this.passwordRetriever;
    }

    public boolean isSlotIncluded(P11SlotIdentifier slotId) {
        boolean included;
        ParamUtil.requireNonNull((String)"slotId", (Object)slotId);
        if (CollectionUtil.isEmpty(this.includeSlots)) {
            included = true;
        } else {
            included = false;
            for (P11SlotIdFilter entry : this.includeSlots) {
                if (!entry.match(slotId)) continue;
                included = true;
                break;
            }
        }
        if (!included) {
            return false;
        }
        if (CollectionUtil.isEmpty(this.excludeSlots)) {
            return included;
        }
        for (P11SlotIdFilter entry : this.excludeSlots) {
            if (!entry.match(slotId)) continue;
            return false;
        }
        return true;
    }

    public P11MechanismFilter p11MechanismFilter() {
        return this.mechanismFilter;
    }

    private static Set<P11SlotIdFilter> getSlotIdFilters(SlotsType type) throws InvalidConfException {
        if (type == null || CollectionUtil.isEmpty(type.getSlot())) {
            return null;
        }
        HashSet<P11SlotIdFilter> filters = new HashSet<P11SlotIdFilter>();
        for (SlotType slotType : type.getSlot()) {
            Long slotId = null;
            if (slotType.getId() != null) {
                String str = slotType.getId().trim();
                try {
                    slotId = StringUtil.startsWithIgnoreCase((String)str, (String)"0X") ? Long.parseLong(str.substring(2), 16) : Long.parseLong(str);
                }
                catch (NumberFormatException ex) {
                    String message = "invalid slotId '" + str + "'";
                    LOG.error(message);
                    throw new InvalidConfException(message);
                }
            }
            filters.add(new P11SlotIdFilter(slotType.getIndex(), slotId));
        }
        return filters;
    }
}

