/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.pkcs11;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.xipki.common.util.CollectionUtil;
import org.xipki.common.util.ParamUtil;
import org.xipki.security.pkcs11.P11SlotIdFilter;
import org.xipki.security.pkcs11.P11SlotIdentifier;

public class P11MechanismFilter {
    private final List<SingleFilter> singleFilters = new LinkedList<SingleFilter>();

    P11MechanismFilter() {
    }

    void addEntry(Set<P11SlotIdFilter> slots, Collection<Long> mechanisms) {
        this.singleFilters.add(new SingleFilter(slots, mechanisms));
    }

    public boolean isMechanismPermitted(P11SlotIdentifier slotId, long mechanism) {
        ParamUtil.requireNonNull((String)"slotId", (Object)slotId);
        if (CollectionUtil.isEmpty(this.singleFilters)) {
            return true;
        }
        for (SingleFilter sr : this.singleFilters) {
            if (!sr.match(slotId)) continue;
            return sr.isMechanismSupported(mechanism);
        }
        return true;
    }

    private static final class SingleFilter {
        private final Set<P11SlotIdFilter> slots;
        private final Collection<Long> mechanisms;

        private SingleFilter(Set<P11SlotIdFilter> slots, Collection<Long> mechanisms) {
            this.slots = slots;
            this.mechanisms = CollectionUtil.isEmpty(mechanisms) ? null : mechanisms;
        }

        public boolean match(P11SlotIdentifier slot) {
            if (this.slots == null) {
                return true;
            }
            for (P11SlotIdFilter m : this.slots) {
                if (!m.match(slot)) continue;
                return true;
            }
            return false;
        }

        public boolean isMechanismSupported(long mechanism) {
            if (this.mechanisms == null) {
                return true;
            }
            return this.mechanisms.contains(mechanism);
        }
    }
}

