/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.pkcs11;

import org.xipki.common.util.ParamUtil;
import org.xipki.security.pkcs11.P11ObjectIdentifier;
import org.xipki.security.pkcs11.P11SlotIdentifier;

public class P11EntityIdentifier
implements Comparable<P11EntityIdentifier> {
    private final P11SlotIdentifier slotId;
    private final P11ObjectIdentifier objectId;

    public P11EntityIdentifier(P11SlotIdentifier slotId, P11ObjectIdentifier objectId) {
        this.slotId = (P11SlotIdentifier)ParamUtil.requireNonNull((String)"slotId", (Object)slotId);
        this.objectId = (P11ObjectIdentifier)ParamUtil.requireNonNull((String)"objectId", (Object)objectId);
    }

    public P11SlotIdentifier slotId() {
        return this.slotId;
    }

    public P11ObjectIdentifier objectId() {
        return this.objectId;
    }

    @Override
    public int compareTo(P11EntityIdentifier obj) {
        int ct = this.slotId.compareTo(obj.slotId);
        if (ct != 0) {
            return ct;
        }
        return this.objectId.compareTo(obj.objectId);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof P11EntityIdentifier)) {
            return false;
        }
        P11EntityIdentifier ei = (P11EntityIdentifier)obj;
        return this.slotId.equals(ei.slotId) && this.objectId.equals(ei.objectId);
    }

    public boolean match(P11SlotIdentifier slotId, String objectLabel) {
        ParamUtil.requireNonNull((String)"objectLabel", (Object)objectLabel);
        return this.slotId.equals(slotId) && objectLabel.equals(this.objectId.label());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("slot ").append(this.slotId);
        sb.append(", object ").append(this.objectId);
        return sb.toString();
    }

    public int hashCode() {
        int hashCode = this.slotId.hashCode();
        return hashCode + 31 * this.objectId.hashCode();
    }
}

