/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.pkcs11;

import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.HashSet;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.xipki.common.util.ParamUtil;
import org.xipki.security.ConcurrentContentSigner;
import org.xipki.security.DefaultConcurrentContentSigner;
import org.xipki.security.SecurityFactory;
import org.xipki.security.bc.XiContentSigner;
import org.xipki.security.exception.P11TokenException;
import org.xipki.security.exception.XiSecurityException;
import org.xipki.security.pkcs11.P11CryptService;
import org.xipki.security.pkcs11.P11DSAContentSigner;
import org.xipki.security.pkcs11.P11ECDSAContentSigner;
import org.xipki.security.pkcs11.P11EntityIdentifier;
import org.xipki.security.pkcs11.P11Identity;
import org.xipki.security.pkcs11.P11RSAContentSigner;
import org.xipki.security.pkcs11.P11RSAPSSContentSigner;
import org.xipki.security.pkcs11.provider.P11PrivateKey;
import org.xipki.security.util.AlgorithmUtil;
import org.xipki.security.util.X509Util;

public class P11ContentSignerBuilder {
    private final PublicKey publicKey;
    private final X509Certificate[] certificateChain;
    private final P11CryptService cryptService;
    private final SecurityFactory securityFactory;
    private final P11EntityIdentifier identityId;

    public P11ContentSignerBuilder(P11CryptService cryptService, SecurityFactory securityFactory, P11EntityIdentifier identityId, X509Certificate[] certificateChain) throws XiSecurityException, P11TokenException {
        int i;
        X509Certificate cert;
        PublicKey publicKeyInP11;
        this.cryptService = (P11CryptService)ParamUtil.requireNonNull((String)"cryptService", (Object)cryptService);
        this.securityFactory = (SecurityFactory)ParamUtil.requireNonNull((String)"securityFactory", (Object)securityFactory);
        this.identityId = (P11EntityIdentifier)ParamUtil.requireNonNull((String)"identityId", (Object)identityId);
        P11Identity identity = cryptService.getIdentity(identityId);
        X509Certificate signerCertInP11 = identity.certificate();
        PublicKey publicKey = publicKeyInP11 = signerCertInP11 != null ? signerCertInP11.getPublicKey() : identity.publicKey();
        if (publicKeyInP11 == null) {
            throw new XiSecurityException("public key with " + identityId + " does not exist");
        }
        HashSet<X509Certificate> caCerts = new HashSet<X509Certificate>();
        if (certificateChain != null && certificateChain.length > 0) {
            int n = certificateChain.length;
            cert = certificateChain[0];
            if (n > 1) {
                for (i = 1; i < n; ++i) {
                    caCerts.add(certificateChain[i]);
                }
            }
            this.publicKey = cert.getPublicKey();
        } else {
            this.publicKey = publicKeyInP11;
            cert = signerCertInP11;
        }
        if (cert != null) {
            X509Certificate[] certsInKeystore = identity.certificateChain();
            if (certsInKeystore != null && certsInKeystore.length > 1) {
                for (i = 1; i < certsInKeystore.length; ++i) {
                    caCerts.add(certsInKeystore[i]);
                }
            }
            this.certificateChain = X509Util.buildCertPath(cert, caCerts);
        } else {
            this.certificateChain = null;
        }
    }

    public ConcurrentContentSigner createSigner(AlgorithmIdentifier signatureAlgId, int parallelism) throws XiSecurityException, P11TokenException {
        DefaultConcurrentContentSigner concurrentSigner;
        ParamUtil.requireMin((String)"parallelism", (int)parallelism, (int)1);
        if (this.publicKey instanceof RSAPublicKey) {
            if (!AlgorithmUtil.isRSASigAlgId(signatureAlgId)) {
                throw new XiSecurityException("the given algorithm is not a valid RSA signature algorithm '" + signatureAlgId.getAlgorithm().getId() + "'");
            }
        } else if (this.publicKey instanceof ECPublicKey) {
            if (!AlgorithmUtil.isECSigAlg(signatureAlgId)) {
                throw new XiSecurityException("the given algorithm is not a valid EC signature algorithm '" + signatureAlgId.getAlgorithm().getId() + "'");
            }
        } else if (this.publicKey instanceof DSAPublicKey) {
            if (!AlgorithmUtil.isDSASigAlg(signatureAlgId)) {
                throw new XiSecurityException("the given algorithm is not a valid DSA signature algorithm '" + signatureAlgId.getAlgorithm().getId() + "'");
            }
        } else {
            throw new XiSecurityException("unsupported key " + this.publicKey.getClass().getName());
        }
        ArrayList<XiContentSigner> signers = new ArrayList<XiContentSigner>(parallelism);
        for (int i = 0; i < parallelism; ++i) {
            XiContentSigner signer;
            if (this.publicKey instanceof RSAPublicKey) {
                signer = this.createRSAContentSigner(signatureAlgId);
            } else if (this.publicKey instanceof ECPublicKey) {
                signer = this.createECContentSigner(signatureAlgId);
            } else if (this.publicKey instanceof DSAPublicKey) {
                signer = this.createDSAContentSigner(signatureAlgId);
            } else {
                throw new XiSecurityException("unsupported key " + this.publicKey.getClass().getName());
            }
            signers.add(signer);
        }
        boolean mac = false;
        P11PrivateKey privateKey = new P11PrivateKey(this.cryptService, this.identityId);
        try {
            concurrentSigner = new DefaultConcurrentContentSigner(false, signers, privateKey);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new XiSecurityException(ex.getMessage(), ex);
        }
        if (this.certificateChain != null) {
            concurrentSigner.setCertificateChain(this.certificateChain);
        } else {
            concurrentSigner.setPublicKey(this.publicKey);
        }
        return concurrentSigner;
    }

    private XiContentSigner createRSAContentSigner(AlgorithmIdentifier signatureAlgId) throws XiSecurityException, P11TokenException {
        if (PKCSObjectIdentifiers.id_RSASSA_PSS.equals((Object)signatureAlgId.getAlgorithm())) {
            return new P11RSAPSSContentSigner(this.cryptService, this.identityId, signatureAlgId, this.securityFactory.getRandom4Sign());
        }
        return new P11RSAContentSigner(this.cryptService, this.identityId, signatureAlgId);
    }

    private XiContentSigner createECContentSigner(AlgorithmIdentifier signatureAlgId) throws XiSecurityException, P11TokenException {
        return new P11ECDSAContentSigner(this.cryptService, this.identityId, signatureAlgId, AlgorithmUtil.isDSAPlainSigAlg(signatureAlgId));
    }

    private XiContentSigner createDSAContentSigner(AlgorithmIdentifier signatureAlgId) throws XiSecurityException, P11TokenException {
        return new P11DSAContentSigner(this.cryptService, this.identityId, signatureAlgId, AlgorithmUtil.isDSAPlainSigAlg(signatureAlgId));
    }
}

