/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security.bc;

import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.crypto.DSA;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.ExtendedDigest;
import org.bouncycastle.crypto.Signer;
import org.bouncycastle.crypto.signers.ECDSASigner;
import org.bouncycastle.operator.DigestAlgorithmIdentifierFinder;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.bc.BcECContentVerifierProviderBuilder;
import org.xipki.security.pkcs12.DSAPlainDigestSigner;
import org.xipki.security.util.AlgorithmUtil;

public class XipkiECContentVerifierProviderBuilder
extends BcECContentVerifierProviderBuilder {
    private DigestAlgorithmIdentifierFinder digestAlgorithmFinder;

    public XipkiECContentVerifierProviderBuilder(DigestAlgorithmIdentifierFinder digestAlgorithmFinder) {
        super(digestAlgorithmFinder);
        this.digestAlgorithmFinder = digestAlgorithmFinder;
    }

    protected Signer createSigner(AlgorithmIdentifier sigAlgId) throws OperatorCreationException {
        boolean plainDsa = AlgorithmUtil.isPlainECDSASigAlg(sigAlgId);
        if (!plainDsa) {
            return super.createSigner(sigAlgId);
        }
        AlgorithmIdentifier digAlg = this.digestAlgorithmFinder.find(sigAlgId);
        ExtendedDigest dig = this.digestProvider.get(digAlg);
        return new DSAPlainDigestSigner((DSA)new ECDSASigner(), (Digest)dig);
    }
}

