/*
 * Decompiled with CFR 0.152.
 */
package org.xipki.security;

import java.io.IOException;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.util.Arrays;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.operator.RuntimeOperatorException;
import org.xipki.common.util.ParamUtil;
import org.xipki.security.bc.XiContentSigner;
import org.xipki.security.exception.XiSecurityException;

public class SignatureSigner
implements XiContentSigner {
    private final AlgorithmIdentifier sigAlgId;
    private final byte[] encodedSigAlgId;
    private final Signature signer;
    private final SignatureStream stream = new SignatureStream();
    private final PrivateKey key;

    public SignatureSigner(AlgorithmIdentifier sigAlgId, Signature signer, PrivateKey key) throws XiSecurityException {
        this.sigAlgId = (AlgorithmIdentifier)ParamUtil.requireNonNull((String)"sigAlgId", (Object)sigAlgId);
        this.signer = (Signature)ParamUtil.requireNonNull((String)"signer", (Object)signer);
        this.key = (PrivateKey)ParamUtil.requireNonNull((String)"key", (Object)key);
        try {
            this.encodedSigAlgId = sigAlgId.getEncoded();
        }
        catch (IOException ex) {
            throw new XiSecurityException("could not encode AlgorithmIdentifier", ex);
        }
    }

    public AlgorithmIdentifier getAlgorithmIdentifier() {
        return this.sigAlgId;
    }

    @Override
    public byte[] getEncodedAlgorithmIdentifier() {
        return Arrays.copyOf(this.encodedSigAlgId, this.encodedSigAlgId.length);
    }

    public OutputStream getOutputStream() {
        try {
            this.signer.initSign(this.key);
        }
        catch (InvalidKeyException ex) {
            throw new RuntimeOperatorException("could not initSign", (Throwable)ex);
        }
        return this.stream;
    }

    public byte[] getSignature() {
        try {
            return this.stream.getSignature();
        }
        catch (SignatureException ex) {
            throw new RuntimeOperatorException("exception obtaining signature: " + ex.getMessage(), (Throwable)ex);
        }
    }

    private class SignatureStream
    extends OutputStream {
        private SignatureStream() {
        }

        public byte[] getSignature() throws SignatureException {
            return SignatureSigner.this.signer.sign();
        }

        @Override
        public void write(int singleByte) throws IOException {
            try {
                SignatureSigner.this.signer.update((byte)singleByte);
            }
            catch (SignatureException ex) {
                throw new IOException(ex.getMessage(), ex);
            }
        }

        @Override
        public void write(byte[] bytes) throws IOException {
            try {
                SignatureSigner.this.signer.update(bytes);
            }
            catch (SignatureException ex) {
                throw new IOException(ex.getMessage(), ex);
            }
        }

        @Override
        public void write(byte[] bytes, int off, int len) throws IOException {
            try {
                SignatureSigner.this.signer.update(bytes, off, len);
            }
            catch (SignatureException ex) {
                throw new IOException(ex.getMessage(), ex);
            }
        }
    }
}

